﻿//////////////////////////////////////////////////////////////////////////////
// ReadCustomerHistoryRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest.Tests.Requests
{
    [TestClass]
    public class ReadCustomerHistoryRequestTest
    {
        [TestMethod]
        public void ReadCustomerHistoryRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""customerHistory"",""guid"":443344,""amount"":5}}";

            ReadCustomerHistoryRequest temp = new ReadCustomerHistoryRequest();
            temp.apiVersion = ReadCustomerHistoryRequest.JSapiVersion.one_point_zero;
            temp.body.amount = 5;
            temp.body.guid = 443344;


            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);
        }
    }
}
