﻿//////////////////////////////////////////////////////////////////////////////
// JEncoder.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////


using EncoderDecoder.Requests;
using System;
using System.Text.RegularExpressions;

namespace EncoderDecoder
{
    /// <summary>
    /// Used to serialize objects into JSON representations
    /// </summary>
    public class JEncoder
    {
        /// <summary>
        /// Encodes requests into JSON strings
        /// </summary>
        /// <param name="request"></param>
        /// <returns>Encode JSON String</returns>
        public String Encode(IBaseRequest request)
        {
            String s = request.Encode();
            return s;
        }

        /// <summary>
        /// Removes unwanted characters from the json string i.e. returns and newlines
        /// </summary>
        /// <param name="json"></param>
        /// <returns>Formated string.</returns>
        public String FormatJSON(String json){

            String s = json;

            // Remove formatting
            s = Regex.Replace(s, @"\r+", "");
            s = Regex.Replace(s, @"\n+", "");

            return s;
        }

        /// <summary>
        /// Converts to unixtime( Milliseconds since 01-01-1970) from a DateTime object
        /// </summary>
        /// <param name="date"></param>
        /// <returns>long</returns>
        public static long ConvertToUnixTime(DateTime date)
        {
            var epoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
            return Convert.ToInt64((date - epoch).TotalMilliseconds);
        }
    }
}
