﻿//////////////////////////////////////////////////////////////////////////////
// Notification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////


using EncoderDecoder.Notifications;
using System;
using System.Collections.Generic;

namespace EncoderDecoder
{
    /// <summary>
    /// Represents the full set of notifications we receive
    /// </summary>
    class Notification
    {
        // Dictionary used to map notification types with their object model.
        private static readonly Dictionary<string, IBaseNotification> Notifications = new Dictionary<string, IBaseNotification>()
        {
            { "ACTIVEAGENTNOTIFICATION", new AgentActiveNotification() },
            { "CHANGECONFERENCEOWNER", new AgentChangeConferenceOwnerNotification() },
            { "COMPLETECONFERENCE", new AgentCompleteConferenceNotification() },
            { "EXITROOM", new AgentExitRoomNotification() },
            { "GETOBSERVEDINTRINSICS", new AgentGetObservedIntrinsicsNotification() },
            { "AGENTJOINROOM", new AgentJoinRoomNotification() },
            { "AGENTLOGIN", new AgentLoginNotification() },
            { "OPERATIONREQUEST", new AgentOperationNotification() },
            { "AGENTQUITCHAT", new AgentQuitChatNotification() },
            { "AGENTSETCLOSEDREASON", new AgentSetClosedReasonNotification() },
            { "NEWWHISPERMESSAGE", new AgentWhisperMessageNotification() },
            { "CUSTOMERDISCONNECT", new CustomerDisconnectNotification() },
            { "CUSTOMERCONNECTIONSTATUS", new CustomerConnectionStatusNotification() },
            { "GETDESTINATIONS", new GetDestinationsNotification() },
            { "ISTYPING", new IsTypingNotification() },
            { "NEWMESSAGE", new NewMessageNotification() },
            { "AGENTDATA", new AgentDataNotification() },
            { "CUSTOMERHISTORY", new ReadCustomerHistoryNotification() },
            { "PAGEPUSH", new NewPagePushNotification() },
            { "SUPERVISORBARGE", new SupervisorBargeNotification() },
            { "SCREENPOPS", new ScreenPopsNotification() }
        };

        /// <summary>
        /// Return the subtype of IBaseNotification from the notification type.
        /// </summary>
        /// <param name="notification"></param>
        /// <returns></returns>
        public IBaseNotification GetNotificationType(String notification)
        {
            return Notifications[notification.ToUpper()];
        }
    }
}
