﻿//////////////////////////////////////////////////////////////////////////////
// GetDestinationsNotification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Newtonsoft.Json;
using System.Collections.Generic;

namespace EncoderDecoder.Notifications
{
    public class GetDestinationsNotification : IBaseNotification
    {
        public GetDestinationsNotification()
        {
            this.body = new Body();
        }

        public string apiVersion { get; set; }
        public string type { get; set; }
        public Body body { get; set; }

        public class Body
        {
            public Body()
            {
                queues = new List<Queue>();
            }
            public string method { get; set; }
            public long guid { get; set; }
            public bool allowTransferToSkillset { get; set; }
            public bool allowTransferToAgent { get; set; }
            public List<Queue> queues { get; set; }
        }

        public class Queue
        {
            public Queue()
            {
                agents = new List<Agent>();
            }
            public string queueName { get; set; }
            public long queueId { get; set; }
            public long queueCCMSId { get; set; }
            public string routepoint { get; set; }
            public List<Agent> agents { get; set; }
        }

        public class Agent
        {
            public string agentId { get; set; }
            public string displayName { get; set; }
        }

        /// <summary>
        /// Decodes this notifications and returns object representation.
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public IBaseNotification Decode(string json)
        {
            return JsonConvert.DeserializeObject<GetDestinationsNotification>(json);
        }

    }
}
