﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System;
using System.Runtime.Serialization;

namespace EncoderDecoder.Requests
{
    public abstract class BaseRequest : IBaseRequest
    {
        /// <summary>
        /// Encodes this object to JSON string.
        /// </summary>
        /// <returns>json encoded string.</returns>
        public abstract String Encode();

        /// <summary>
        /// Specifies the request method.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSmethod
        {
            [EnumMember(Value = "changeConferenceOwner")]
            changeConferenceOwner,
            [EnumMember(Value = "completeConference")]
            completeConference,
            [EnumMember(Value = "conferenceClose")]
            conferenceClose,
            [EnumMember(Value = "dropPassiveParticipant")]
            dropPassiveParticipant,
            [EnumMember(Value = "observedIntrinsicsRequest")]
            observedIntrinsicsRequest,
            [EnumMember(Value = "agentJoinRoom")]
            agentJoinRoom,
            [EnumMember(Value = "leaveRoom")]
            leaveRoom,
            [EnumMember(Value = "agentLogin")]
            agentLogin,
            [EnumMember(Value = "agentLogout")]
            agentLogout,
            [EnumMember(Value = "operationRequest")]
            operationRequest,
            [EnumMember(Value = "agentQuitChat")]
            agentQuitChat,
            [EnumMember(Value = "agentSetClosedReason")]
            agentSetClosedReason,
            [EnumMember(Value = "newWhisperMessage")]
            newWhisperMessage,
            [EnumMember(Value = "getDestinations")]
            getDestinations,
            [EnumMember(Value = "isTyping")]
            isTyping,
            [EnumMember(Value = "newMessage")]
            newMessage,
            [EnumMember(Value = "pagePush")]
            pagePush,
            [EnumMember(Value = "customerHistory")]
            customerHistory,
            [EnumMember(Value = "agentData")]
            agentData,
            [EnumMember(Value = "screenPops")]
            screenPops
        }

        /// <summary>
        /// Specifies the message type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSmessageType
        {
            normal,
            whisper
        }

        /// <summary>
        /// Specifies the client type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSclientType
        {
            custom,
            aaad,
            supervisor
        }

        /// <summary>
        /// Specifies the request type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JStype
        {
            request
        }

        /// <summary>
        /// Specifies the request api version.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSapiVersion
        {
            [EnumMember(Value = "1.0")] 
            one_point_zero,
            [EnumMember(Value = "1.1")] 
            one_point_one
        }

        /// <summary>
        /// Specifies the join type
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSjoinType
        {
            active,
            consult,
            observe
        }

        /// <summary>
        /// Specifies the page push destination
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSpagePushDestination
        {
            newBrowserWindow,
            newBrowserTab,
            currentWindow
        }

        /// <summary>
        /// Specifies the contact operation
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JScontactOperation
        {
            conference,
            transfer
        }

        /// <summary>
        /// Specifies the transfer/consult destination type
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum JSdestinationType
        {
            consult,
            agent,
            conference,
            queue,
            barge
        }
    }
}