﻿//////////////////////////////////////////////////////////////////////////////
// PopulateClosedReasonsTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Windows.Controls;

namespace EncoderDecoderUnitTest.Tests.GUI
{
    [TestClass]
    public class PopulateClosedReasonsTest
    {
        AgentJoinRoomNotification notification;
        CustomDesktop.UcChatWindow chatWindow;
        
        int agentId = 123;
        CustomDesktop.UcChatWindow.WindowType window = CustomDesktop.UcChatWindow.WindowType.NORMAL;

        Code crc0, crc1, crc2, crc3, crc4, crc5, crc6;
        ClosedReasonCodes closingCodes;

        [TestInitialize()]
        public void BeforeTest()
        {
            notification = new AgentJoinRoomNotification();
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            closingCodes = new ClosedReasonCodes();

            crc0 = new Code();
            crc0.id = 33;
            crc0.closedReason = "default reason";

            crc1 = new Code();
            crc1.id = 1;
            crc1.closedReason = "first reason";

            crc2 = new Code();
            crc2.id = 2;
            crc2.closedReason = "second reason";

            crc3 = new Code();
            crc3.closedReason = "third reason";

            crc4 = new Code();
            crc4.id = 4;

            crc5 = new Code();

            crc6 = new Code();
            crc6.id = 2;
            crc6.closedReason = "second reason";


        }

        [TestMethod]
        public void PopulateClosedReasonsTest_0codes()
        {
            //Add codes
            //none

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();

            //Asserts
            Assert.AreEqual(cb.Items.Count, 0);
            Assert.AreEqual(cb.SelectedItem, null);
            Assert.AreEqual(cb.IsEnabled, false);

        }

        [TestMethod]
        public void PopulateClosedReasonsTest_2codes()
        {
            //Add codes
            closingCodes.codes.Add(crc1);
            closingCodes.codes.Add(crc2);

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();
            Code c0 = (Code)cb.Items.GetItemAt(0);
            Code c1 = (Code)cb.Items.GetItemAt(1);

            //Asserts
            Assert.AreEqual(cb.Items.Count, 2);
            Assert.AreEqual(cb.SelectedItem, null);

            Assert.AreEqual(c0.id, 1);
            Assert.AreEqual(c0.closedReason, "first reason");
            Assert.AreEqual(c1.id, 2);
            Assert.AreEqual(c1.closedReason, "second reason");
            Assert.AreEqual(cb.IsEnabled, true);
        }

        [Ignore] // Do we want to stop closed reason codes when they dont have an id?
        [TestMethod]
        public void PopulateClosedReasonsTest_missingID()
        {
            //Add codes
            closingCodes.codes.Add(crc3);

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();
            Code c0 = (Code)cb.Items.GetItemAt(0);

            //Asserts
            Assert.AreEqual(cb.Items.Count, 1);
            Assert.AreEqual(cb.SelectedItem, null);

            Assert.AreEqual(c0.id, 3);
            Assert.AreEqual(c0.closedReason, "third reason");
            Assert.AreEqual(cb.IsEnabled, true);

        }


        [TestMethod]
        public void PopulateClosedReasonsTest_missingReason()
        {
            //Add codes
            closingCodes.codes.Add(crc4);

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();

            //Asserts
            Assert.AreEqual(cb.Items.Count, 0);
            Assert.AreEqual(cb.SelectedItem, null);
            Assert.AreEqual(cb.IsEnabled, true);
        }

        [TestMethod]
        public void PopulateClosedReasonsTest_null()
        {
            //Add codes
            closingCodes = null;

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();

            //Asserts
            Assert.AreEqual(cb.Items.Count, 0);
            Assert.AreEqual(cb.SelectedItem, null);
            Assert.AreEqual(cb.IsEnabled, false);
        }



        [TestMethod]
        public void PopulateClosedReasonsWithDefaultTest_NoMatch()
        {
            //Add codes
            closingCodes.codes.Add(crc1);
            closingCodes.codes.Add(crc2);
            closingCodes.defaultReasonCode = 5;

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();

            //Asserts
            Assert.AreEqual(cb.Items.Count, 2);
            Assert.AreEqual(cb.SelectedItem, null);
            Assert.AreEqual(cb.IsEnabled, true);
        }

        [TestMethod]
        public void PopulateClosedReasonsWithDefaultTest_Match()
        {
            //Add codes
            closingCodes.codes.Add(crc1);
            closingCodes.codes.Add(crc2);
            closingCodes.defaultReasonCode = 2;

            //Do work
            chatWindow.PopulateClosedReasons(closingCodes);
            ComboBox cb = chatWindow.ComboClosedReasons();

            //Asserts
            Assert.AreEqual(cb.Items.Count, 2);
            Assert.AreEqual(cb.SelectedItem, crc2);
            Assert.AreEqual(cb.IsEnabled, true);
        }

    }
}
