﻿//////////////////////////////////////////////////////////////////////////////
// JDecoderTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////


using EncoderDecoder;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class JDecoderTest
    {
        [TestMethod]
        public void NoMethodInJSON()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""guid"" : 12345,
                                        ""agentId"" : 54321
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            Assert.IsNull(jdecode.Decode(jsonResponse));
        }

        [TestMethod]
        public void EmptyMethodInJSON()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : """",
                                        ""guid"" : 12345,
                                        ""agentId"" : 54321
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            Assert.IsNull(jdecode.Decode(jsonResponse));
        }

        [TestMethod]
        public void WrongTypeInJSON()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""qwerty"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentActive"",
                                        ""guid"" : 12345,
                                        ""agentId"" : 54321
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            Assert.IsNull(jdecode.Decode(jsonResponse));

        }

        [TestMethod]
        public void BadJSON()
        {
            String jsonResponse = "<hi>asd</ad>";

            JDecoder jdecode = new JDecoder();
            Assert.IsNull(jdecode.Decode(jsonResponse));
        }

    }
}



