﻿//////////////////////////////////////////////////////////////////////////////
// AgentDataNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;

namespace EncoderDecoderUnitTest.Tests.Notifications
{
    [TestClass]
    public class AgentDataNotificationTest
    {
        [TestMethod]
        public void AgentDataNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentData"",
                                        ""thresholds"" :
                                        {
                                            ""conversationLength_inSeconds"" : {
                                                ""threshold"": 25,
                                                ""priority"": 5
                                            },
                                            ""lastMessageOut_inSeconds"" : {
                                                ""threshold"": 20,
                                                ""priority"": 4
                                            },
                                            ""lastMessageIn_inSeconds"" : {
                                                ""threshold"": 15,
                                                ""priority"": 3
                                            },
                                            ""numberOfAgentMessages"" : {
                                                ""threshold"": 10,
                                                ""priority"": 2
                                            },
                                            ""numberOfUnansweredCustomerMessages"" : {
                                                ""threshold"": 5,
                                                ""priority"": 1
                                            }
                                        },
                                        ""agents"" : [
                                            {
                                                ""agentId"" : ""112233"",
                                                ""agentName"" : ""John Smith"",
                                                ""conversations"" : [
                                                    {
                                                        ""guid"" : 111222,
                                                        ""chatType"" : ""conference"",
                                                        ""conversationLength_inSeconds"" : 33,
                                                        ""lastMessageOut_inSeconds"" : 32,
                                                        ""lastMessageIn_inSeconds"" : 31,
                                                        ""numberOfAgentMessages"" : 10,
                                                        ""numberOfUnansweredCustomerMessages"" : 3
                                                    },
                                                    {
                                                        ""guid"" : 555666,
                                                        ""chatType"" : ""conference"",
                                                        ""conversationLength_inSeconds"" : 23,
                                                        ""lastMessageOut_inSeconds"" : 22,
                                                        ""lastMessageIn_inSeconds"" : 21,
                                                        ""numberOfAgentMessages"" : 5,
                                                        ""numberOfUnansweredCustomerMessages"" : 1
                                                    }
                                                ]
                                            },
                                            {
                                                ""agentId"" : ""553311"",
                                                ""agentName"" : ""David Jones"",
                                                ""conversations"" : [
                                                    {
                                                        ""guid"" : 9990,
                                                        ""chatType"" : ""consult"",
                                                        ""conversationLength_inSeconds"" : 33,
                                                        ""lastMessageOut_inSeconds"" : 32,
                                                        ""lastMessageIn_inSeconds"" : 31,
                                                        ""numberOfAgentMessages"" : 10,
                                                        ""numberOfUnansweredCustomerMessages"" : 3
                                                    },
                                                    {
                                                        ""guid"" : 8880,
                                                        ""chatType"" : ""1-1"",
                                                        ""conversationLength_inSeconds"" : 23,
                                                        ""lastMessageOut_inSeconds"" : 22,
                                                        ""lastMessageIn_inSeconds"" : 21,
                                                        ""numberOfAgentMessages"" : 5,
                                                        ""numberOfUnansweredCustomerMessages"" : 1
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentDataNotification note = (AgentDataNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentData");

            AgentDataNotification.Thresholds threshold = note.body.thresholds;

            Assert.AreEqual(threshold.conversationLength_inSeconds.threshold, 25);
            Assert.AreEqual(threshold.conversationLength_inSeconds.priority, 5);
            Assert.AreEqual(threshold.lastMessageOut_inSeconds.threshold, 20);
            Assert.AreEqual(threshold.lastMessageOut_inSeconds.priority, 4);
            Assert.AreEqual(threshold.lastMessageIn_inSeconds.threshold, 15);
            Assert.AreEqual(threshold.lastMessageIn_inSeconds.priority, 3);
            Assert.AreEqual(threshold.numberOfAgentMessages.threshold, 10);
            Assert.AreEqual(threshold.numberOfAgentMessages.priority, 2);
            Assert.AreEqual(threshold.numberOfUnansweredCustomerMessages.threshold, 5);
            Assert.AreEqual(threshold.numberOfUnansweredCustomerMessages.priority, 1);

            List<AgentDataNotification.Agent> agents = note.body.agents;
            Assert.AreEqual(agents.Count, 2);

            Assert.AreEqual(agents[0].agentId, "112233");
            Assert.AreEqual(agents[0].agentName, "John Smith");
            List<AgentDataNotification.Conversation> convoAgent1 = agents[0].conversations;
            Assert.AreEqual(convoAgent1.Count, 2);

            Assert.AreEqual(convoAgent1[0].guid, 111222);
            Assert.AreEqual(convoAgent1[0].conversationLength_inSeconds, 33);
            Assert.AreEqual(convoAgent1[0].lastMessageOut_inSeconds, 32);
            Assert.AreEqual(convoAgent1[0].lastMessageIn_inSeconds, 31);
            Assert.AreEqual(convoAgent1[0].numberOfAgentMessages, 10);
            Assert.AreEqual(convoAgent1[0].numberOfUnansweredCustomerMessages, 3);

            Assert.AreEqual(convoAgent1[1].guid, 555666);
            Assert.AreEqual(convoAgent1[1].conversationLength_inSeconds, 23);
            Assert.AreEqual(convoAgent1[1].lastMessageOut_inSeconds, 22);
            Assert.AreEqual(convoAgent1[1].lastMessageIn_inSeconds, 21);
            Assert.AreEqual(convoAgent1[1].numberOfAgentMessages, 5);
            Assert.AreEqual(convoAgent1[1].numberOfUnansweredCustomerMessages, 1);

            Assert.AreEqual(agents[1].agentId, "553311");
            Assert.AreEqual(agents[1].agentName, "David Jones");
            List<AgentDataNotification.Conversation> convoAgent2 = agents[1].conversations;
            Assert.AreEqual(convoAgent2.Count, 2);

            Assert.AreEqual(convoAgent2[0].guid, 9990);
            Assert.AreEqual(convoAgent2[0].conversationLength_inSeconds, 33);
            Assert.AreEqual(convoAgent2[0].lastMessageOut_inSeconds, 32);
            Assert.AreEqual(convoAgent2[0].lastMessageIn_inSeconds, 31);
            Assert.AreEqual(convoAgent2[0].numberOfAgentMessages, 10);
            Assert.AreEqual(convoAgent2[0].numberOfUnansweredCustomerMessages, 3);

            Assert.AreEqual(convoAgent2[1].guid, 8880);
            Assert.AreEqual(convoAgent2[1].conversationLength_inSeconds, 23);
            Assert.AreEqual(convoAgent2[1].lastMessageOut_inSeconds, 22);
            Assert.AreEqual(convoAgent2[1].lastMessageIn_inSeconds, 21);
            Assert.AreEqual(convoAgent2[1].numberOfAgentMessages, 5);
            Assert.AreEqual(convoAgent2[1].numberOfUnansweredCustomerMessages, 1);
        }
    }
}
