﻿//////////////////////////////////////////////////////////////////////////////
// AgentJoinRoomNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////
using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentJoinRoomNotificationTest
    {
        [TestMethod]
        public void AgentJoinRoomNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentJoinRoom"",
                                        ""guid"" : 123456,
                                        ""deviceType"" : ""User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:12.0) Gecko/20100101 Firefox/21.0"",
                                        ""previousTranscripts"" : 12,
                                        ""conversationTranscript"" :
                                        {
                                            ""messages"" : [
                                                {
                                                    ""type"": ""message"",
                                                    ""sender"" : {
                                                        ""type"": ""customer""
                                                    },
                                                    ""displayName"" : ""frank"",
                                                    ""timestamp"" : 1427294421,
                                                    ""message"" : ""first message"",
                                                    ""messageType"" : ""normal""
                                                },
                                                {
                                                    ""type"": ""message"",
                                                    ""sender"" : {
                                                        ""type"": ""agent"",
                                                        ""agentId"": ""88844"",
                                                    },
                                                    ""displayName"" : ""frank"",
                                                    ""timestamp"" : 1427294422,
                                                    ""message"" : ""second message"",
                                                    ""messageType"" : ""whisper""
                                                },
                                                {
                                                    ""type"": ""pagePush"",
                                                    ""sender"": {
                                                        ""type"": ""agent"",
                                                        ""agentId"": ""12345""
                                                    },
                                                    ""url"": ""http://example.com"",
                                                    ""displayName"": ""Jimmy"",
                                                    ""timestamp"": 1427294422,
                                                    ""destination"": ""newTab""
                                                },
{
                                                    ""type"": ""invalidType"",
                                                    ""message"": ""Should be ignored for future compatibility"",
                                                }
                                            ]
                                        },
                                        ""currentParticipantList"" :
                                        {
                                            ""participants"" : [
                                                {
                                                    ""agentId"" : ""1111"",
                                                    ""userType"" : ""agent""
                                                },
                                                {
                                                    ""agentId"" : ""2222"",
                                                    ""userType"" : ""supervisor""
                                                },
                                                {
                                                    ""agentId"" : ""3333"",
                                                    ""userType"" : ""customer""
                                                }
                                            ]
                                        },
                                        ""timerList"" :
                                        {
                                            ""keepAliveTime_inSeconds"" : 30,
                                            ""desirableResponseToCust_inSeconds"" : 30,
                                            ""desirableResponseToAgent_inSeconds"" : 60,
                                            ""consultRequestTimeout_inSeconds"" : 30,
                                            ""forceIdleCustomerCheck"" : false,
                                            ""forceIdleCustomerCheckTimeout_inSeconds"" : 180,
                                            ""saveTimestampOnMessages"" : true,
                                            ""saveChatHistory"" : true,
                                            ""concurrentChatsLimitPerCustomer"" : 3,
                                            ""requestedCallBacksLimitPerCustomer"" : 3,
                                            ""emailChatLogToCustomer"" : true
                                        },
                                        ""customFields"" :
                                                [
                                                  {""title"": ""accountNo"", ""value"" : ""12345""},
                                                  {""title"": ""locale"", ""value"" : ""en-GB""}
                                                ],
                                        ""resources"" :
                                        {
                                            ""agentLabel"" : ""first name last name"",
                                            ""customerLabel"" : ""customer""
                                        },
                                        ""frequentlyUsedPhraseList"" : [
                                            {
                                                ""skillset"" : ""all"",
                                                ""phrases"" : [
                                                    {
                                                        ""name"" : ""phrase1"",
                                                        ""phraseText"" : ""Can I help you with anything else""
                                                    },
                                                    {
                                                        ""name"" : ""phrase2"",
                                                        ""phraseText"" : ""how can I help""
                                                    },
                                                    {
                                                        ""name"" : ""phrase3"",
                                                        ""phraseText"" : ""some phrase""
                                                    },
                                                    {
                                                        ""name"" : ""phrase4"",
                                                        ""phraseText"" : ""welcome to chat""
                                                    }
                                                ]
                                            },
                                            {
                                                ""skillset"" : ""wc_sales"",
                                                ""phrases"" : [
                                                    {
                                                        ""name"" : ""phrase1"",
                                                        ""phraseText"" : ""Can I help you with anything else""
                                                    },
                                                    {
                                                        ""name"" : ""phrase2"",
                                                        ""phraseText"" : ""how can I help""
                                                    }
                                                ]
                                            },
                                            {
                                                ""skillset"" : ""wc_support"",
                                                ""phrases"" : [
                                                    {
                                                        ""name"" : ""phrase3"",
                                                        ""phraseText"" : ""some phrase""
                                                    },
                                                    {
                                                        ""name"" : ""phrase4"",
                                                        ""phraseText"" : ""welcome to chat""
                                                    }
                                                ]
                                            }
                                        ],
                                        ""pagePushURLList"" : [
                                            {
                                                ""skillset"" : ""all"",
                                                ""urls"" : [
                                                    {
                                                        ""url"" : ""www.google.com"",
                                                        ""description"" : ""Google search""
                                                    },
                                                    {
                                                        ""url"" : ""www.avaya.com"",
                                                        ""description"" : ""Avaya Homepage""
                                                    },
                                                    {
                                                        ""url"" : ""www.test.com"",
                                                        ""description"" : ""test page""
                                                    },
                                                    {
                                                        ""url"" : ""www.avaya.ie"",
                                                        ""description"" : ""Avaya IE Homepage""
                                                    }
                                                ]
                                            },
                                            {
                                                ""skillset"" : ""wc_sales"",
                                                ""urls"" : [
                                                    {
                                                        ""url"" : ""www.google.com"",
                                                        ""description"" : ""Google search""
                                                    },
                                                    {
                                                        ""url"" : ""www.avaya.com"",
                                                        ""description"" : ""Avaya Homepage""
                                                    }
                                                ]
                                            },
                                            {
                                                ""skillset"" : ""wc_support"",
                                                ""urls"" : [
                                                    {
                                                        ""url"" : ""www.test.com"",
                                                        ""description"" : ""test page""
                                                    },
                                                    {
                                                        ""url"" : ""www.avaya.ie"",
                                                        ""description"" : ""Avaya IE Homepage""
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentJoinRoomNotification note = (AgentJoinRoomNotification)jdecode.Decode(jsonResponse);

            //Top Level Details
            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentJoinRoom");
            Assert.AreEqual(note.body.guid, 123456);
            Assert.AreEqual(note.body.deviceType, "User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:12.0) Gecko/20100101 Firefox/21.0");
            Assert.AreEqual(note.body.previousTranscripts, 12);

            
            //Conversation History
            List<AgentJoinRoomNotification.TranscriptEvent> convoTranscript = note.body.conversationTranscript.messages;

            AgentJoinRoomNotification.TranscriptMessage m1 = (AgentJoinRoomNotification.TranscriptMessage)convoTranscript[0];
            Assert.AreEqual(m1.message, "first message");
            Assert.AreEqual(m1.messageType, "normal");
            Assert.AreEqual(m1.sender.type, "customer");
            Assert.AreEqual(m1.sender.agentId, null);
            Assert.AreEqual(m1.displayName, "frank");
            Assert.AreEqual(m1.timestamp, 1427294421);

            AgentJoinRoomNotification.TranscriptMessage m2 = (AgentJoinRoomNotification.TranscriptMessage)convoTranscript[1];
            Assert.AreEqual(m2.message, "second message");
            Assert.AreEqual(m2.messageType, "whisper");
            Assert.AreEqual(m2.sender.type, "agent");
            Assert.AreEqual(m2.sender.agentId, "88844");
            Assert.AreEqual(m2.displayName, "frank");
            Assert.AreEqual(m2.timestamp, 1427294422);


            AgentJoinRoomNotification.TranscriptPagePush m3 = (AgentJoinRoomNotification.TranscriptPagePush)convoTranscript[2];
            Assert.AreEqual(m3.url, "http://example.com");
            Assert.AreEqual(m3.destination, "newTab");
            Assert.AreEqual(m3.sender.type, "agent");
            Assert.AreEqual(m3.sender.agentId, "12345");
            Assert.AreEqual(m3.displayName, "Jimmy");
            Assert.AreEqual(m3.timestamp, 1427294422);

            //Participants
            List<AgentJoinRoomNotification.Participant> participants = note.body.currentParticipantList.participants;
            Assert.AreEqual(participants.Count, 3);

            Assert.AreEqual(participants[0].agentId, "1111");
            Assert.AreEqual(participants[0].userType, "agent");

            Assert.AreEqual(participants[1].agentId, "2222");
            Assert.AreEqual(participants[1].userType, "supervisor");

            Assert.AreEqual(participants[2].agentId, "3333");
            Assert.AreEqual(participants[2].userType, "customer");

            //Timers
            AgentJoinRoomNotification.TimerList timers = note.body.timerList;
            Assert.AreEqual(timers.keepAliveTime_inSeconds, 30);
            Assert.AreEqual(timers.desirableResponseToCust_inSeconds, 30);
            Assert.AreEqual(timers.desirableResponseToAgent_inSeconds, 60);
            Assert.AreEqual(timers.consultRequestTimeout_inSeconds, 30);
            Assert.AreEqual(timers.forceIdleCustomerCheck, false);
            Assert.AreEqual(timers.forceIdleCustomerCheckTimeout_inSeconds, 180);
            Assert.AreEqual(timers.saveTimeStampOnMessages, true);
            Assert.AreEqual(timers.saveChatHistory, true);
            Assert.AreEqual(timers.concurrentChatsLimitPerCustomer, 3);
            Assert.AreEqual(timers.requestedCallBacksLimitPerCustomer, 3);
            Assert.AreEqual(timers.emailChatLogToCustomer, true, "email log");

            //Custom Intrinsics
            List<AgentJoinRoomNotification.CustomField> cIntrinsics = note.body.customFields;
            Assert.AreEqual(cIntrinsics.Count, 2);

            Assert.AreEqual(cIntrinsics[0].title, "accountNo");
            Assert.AreEqual(cIntrinsics[0].value, "12345");
            Assert.AreEqual(cIntrinsics[1].title, "locale");
            Assert.AreEqual(cIntrinsics[1].value, "en-GB");

            //Resources
            AgentJoinRoomNotification.Resources resources = note.body.resources;

            Assert.AreEqual(resources.agentLabel, "first name last name");
            Assert.AreEqual(resources.customerLabel, "customer");

            //Freq Used Phrases
            List<AgentJoinRoomNotification.FrequentlyUsedPhraseList> freqUsedPhrases = note.body.frequentlyUsedPhraseList;
            Assert.AreEqual(freqUsedPhrases.Count, 3);

            List<AgentJoinRoomNotification.Phrases> phrase1 = freqUsedPhrases[0].phrases;
            Assert.AreEqual(freqUsedPhrases[0].skillset, "all");
            Assert.AreEqual(phrase1[0].name, "phrase1");
            Assert.AreEqual(phrase1[0].phraseText, "Can I help you with anything else");
            Assert.AreEqual(phrase1[1].name, "phrase2");
            Assert.AreEqual(phrase1[1].phraseText, "how can I help");
            Assert.AreEqual(phrase1[2].name, "phrase3");
            Assert.AreEqual(phrase1[2].phraseText, "some phrase");
            Assert.AreEqual(phrase1[3].name, "phrase4");
            Assert.AreEqual(phrase1[3].phraseText, "welcome to chat");

            List<AgentJoinRoomNotification.Phrases> phrase2 = freqUsedPhrases[1].phrases;
            Assert.AreEqual(freqUsedPhrases[1].skillset, "wc_sales");
            Assert.AreEqual(phrase2[0].name, "phrase1");
            Assert.AreEqual(phrase2[0].phraseText, "Can I help you with anything else");
            Assert.AreEqual(phrase2[1].name, "phrase2");
            Assert.AreEqual(phrase2[1].phraseText, "how can I help");

            List<AgentJoinRoomNotification.Phrases> phrase3 = freqUsedPhrases[2].phrases;
            Assert.AreEqual(freqUsedPhrases[2].skillset, "wc_support");
            Assert.AreEqual(phrase3[0].name, "phrase3");
            Assert.AreEqual(phrase3[0].phraseText, "some phrase");
            Assert.AreEqual(phrase3[1].name, "phrase4");
            Assert.AreEqual(phrase3[1].phraseText, "welcome to chat");

            //Page Push URLs 
            List<AgentJoinRoomNotification.PagePushURLList> pagepush = note.body.pagePushURLList;
            Assert.AreEqual(pagepush.Count, 3);

            List<AgentJoinRoomNotification.Url> url1 = pagepush[0].urls;
            Assert.AreEqual(pagepush[0].skillset, "all");
            Assert.AreEqual(url1[0].url, "www.google.com");
            Assert.AreEqual(url1[0].description, "Google search");
            Assert.AreEqual(url1[1].url, "www.avaya.com");
            Assert.AreEqual(url1[1].description, "Avaya Homepage");
            Assert.AreEqual(url1[2].url, "www.test.com");
            Assert.AreEqual(url1[2].description, "test page");
            Assert.AreEqual(url1[3].url, "www.avaya.ie");
            Assert.AreEqual(url1[3].description, "Avaya IE Homepage");

            List<AgentJoinRoomNotification.Url> url2 = pagepush[1].urls;
            Assert.AreEqual(pagepush[1].skillset, "wc_sales");
            Assert.AreEqual(url2[0].url, "www.google.com");
            Assert.AreEqual(url2[0].description, "Google search");
            Assert.AreEqual(url2[1].url, "www.avaya.com");
            Assert.AreEqual(url2[1].description, "Avaya Homepage");

            List<AgentJoinRoomNotification.Url> url3 = pagepush[2].urls;
            Assert.AreEqual(pagepush[2].skillset, "wc_support");
            Assert.AreEqual(url3[0].url, "www.test.com");
            Assert.AreEqual(url3[0].description, "test page");
            Assert.AreEqual(url3[1].url, "www.avaya.ie");
            Assert.AreEqual(url3[1].description, "Avaya IE Homepage");
        }

    }


}

