﻿//////////////////////////////////////////////////////////////////////////////
// AgentSetClosedReasonRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentSetClosedReasonRequestTest
    {
        [TestMethod]
        public void AgentSetClosedReasonRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""agentSetClosedReason"",""guid"":12345,""closedReasonCode"":44,""agentNote"":""Customer wasn't happy"",""sendTranscript"":true}}";

            AgentSetClosedReasonRequest temp = new AgentSetClosedReasonRequest();
            temp.apiVersion = AgentSetClosedReasonRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 12345;
            temp.body.closedReasonCode = 44;
            temp.body.agentNote = "Customer wasn't happy";
            temp.body.sendTranscript = true;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);

        }
    }
}
