﻿//////////////////////////////////////////////////////////////////////////////
// AgentGetObservedIntrinsicsNotification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Newtonsoft.Json;
using System.Collections.Generic;

namespace EncoderDecoder.Notifications
{
    public class AgentGetObservedIntrinsicsNotification : IBaseNotification
    {
        public AgentGetObservedIntrinsicsNotification()
        {
            this.body = new Body();
        }

        public string apiVersion { get; set; }
        public string type { get; set; }
        public Body body { get; set; }

        public class Body
        {
            public Body()
            {
                agents = new List<Agent>();
            }
            public string method { get; set; }
            public List<Agent> agents { get; set; }
        }

        public class Agent
        {
            public Agent()
            {
                conversations = new List<Conversation>();
            }
            public string agentId { get; set; }
            public string agentName { get; set; }
            public List<Conversation> conversations { get; set; }
        }

        public class Conversation
        {
            public long guid { get; set; }
            public int conversationLength_inSeconds { get; set; }
            public int lastMessageOut_inSeconds { get; set; }
            public int lastMessageIn_inSeconds { get; set; }
            public int numberOfAgentMessages { get; set; }
            public int numberOfUnansweredCustomerMessages { get; set; }
        }

        /// <summary>
        /// Decodes this notifications and returns object representation.
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public IBaseNotification Decode(string json)
        {
            return JsonConvert.DeserializeObject<AgentGetObservedIntrinsicsNotification>(json);
        }
        
    }
}
