﻿//////////////////////////////////////////////////////////////////////////////
// ReadCustomerHistoryNotification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Newtonsoft.Json;
using System;
using System.Collections.Generic;

namespace EncoderDecoder.Notifications
{
    public class ReadCustomerHistoryNotification : IBaseNotification
    {
        public ReadCustomerHistoryNotification()
        {
            this.body = new Body();
        }

        public string apiVersion { get; set; }
        public string type { get; set; }
        public Body body { get; set; }

        public class Body
        {
            public Body()
            {
                this.history = new List<History>();
            }
            public string method { get; set; }
            public long guid { get; set; }
            public List<History> history { get; set; }
        }

        public class History
        {
            public long startTime { get; set; }
            public string transcript { get; set; }
            public string source { get; set; }
            public string contactType { get; set; }
        }

        /// <summary>
        /// Decodes this notifications and returns object representation.
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public IBaseNotification Decode(string json)
        {
            return JsonConvert.DeserializeObject<ReadCustomerHistoryNotification>(json);
        }
        
    }
}
