﻿//////////////////////////////////////////////////////////////////////////////
// LabelFormatTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using CustomDesktop;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace EncoderDecoderUnitTest.Tests.GUI
{
    [TestClass]
    public class LabelFormatTest
    {

        [TestMethod]
        public void LabelFormattingTest()
        {
            string one = "[Test]";
            string two = "Test";
            string three = "[Test";
            string four = "Test]";
            string five = "[[Test]]";

            UcChatWindow uccw = new UcChatWindow(1, null);

            Assert.AreEqual(uccw.FormatLabel(one),      "[Test]");
            Assert.AreEqual(uccw.FormatLabel(two),      "[Test]");
            Assert.AreEqual(uccw.FormatLabel(three),    "[Test]");
            Assert.AreEqual(uccw.FormatLabel(four),     "[Test]");
            Assert.AreEqual(uccw.FormatLabel(five),     "[Test]");

        }
    }
}