﻿//////////////////////////////////////////////////////////////////////////////
// AgentQuitChatNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentQuitChatNotificationTest
    {
        [TestMethod]
        public void AgentQuitChatNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentQuitChat"",
                                        ""guid"" : 12345,
                                        ""closedReasonCodes"" : {
                                            ""defaultReasonCode"": 2,
                                                ""codes"": [
                                                    {
                                                        ""id"" : 1,
                                                        ""closedReason"" : ""problem solved""
                                                    },
                                                    {
                                                        ""id"" : 2,
                                                        ""closedReason"" : ""could not fix""
                                                    }
                                            ]
                                        }
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentQuitChatNotification note = (AgentQuitChatNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentQuitChat");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.closedReasonCodes.defaultReasonCode,2);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem solved");
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 1);
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].closedReason, "could not fix");
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].id, 2);
        }

        [TestMethod]
        public void AgentQuitChatNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.2"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentQuitChat"",
                                        ""guid"" : 12345,
                                        ""closedReasonCodes"" : {
                                            ""defaultReasonCode"": 1,
                                                ""codes"": [
                                                    {
                                                        ""id"" : 1,
                                                        ""closedReason"" : ""problem2solved""
                                                    },
                                                    {
                                                        ""id"" : 2,
                                                        ""closedReason"" : ""could2not2fix""
                                                    }
                                            ]
                                        }
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentQuitChatNotification note = (AgentQuitChatNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.2");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentQuitChat");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.closedReasonCodes.defaultReasonCode, 1);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem2solved");
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 1);
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].closedReason, "could2not2fix");
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].id, 2);
        }

        [TestMethod]
        public void AgentQuitChatNotificationTest_SimpleDecode3()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentQuitChat"",
                                        ""guid"" : 12345,
                                        ""closedReasonCodes"" : {
                                                ""codes"": [
                                                    {
                                                        ""id"" : 1,
                                                        ""closedReason"" : ""problem solved""
                                                    }
                                            ]
                                        }
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentQuitChatNotification note = (AgentQuitChatNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentQuitChat");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem solved");
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 1);
        }
    }
}
