﻿//////////////////////////////////////////////////////////////////////////////
// ErrorNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class ErrorNotificationTest
    {
        [TestMethod]
        public void ErrorNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""error"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""code"" : 123,
                                        ""errorMessage"" : ""Some error""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            ErrorNotification note = (ErrorNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "error");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.code, 123);
            Assert.AreEqual(note.body.errorMessage, "Some error");

        }

    }


}

