﻿//////////////////////////////////////////////////////////////////////////////
// AgentGetObservedIntrinsiceRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentGetObservedIntrinsicsRequestTest
    {
        [TestMethod]
        public void AgentGetObservedIntrinsicsRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""observedIntrinsicsRequest"",""agents"":[{""agentId"":""444333""},{""agentId"":""999333""}]}}";

            AgentGetObservedIntrinsicsRequest temp = new AgentGetObservedIntrinsicsRequest();
            temp.apiVersion = AgentGetObservedIntrinsicsRequest.JSapiVersion.one_point_zero;

            temp.body.agents.Add(new AgentGetObservedIntrinsicsRequest.Agent(){
                agentId = "999333"
            });
            temp.body.agents.Add(new AgentGetObservedIntrinsicsRequest.Agent() {
                agentId = "444333"
            });

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);
            
            Assert.AreEqual(response, jsonExpected);
            
        }
    }
}
