﻿//////////////////////////////////////////////////////////////////////////////
// AgentWhisperMessageRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentWhisperMessageRequestTest
    {
        [TestMethod]
        public void AgentWhisperMessageRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""newWhisperMessage"",""guid"":432123,""destinationAgentId"":""654321"",""message"":""whisper message""}}";

            AgentWhisperMessageRequest temp = new AgentWhisperMessageRequest();
            temp.apiVersion = AgentWhisperMessageRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 432123;
            temp.body.destinationAgentId = "654321";
            temp.body.message = "whisper message";

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);

        }
    }
}
