﻿//////////////////////////////////////////////////////////////////////////////
// NewMessageRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class NewMessageRequestTest
    {
        [TestMethod]
        public void NewMessageRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""newMessage"",""guid"":123456,""message"":""Test message from customer"",""messageType"":""whisper""}}";

            NewMessageRequest temp = new NewMessageRequest();
            temp.apiVersion = NewMessageRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 123456;
            temp.body.message = "Test message from customer";
            temp.body.messageType = BaseRequest.JSmessageType.whisper;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);

        }
    }
}
