﻿//////////////////////////////////////////////////////////////////////////////
// AgentExitRoomNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentExitRoomNotificationTest
    {
        [TestMethod]
        public void AgentExitRoomNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""exitRoom"",
                                        ""guid"" : 432333,
                                        ""agentId"" : ""12345"",
                                        ""scenario"" : ""dropped by conference owner""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentExitRoomNotification note = (AgentExitRoomNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "exitRoom");
            Assert.AreEqual(note.body.guid, 432333);
            Assert.AreEqual(note.body.agentId, "12345");
            Assert.AreEqual(note.body.scenario, "dropped by conference owner");

        }

    }


}

