﻿//////////////////////////////////////////////////////////////////////////////
// CustomerConnectionStatusNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class CustomerConnectionStatusNotificationTest
    {
        [TestMethod]
        public void CustomerConnectionStatusNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                ""apiVersion"" : ""1.0"",
                                ""type"" : ""notification"",
                                ""body"" :
                                {
                                    ""method"" : ""customerConnectionStatus"",
                                    ""guid"" : 332233,
                                    ""isConnected"" : true,
                                    ""timestamp"" : 1427294421123
                                }
                            }";


            JDecoder jdecode = new JDecoder();
            CustomerConnectionStatusNotification note = (CustomerConnectionStatusNotification)jdecode.Decode(jsonResponse);
            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "customerConnectionStatus");
            Assert.AreEqual(note.body.guid, 332233);
            Assert.AreEqual(note.body.isConnected, true);

        }

    }
}
