﻿//////////////////////////////////////////////////////////////////////////////
// AgentLoginRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentLoginRequestTest
    {
        [TestMethod]
        public void AgentLoginRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""agentLogin"",""agentId"":""12345"",""password"":""12345"",""reconnect"":false,""clientType"":""custom""}}";

            AgentLoginRequest temp = new AgentLoginRequest();
            temp.apiVersion = AgentLoginRequest.JSapiVersion.one_point_zero;

            temp.body.agentId = "12345";
            temp.body.password = "12345";
            temp.body.reconnect = false;
            temp.body.clientType = AgentLoginRequest.JSclientType.custom;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);


            Assert.AreEqual(response, jsonExpected);

        }
    }
}
