﻿//////////////////////////////////////////////////////////////////////////////
// AgentOperationRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentOperationRequestTest
    {
        [TestMethod]
        public void AgentOperationRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""operationRequest"",""guid"":12345,""destinationType"":""agent"",""destinationId"":""654321""}}";

            AgentOperationRequest temp = new AgentOperationRequest();
            temp.apiVersion = AgentOperationRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 12345;
            temp.body.destinationType = AgentOperationRequest.JSdestinationType.agent;
            temp.body.destinationId = "654321";

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);
        }
    }
}