/**
 * @license global.js
 *
 * Copyright 2015 Avaya Inc. All Rights Reserved.
 *
 * Usage of this source is bound to the terms described in
 * licences/License.txt
 *
 * Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
 * Avaya Policy
 */
function logToConsole(a){"use strict";void 0!==console}function getEl(a){"use strict";return document.getElementById(a)}function detectBrowserSupport(){"use strict";WebSocket&&XMLHttpRequest&&JSON||window.alert(browserWarning)}function setSessionStorage(a,b){"use strict";sessionStorage.setItem(a,b)}function getSessionStorage(a){"use strict";return sessionStorage.getItem(a)}function gatherElements(){"use strict";sendButton=getEl("sendbutton-chat"),callbackRequestButton=getEl("callbackPanel"),closeButton=getEl("closebutton-chat"),messages=getEl("messages"),outMessage=getEl("outmessage"),participants=getEl("participants"),pagePushDiv=getEl("pagePushDiv")}function clearSessionStorage(){"use strict";setSessionStorage("user",""),setSessionStorage("phone",""),setSessionStorage("email",""),setSessionStorage("account",""),setSessionStorage("skillset",""),setSessionStorage("subject","")}function disableControls(a){"use strict";sendButton.disabled=a,outMessage.disabled=a,a===!1?(pagePushDiv.style.display="block",outMessage.addEventListener("keydown",onType)):(pagePushDiv.style.display="none",outMessage.removeEventListener("keydown",onType))}function onType(a){"use strict";13===a.keyCode?sendChatMessage():startTypingTimer()}function writeResponse(a,b){"use strict";var c=document.createElement("p");c.className=b,c.textContent=a,messages.appendChild(c),messages.scrollTop=messages.scrollHeight}function updateUsers(a){"use strict";users={};for(var b=0;b<participants.children.length;b++){var c=participants.children[b],d=c.getElementsByTagName("img")[0];c.className="hidden",d.className="hidden",d.src="",d.nextSibling.textContent=""}if(void 0!==a)for(var e=0;e<a.length;e++){var f=a[e],g=participants.children[e];g.className="user";var h=g.getElementsByTagName("img")[0];h.src="supervisor"===f.type?supervisorImage:agentImage,h.className="",h.nextSibling.textContent=f.name,users[f.id]={name:f.name,isTyping:!1,agentType:f.type,image:h}}}function addTimerToArray(a){"use strict";if(void 0!==a)for(var b=0;b<a.length;b++){var c=a[b];c.lastCalled=(new Date).valueOf(),c.currentSequence=0}}function playOnHoldMessages(a){"use strict";for(var b=new Date,c=b.valueOf(),d=0;d<a.length;d++){var e=a[d],f=(c-e.lastCalled)/1e3;if(f>=e.delay||f>=e.holdTime){var g;void 0!==e.urls?(g=e.urls[e.currentSequence],writeResponse("Please visit this link: ",writeResponseClassResponse),appendLink(g.url,"_blank",!1)):(g=e.messages[e.currentSequence],writeResponse(g.message,writeResponseClassResponse)),e.lastCalled=c,e.currentSequence++,(void 0!==e.numberOfMessages&&e.currentSequence>=e.numberOfMessages||void 0!==e.urls&&e.currentSequence>=e.urls.length)&&(e.currentSequence=0)}}}function appendLink(a,b,c){"use strict";var d=document.createElement("p"),e=document.createElement("a");e.href=a,e.text=a,e.target="_"+b,d.appendChild(e),messages.appendChild(e),messages.scrollTop=messages.scrollHeight,c&&window.open(e)}function chatLogin(a,b,c,d,e){"use strict";var f=getEl("transcript-chat").checked,g=getEl("address-chat");isStringEmpty(b)&&(f=!1);var h={apiVersion:"1.0",type:"request",body:{method:"requestChat",guid:guid,authenticationKey:ak,deviceType:navigator.userAgent,requestTranscript:f,intrinsics:{email:b,name:a,country:e.country,area:e.area,phoneNumber:e.phone,skillset:g_skillset,customFields:[{title:"address",value:g.value}]}}};writeResponse("Sending Login Details",writeResponseClassSent),sendMessage(h)}function sendChatMessage(){"use strict";var a=outMessage.value;if(""!==a){writeResponse(g_user+": "+a,writeResponseClassSent);var b={apiVersion:"1.0",type:"request",body:{method:"newMessage",message:a}};sendMessage(b),outMessage.value="",isTyping=!1}}function quitChat(){"use strict";if(null!==webSocket&&webSocket.readyState===webSocket.OPEN){var a={apiVersion:"1.0",type:"request",body:{method:"closeConversation"}};writeResponse("Close request sent",writeResponseClassSent),sendMessage(a)}}function sendIsTyping(a){"use strict";var b={apiVersion:"1.0",type:"request",body:{method:"isTyping",isTyping:a}};sendMessage(b)}function sendPagePushRequest(){"use strict";var a=getEl("urlInput").value.trim();if(""===a)return void writeResponse("Please enter a link to send it",writeResponseClassResponse);var b={apiVersion:"1.0",type:"request",body:{method:"newPushPageMessage",pagePushURL:a,pagePushDestination:"newTab"}};writeResponse("Your link has been sent",writeResponseClassSent),getEl("urlInput").value="",sendMessage(b)}function sendQueueStatusRequest(){"use strict";var a={apiVersion:1,type:"request",body:{method:"queueStatus"}};sendMessage(a)}function notifyRequestChat(a){"use strict";guid=a.guid,g_user=a.intrinsics.name,ak=a.authenticationKey,writeResponse("Login request received and approved",writeResponseClassResponse),totalNumberOfRetrys>0&&resetConnectionAttempts(),previouslyConnected||(previouslyConnected=!0,webOnHoldComfortGroups=a.webOnHoldComfortGroups,webOnHoldURLs=a.webOnHoldURLs,addTimerToArray(webOnHoldComfortGroups),addTimerToArray(webOnHoldURLs),startOnHoldMessages(),queueStatusDelay=setTimeout(sendQueueStatusRequest,queueStatusDelayTimeout))}function notifyNewParticipant(a){"use strict";writeResponse("An agent has joined the chat",writeResponseClassResponse);var b=a.participants;updateUsers(b),clearInterval(webOnHoldInterval),clearTimeout(queueStatusDelay),disableControls(!1)}function notifyIsTyping(a){"use strict";var b=a.isTyping;if(b===!0){var c=users[a.agentId];c.isTyping=b,updateTypingCell(c,!0);var d;d="active_participant"===c.type?activeAgentTypeOut:"passive_participant"===c.type?passiveAgentTypeOut:supervisorTypeOut,void 0!==d&&clearTypingTimer(d),d=setTimeout(function(){void 0!==users&&(c.isTyping=!1,updateTypingCell(c,!1))},agentTypingTimeout),timeouts.push(d)}}function updateTypingCell(a,b){"use strict";var c=a.image;"active_participant"===a.agentType||"passive_participant"===a.agentType?c.src=b===!0?agentTypingImage:agentImage:c.src=b===!0?supervisorTypingImage:supervisorImage,c.nextSibling.textContent=b===!0?a.name.concat(" is typing"):a.name}function notifyNewMessage(a){"use strict";var b=new Date(a.timestamp);writeResponse(a.displayName+": "+a.message+" - Sent at "+b.toLocaleTimeString(),writeResponseClassResponse)}function notifyCloseConversation(a){"use strict";dontRetryConnection=a.result,a.result===!0&&(webSocket.close(1e3,"Closing gracefully"),clearSessionStorage())}function notifyParticipantLeave(a){"use strict";writeResponse("Agent has left the chat",writeResponseClassResponse),a.endChatFlag===!0?(dontRetryConnection=!0,webSocket.close(1e3,"Closing conversation")):0===Object.keys(a.participants).length&&(disableControls(!0),startOnHoldMessages(),participants.textString="");var b=a.participants;updateUsers(b)}function notifyNewPagePushMessage(a){"use strict";var b=new Date(a.timestamp),c=a.pagePushURL,d=a.pagePushDestination;writeResponse(a.displayName+" pushed the following URL at "+b.toLocaleTimeString()+":",writeResponseClassResponse),appendLink(c,d,autoOpen)}function notifyQueueStatus(a){"use strict";var b=a.positionInQueue,c=a.estimatedWaitTime,d=Math.round(c/60);d>0&&b>0&&writeResponse("You are in position "+b+" in the queue. Estimated wait time is "+d+" minutes",writeResponseClassResponse)}function handleNotification(a){"use strict";var b=a.body,c=b.method;if(c===jsonMethodRequestChat)notifyRequestChat(b);else if(c===jsonMethodRequestNewParticipant)notifyNewParticipant(b);else if(c===jsonMethodRequestisTyping)notifyIsTyping(b);else if(c===jsonMethodRequestNewMessage)notifyNewMessage(b);else if(c===jsonMethodRequestCloseConversation)notifyCloseConversation(b);else if(c===jsonMethodRequestParticipantLeave)notifyParticipantLeave(b);else if(c===jsonMethodRequestNewPushMessage)notifyNewPagePushMessage(b);else if(c===jsonMethodRequestQueueMetrics)notifyQueueStatus(b);else if(c!==jsonMethodPing)throw new TypeError("Received notification with unknown method: "+c)}function openChat(){"use strict";initChat()}function initChat(){"use strict";initCalled||(g_user=getSessionStorage("user"),g_email=getSessionStorage("email"),g_skillset=getSessionStorage("skillset"),g_account=getSessionStorage("account"),g_phone=JSON.parse(getSessionStorage("phone")),g_country=getSessionStorage("country"),g_subject=getSessionStorage("subject"),void 0===outMessage&&(outMessage=getEl("outmessage")),disableControls(!0),openSocket(),initCalled=!0)}function startOnHoldMessages(){"use strict";webOnHoldInterval=setInterval(function(){void 0!==webOnHoldURLs&&playOnHoldMessages(webOnHoldURLs),void 0!==webOnHoldComfortGroups&&playOnHoldMessages(webOnHoldComfortGroups)},webOnHoldTimer),timeouts.push(webOnHoldInterval)}function clearTypingTimer(a){"use strict";a&&clearTimeout(a)}function startTypingTimer(){"use strict";clearTypingTimer(typeOut),isTyping===!1&&(isTyping=!0,sendIsTyping(isTyping)),typeOut=setTimeout(function(){isTyping=!1},typingTimeout),timeouts.push(typeOut)}function clearAllTimeouts(){"use strict";for(var a=0;a<timeouts.length;a++)clearTimeout(timeouts[a])}function sendPing(){"use strict";var a={apiVersion:"1.0",type:"request",body:{method:"ping"}};webSocket.send(JSON.stringify(a))}function openSocket(){"use strict";participants=getEl("participants"),(void 0===webSocket||webSocket.readyState===WebSocket.CLOSED)&&(clearTimeout(reconnectionTimeout),webSocket=new WebSocket(webChatUrl),webSocket.onopen=handleOpen,webSocket.onmessage=handleMessage,webSocket.onclose=function(a){disableControls(!0),1e3===a.code||dontRetryConnection?handleClose(a):reconnect()},webSocket.onerror=handleError)}function handleOpen(a){"use strict";disableControls(Object.keys(users).length<=0?!0:!1),pingInterval=setInterval(function(){sendPing()},pingTimer),timeouts.push(pingInterval),chatLogin(g_user,g_email,g_account,g_skillset,g_phone)}function handleMessage(a){"use strict";var b=JSON.parse(a.data),c=b.body;c.method;if(b.type===messageTypeNotification)handleNotification(b);else if(b.type===messageTypeError)writeResponse("An error occurred "+c.code+" ("+c.errorMessage+")",writeResponseClassResponse);else if(b.type===messageTypeAck);else{if(b.type!==messageTypeNewChatAck)throw new TypeError("Unknown message type:\n"+b);guid=c.guid,disableControls(!1),resetConnectionRetrys(),writeResponse("Chat request approved",writeResponseClassResponse)}}function handleClose(){"use strict";writeResponse("Connection closed",writeResponseClassResponse),disableControls(!0),outMessage.textContent="",clearAllTimeouts(),updateUsers()}function handleError(a){"use strict";writeResponse("A connection error has occurred",writeResponseClassResponse)}function reconnect(){"use strict";webSocket.readyState!==webSocket.OPEN&&(reconnectionTimeout=setTimeout(function(){maxNumberOfRetrys>=totalNumberOfRetrys?(openSocket(),dontRetryConnection||(clearTimeout(reconnectionTimeout),totalNumberOfRetrys++,reconnect())):(dontRetryConnection=!0,writeResponse("Connection failed",writeResponseClassResponse))},retryInterval))}function resetConnectionAttempts(){"use strict";totalNumberOfRetrys=0,dontRetryConnection=!1,clearTimeout(reconnectionTimeout)}function sendMessage(a){"use strict";null!==webSocket&&webSocket.readyState===WebSocket.OPEN&&webSocket.send(JSON.stringify(a))}function isStringEmpty(a){"use strict";return 0===a.length}function createJson(a){"use strict";var b={skillset:a};return JSON.stringify(b)}function receiveQueueStatus(a,b){"use strict";var c=JSON.parse(a),d=c.body.metrics,e=!1;e=isStringEmpty(pageSkillset)?checkAllSkillsets(d):checkSkillset(d),toggleChatButton(e,b,d)}function checkSkillset(a){"use strict";return a=removeFullQueues(a),a.length>0?(setSkillsets(a),!0):!1}function checkAllSkillsets(a){"use strict";return a=removeFullQueues(a),a.length>0?(setSkillsets(a),!0):!1}function removeFullQueues(a){"use strict";return a.filter(function(a){return a.customersInQueue<=a.availableAgentsInQueue*customerSoakValue&&a.customersInQueue<=a.maxConcurrentChats&&a.availableAgentsInQueue>0})}function toggleChatButton(a,b,c){"use strict";a===!0&&(b.removeAttribute("hidden"),b.style.visibility="visible")}function startQueueCheck(){"use strict";if(XMLHttpRequest&&WebSocket){var a=getEl("chatPanel"),b=new XMLHttpRequest({mozSystem:!0,timeout:queueTimeout});pageSkillset=getEl("pageSkillSet").value,a.setAttribute("hidden","hidden"),a.style.visibility="hidden",b.onreadystatechange=function(){4===b.readyState&&200===b.status&&receiveQueueStatus(b.response,a)},b.ontimeout=function(){},b.open("POST",restUrl),b.setRequestHeader("Content-Type","application/json"),b.send(createJson(pageSkillset))}}function createLogonWindow(){"use strict";var a="webChatLogon.html";window.open(a,"Web Chat Logon","width=400,height=500,resizable=yes")}function parseEmail(a){"use strict";var b=/[\w\.]+@\w+\.\w+/;return b.test(a)}function logon(a,b,c,d){"use strict";var e=!0,f=parseEmail(c);f===!1&&(e=window.confirm("You may use the chat without a valid email, but you will not be able to receive transcripts of the conversation")),e===!0&&(f===!1&&(c="",setSessionStorage("email",c)),usePopupForChat?window.open("WebChat.html","_self"):(switchFormToChat(),openChat()))}function switchFormToLogon(){"use strict";getEl("chatForm").style.display="block",getEl("chatInterface").style.display="none",getEl("chatPanel").style.height="183px"}function switchFormToChat(){"use strict";getEl("chatForm").style.display="none",getEl("chatInterface").style.display="block",getEl("chatPanel").style.height="363px"}function setSkillsets(a){"use strict";var b=getEl("skillset-chat"),c=getEl("country-chat");addCountryCodes(c);for(var d=0;d<a.length;d++){var e=a[d],f=document.createElement("option");f.value=e.queueName,f.text=e.queueName,b.appendChild(f)}}function gatherDetails(){"use strict";var a=getEl("user-chat").value,b=getEl("country-chat").value,c=getEl("email-chat").value,d=getEl("skillset-chat").value,e={country:getEl("country-chat").value,area:getEl("area-chat").value,phone:getEl("phone-chat").value};setSessionStorage("user",a),setSessionStorage("phone",JSON.stringify(e)),setSessionStorage("country",b),setSessionStorage("email",c),setSessionStorage("skillset",d),logon(a,e,c,d)}function hideCallbackDateForm(){"use strict";jQuery(function(a){var b=a(".callbackHandle");a(".dateInputClass").hasClass("open")&&b.click()})}function addCountryCodes(a){"use strict";var b=codes.countries;for(var c in b)if(b.hasOwnProperty(c)){var d=b[c];a.appendChild(addSelectOption(d.name+" ("+d.code+")",d.code))}}function showCallbackDateForm(){"use strict";callbackButton=getEl("button-callback"),callbackTime=getEl("time-callback"),callbackDate=getEl("date-callback"),callbackEmail=getEl("email-callback"),callbackPhone=getEl("phone-callback"),callbackArea=getEl("area-callback"),callbackName=getEl("user-callback"),callbackCountry=getEl("country-callback"),callbackSkillset=getEl("skillset-callback"),addCountryCodes(callbackCountry),getSkillsets(),callbackButton.onclick=function(){setCallbackDate()};for(var a=6;20>=a;a++)callbackTime.appendChild(addSelectOption(a+":00 ",a+":00 ")),callbackTime.appendChild(addSelectOption(a+":15 ",a+":15 ")),callbackTime.appendChild(addSelectOption(a+":30 ",a+":30 ")),callbackTime.appendChild(addSelectOption(a+":45 ",a+":45 "))}function addSelectOption(a,b){"use strict";var c=document.createElement("option");return c.textContent=a,c.value=b,c}function setCallbackDate(){"use strict";phone=callbackPhone.value,custName=callbackName.value,email=callbackEmail.value,skillset=callbackSkillset.value,countryCode=callbackCountry.value,areaCode=callbackArea.value;var a=new Date;user={method:"requestCallback",name:custName,phone:phone,email:email,countryCode:countryCode,areaCode:areaCode,skillset:skillset},theDate=$("#date-callback").datepicker("getDate");var b=callbackTime.value.split(":");theDate.setHours(b[0],b[1]);var c=Date.UTC(theDate.getFullYear(),theDate.getMonth(),theDate.getDate(),b[0],b[1]);if(theDate=new Date(c),verifyPhone(phone)&&verifyDate(a,theDate)&&!isCountryCodeEmpty(countryCode)){var d=theDate.getTime(),e=theDate.getTimezoneOffset(),f=d+6e4*e;user.date=f,sendJsonRequest(user)}else alert("Please enter a valid date and phone number")}function isCountryCodeEmpty(a){"use strict";return isStringEmpty(a)}function verifyPhone(a){"use strict";var b=/^[\+\d][\s\d]+$/;return b.test(a)}function verifyDate(a,b){"use strict";return b.getTime()>a.getTime()}function sendJsonRequest(a){"use strict";var b=new XMLHttpRequest;b.open("POST",callbackUrl),b.timeout=callbackTimeout,b.onreadystatechange=function(){if(4===b.readyState&&200===b.status){var a=JSON.parse(b.responseText);alert(a.status)}},b.setRequestHeader("Content-Type","application/json"),b.send(JSON.stringify(a))}function getSkillsets(){"use strict";if(window.XMLHttpRequest){var a=new XMLHttpRequest;a.open("POST",callbackUrl),a.timeout=callbackTimeout,a.onreadystatechange=function(){if(4===a.readyState&&200===a.status){var b=JSON.parse(a.response);processSkillsetsResponse(b)}};var b={method:"getSkillsets"};a.setRequestHeader("Content-Type","application/json"),a.send(JSON.stringify(b))}}function processSkillsetsResponse(a){"use strict";for(var b in a)if(a.hasOwnProperty(b)){var c=a[b];callbackSkillset.appendChild(addSelectOption(c,c))}}var customerSoakValue=2,browserWarning="Your browser does not support required features for this website. The earliest supported versions are Internet Explorer 10, Firefox 11, Chrome 31, Safari 7.1 and Opera 12.1",usePopupForChat=!1,queueTimeout=6e4,callbackTimeout=6e4;document.onreadystatechange=function(){"use strict";("complete"===document.readyState||"interactive"===document.readyState)&&(detectBrowserSupport(),gatherElements())};var webSocket,totalNumberOfRetrys=0,maxNumberOfRetrys=200,retryInterval=3e3,dontRetryConnection=!1,reconnectionTimeout,previouslyConnected=!1,queueStatusDelayTimeout=3500,messageTypeNewChatAck="newChatAcknowledgement",messageTypeAck="acknowledgement",messageTypeError="error",messageTypeNotification="notification",jsonMethodRequestChat="requestChat",jsonMethodRequestCallBack="callBack",jsonMethodRequestNewParticipant="newParticipant",jsonMethodRequestisTyping="isTyping",jsonMethodRequestNewMessage="newMessage",jsonMethodRequestCloseConversation="closeConversation",jsonMethodRequestParticipantLeave="participantLeave",jsonMethodRequestNewPushMessage="newPushPageMessage",jsonMethodRequestRequestTranscript="requestTranscript",jsonMethodRequestQueueMetrics="queueStatus",jsonMethodPing="ping",webOnHoldTimer=3e3,typingTimeout=1e4,agentTypingTimeout=3e3,pingTimer=5e3,participants,users={},writeResponseClassResponse="response",writeResponseClassSent="sent",agentImage="images/agent.png",agentTypingImage="images/agent_typing.png",supervisorImage="images/supervisor.png",supervisorTypingImage="images/supervisor_typing.png",sendButton,callbackRequestButton,closeButton,messages,outMessage,guid=null,webOnHoldComfortGroups,webOnHoldURLs,ak=null,webOnHoldInterval,pingInterval,isTyping=!1,typeOut,activeAgentTypeOut,passiveAgentTypeOut,supervisorTypeOut,usersTable,queueStatusDelay,g_email,g_user,g_skillset,g_account,g_phone,g_country,g_subject,initCalled=!1,autoOpen=!1,timeouts=[],pagePushDiv,pageSkillset,callbackDay,callbackMonth,callbackHour,callbackMinute,callbackButton,callbackTime,callbackDate,callbackEmail,callbackPhone,callbackCountry,callbackArea,callbackName,callbackSkillset,countryCode="",areaCode="",email="",custName="",phone,skillset,theDate,user={};