/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Internal;

import com.avaya.sdk.Data.POMAgentSkill;
import com.avaya.sdk.Data.POMAgentStatus;
import com.avaya.sdk.Data.POMAttribute;
import com.avaya.sdk.Data.POMCallbackDest;
import com.avaya.sdk.Data.POMCallbackType;
import com.avaya.sdk.Data.POMCapabilities;
import com.avaya.sdk.Data.POMCompletionCode;
import com.avaya.sdk.Data.POMContact;
import com.avaya.sdk.Data.POMContactNumber;
import com.avaya.sdk.Data.POMContactType;
import com.avaya.sdk.Data.POMCustomerDetails;
import com.avaya.sdk.Data.POMDestination;
import com.avaya.sdk.Data.POMDestinationType;
import com.avaya.sdk.Data.POMErrorCode;
import com.avaya.sdk.Data.POMErrorInfo;
import com.avaya.sdk.Data.POMErrorType;
import com.avaya.sdk.Data.POMKeyValuePair;
import com.avaya.sdk.Data.POMWrapupDetails;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.PAMSocketInfo;
import com.avaya.sdk.Socket.SocketUtil;
import java.util.HashMap;

public class Helper {
    public static int NUMBER_OF_POMADDRESS_MEMBERS = 7;
    public static int NUMBER_OF_PHONEADDRESS_ITEMS = 5;
    public static int NUMBER_OF_POMPHONE_ITEMS = 3;
    public static int NUMBER_OF_ERRORINFO_ITEMS = 5;

    public static POMCapabilities allFalseCapabilities() throws Exception {
        POMCapabilities allFalseCapabilities = new POMCapabilities();
        allFalseCapabilities.setChangeOwnership(false);
        allFalseCapabilities.setConference(false);
        allFalseCapabilities.setCreateCallback(false);
        allFalseCapabilities.setDisposition(false);
        allFalseCapabilities.setEndConference(false);
        allFalseCapabilities.setHold(false);
        allFalseCapabilities.setLeaveConference(false);
        allFalseCapabilities.setLeaveConsult(false);
        allFalseCapabilities.setNotReady(false);
        allFalseCapabilities.setOriginate(false);
        allFalseCapabilities.setReady(false);
        allFalseCapabilities.setRecord(false);
        allFalseCapabilities.setRelease(false);
        allFalseCapabilities.setSendDTMF(false);
        allFalseCapabilities.setTransfer(false);
        allFalseCapabilities.setUnhold(false);
        allFalseCapabilities.setUpdateRecord(false);
        allFalseCapabilities.setConnectField(false);
        return allFalseCapabilities;
    }

    public static String pOMCompletionCodeToString(POMCompletionCode compCode) throws Exception {
        String pomCompCodeString = "";
        pomCompCodeString = compCode.getcodeID() + ";" + compCode.getcodeValue() + ";";
        return pomCompCodeString;
    }

    public static String pOMDestinationToString(POMDestination destination) throws Exception {
        String pomDestinationString = "";
        pomDestinationString = destination.getdestinationName() + ";" + destination.getdestinationValue() + ";" + (Object)((Object)destination.getdestinationType()) + ";" + destination.gettimeZone() + ";" + destination.getpresence() + ";" + destination.getstate() + ";";
        return pomDestinationString;
    }

    public static String POMContactToString(POMContact contact) {
        StringBuffer pomContactString = new StringBuffer();
        pomContactString.append(contact.getContactType().toString() + " " + contact.getCanCancel().toString().toLowerCase() + " " + contact.getTimed().toString().toLowerCase() + " " + contact.getTimeout().toString() + " " + contact.getScriptURL() + " ");
        for (int i = 0; i < contact.getContactNumbers().length; ++i) {
            pomContactString.append(Helper.POMContactNumberToString(contact.getContactNumbers()[i]));
        }
        pomContactString.append(" " + contact.getDefaultNumber() + " ");
        pomContactString.append(" " + contact.getCampaignName() + " " + contact.getSkillsetName() + " " + contact.getCanEnterFreeFormNumber().toString() + " " + contact.getCallbackNotes() + " " + contact.getCanDial().toString().toLowerCase() + " " + contact.getCanReschedule().toString().toLowerCase() + " " + contact.getExpiryTime() + contact.getContactID() + contact.getSkillsetID());
        return pomContactString.toString();
    }

    public static String POMContactNumberToString(POMContactNumber contactNumber) {
        String pomContactNumberString = "";
        pomContactNumberString = contactNumber.getIsDefault().toString() + ";" + contactNumber.getName() + ";" + contactNumber.getNumber() + ";" + contactNumber.getTimezone() + ";";
        return pomContactNumberString;
    }

    public static String POMCallbackDestinationToString(POMCallbackDest callbackDestination) throws Exception {
        String pomDestinationString = "";
        pomDestinationString = callbackDestination.getdestinationName() + ";" + callbackDestination.getdestinationValue() + ";" + (Object)((Object)callbackDestination.getcallbackType()) + ";" + callbackDestination.gettimeZone() + ";" + callbackDestination.getpresence() + ";" + callbackDestination.getstate() + ";" + callbackDestination.getpomZone() + ";";
        return pomDestinationString;
    }

    public static String POMAgentStatusToString(POMAgentStatus agentStatus) throws Exception {
        String agentStatusString = "";
        agentStatusString = agentStatusString + agentStatus.getAgentState().toString() + ";";
        agentStatusString = agentStatusString + agentStatus.getCallState().toString() + ";";
        agentStatusString = agentStatusString + agentStatus.getNailupStatus().toString() + ";";
        return agentStatusString;
    }

    public static String POMAttributeToString(POMAttribute attribute) throws Exception {
        String pomAttribute = "";
        pomAttribute = attribute.key + "=" + attribute.value + ";" + attribute.attributeType.toString();
        return pomAttribute;
    }

    public static String POMKeyValuePairToString(POMKeyValuePair pair) throws Exception {
        String pairString = "";
        pairString = pair.key + "=" + pair.value + ";";
        return pairString;
    }

    public static POMKeyValuePair setEmptyPOMDKeyValuePair(POMKeyValuePair pair) throws Exception {
        pair.key = "";
        pair.value = "";
        return pair;
    }

    public static POMDestination setEmptyPOMDestination(POMDestination destination) throws Exception {
        destination.setdestinationName("");
        destination.setdestinationValue("");
        destination.setdestinationType(POMDestinationType.Agent);
        destination.settimeZone("");
        destination.setpresence("");
        destination.setstate("");
        return destination;
    }

    public static POMCallbackDest setEmptyPOMCallbackDest(POMCallbackDest destination) {
        destination.setdestinationName("");
        destination.setdestinationValue("");
        destination.setcallbackType(POMCallbackType.Standard);
        destination.settimeZone("");
        destination.setpresence("");
        destination.setstate("");
        destination.setpomZone("");
        return destination;
    }

    public static POMCompletionCode setEmptyPOMCompletionCode(POMCompletionCode compCode) throws Exception {
        compCode.setcodeID("");
        compCode.setcodeValue("");
        return compCode;
    }

    public static POMWrapupDetails setDefaultPOMWrapupDetails(POMWrapupDetails wrapupDetails) throws Exception {
        wrapupDetails.setAcwExtendable(false);
        wrapupDetails.setAcwMaxTime(-1);
        POMCompletionCode compCode = new POMCompletionCode();
        wrapupDetails.setDefaultCompCode(Helper.setEmptyPOMCompletionCode(compCode));
        return wrapupDetails;
    }

    public static POMContactNumber setEmptyPOMContactNumber(POMContactNumber contactNumber) throws Exception {
        contactNumber.setIsDefault(false);
        contactNumber.setName("");
        contactNumber.setNumber("");
        contactNumber.setTimezone("");
        return contactNumber;
    }

    public static POMContact setEmptyPOMContact(POMContact contact) throws Exception {
        contact.setContactType(POMContactType.Predictive);
        contact.setCanCancel(true);
        contact.setTimed(false);
        contact.setTimeout(0L);
        contact.setScriptURL("");
        contact.setContactNumbers(new POMContactNumber[1]);
        POMContactNumber[] pomContactNumber = new POMContactNumber[1];
        Helper.setEmptyPOMContactNumber(pomContactNumber[0]);
        contact.setContactNumbers(pomContactNumber);
        contact.setDefaultNumber("");
        contact.setCampaignName("");
        contact.setSkillsetName("");
        contact.setCanEnterFreeFormNumber(false);
        contact.setCallbackNotes("");
        contact.setCanDial(false);
        contact.setCanReschedule(false);
        contact.setExpiryTime("");
        contact.setContactID(0L);
        contact.setSkillsetID("");
        return contact;
    }

    public static POMCustomerDetails setEmptyPOMCustomerDetails(POMCustomerDetails customerDetails) throws Exception {
        return null;
    }

    public static void setPOMDestinationUsingString(POMDestination destination, String pomDestinationString) throws Exception {
        String[] tokens = pomDestinationString.split(";");
        int tokenCounter = 0;
        destination.setdestinationName(tokens[tokenCounter++]);
        destination.setdestinationValue(tokens[tokenCounter++]);
        try {
            destination.setdestinationType(POMDestinationType.valueOf(tokens[tokenCounter++]));
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
        }
        destination.settimeZone(tokens[tokenCounter++]);
        destination.setpresence(tokens[tokenCounter++]);
        destination.setstate(tokens[tokenCounter++]);
    }

    public static void setZonePAMMapUsingFeedbackValue(HashMap<String, PAMSocketInfo> zonePAMMap, String[] zonePAMMapString) throws Exception {
        try {
            String[] stringArray = zonePAMMapString;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String __dummyForeachVar0;
                String singleMap = __dummyForeachVar0 = stringArray[i];
                String[] tokens = singleMap.split(";");
                PAMSocketInfo pa = new PAMSocketInfo();
                if (tokens[1].equals("null") || tokens[1].equals("")) continue;
                pa.ipAddress = tokens[1];
                pa.port = Integer.parseInt(tokens[2]);
                zonePAMMap.put(tokens[0], pa);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
    }

    public static void setEmptyErrorInfo(POMErrorInfo errorInfo) throws Exception {
        errorInfo.seterrorCode("");
        errorInfo.setapiName("");
        errorInfo.seterrorString("");
        errorInfo.setlocalizedString("");
        errorInfo.seterrorType(POMErrorType.Minor);
    }

    public static String POMErrorCodeToString(POMErrorCode errorCode) throws Exception {
        String pomErrorCodeString = "";
        pomErrorCodeString = errorCode.geterrorCode() + ";" + errorCode.getapiName();
        return pomErrorCodeString;
    }

    public static String convertPOMAgentSkillArrayToString(POMAgentSkill[] agentSkills) throws Exception {
        StringBuffer agentSkillsString = new StringBuffer();
        if (agentSkills != null) {
            try {
                for (int i = 0; i < agentSkills.length; ++i) {
                    agentSkillsString.append(agentSkills[i].getid());
                    agentSkillsString.append(";");
                    agentSkillsString.append(agentSkills[i].getname());
                    agentSkillsString.append(";");
                    agentSkillsString.append(agentSkills[i].getlevel());
                    agentSkillsString.append(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0]);
                }
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception", e);
            }
        }
        return agentSkillsString.toString();
    }
}

