/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Internal;

import com.avaya.sdk.Agent.POMAgentHandlerInterface;
import com.avaya.sdk.Data.POMAddress;
import com.avaya.sdk.Data.POMAgentState;
import com.avaya.sdk.Data.POMAttribute;
import com.avaya.sdk.Data.POMAttributeType;
import com.avaya.sdk.Data.POMCallState;
import com.avaya.sdk.Data.POMCallbackDest;
import com.avaya.sdk.Data.POMCallbackType;
import com.avaya.sdk.Data.POMCapabilities;
import com.avaya.sdk.Data.POMCompletionCode;
import com.avaya.sdk.Data.POMContact;
import com.avaya.sdk.Data.POMContactNumber;
import com.avaya.sdk.Data.POMContactType;
import com.avaya.sdk.Data.POMContextStoreData;
import com.avaya.sdk.Data.POMCustomerDetails;
import com.avaya.sdk.Data.POMDestination;
import com.avaya.sdk.Data.POMDestinationType;
import com.avaya.sdk.Data.POMDialFailReason;
import com.avaya.sdk.Data.POMErrorInfo;
import com.avaya.sdk.Data.POMErrorType;
import com.avaya.sdk.Data.POMKeyValuePair;
import com.avaya.sdk.Data.POMNailupStatus;
import com.avaya.sdk.Data.POMOrganizationInfo;
import com.avaya.sdk.Data.POMPhone;
import com.avaya.sdk.Data.POMWrapupDetails;
import com.avaya.sdk.Data.POMZoneInfo;
import com.avaya.sdk.Internal.AgentAPIList;
import com.avaya.sdk.Internal.AgentFeedbackExecutor;
import com.avaya.sdk.Internal.Helper;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Internal.MessageTypeList;
import com.avaya.sdk.PAMSocketInfo;
import com.avaya.sdk.POMServer;
import com.avaya.sdk.Socket.SocketClient;
import com.avaya.sdk.Socket.SocketUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class AgentEventListener
extends Thread {
    private static int corePoolSize = 100;
    private static int maxThreadIdleTime = 120000;
    private static int SAME_AGENT_TASK_DELAY = 25;
    private static final String SUCCESS_RESULT = "0";
    private static final int MIN_FEEDBACK_VALUES = 1;
    public static final int MAX_FEEDBACK_VALUES = 10;
    private Thread newThread = this;
    private static ArrayBlockingQueue<Message> packetsQueue = new ArrayBlockingQueue(5000);
    private ScheduledThreadPoolExecutor threadExecutor;
    boolean keepAlive = true;

    public AgentEventListener(SocketClient socketClient) throws Exception {
    }

    private static ArrayBlockingQueue<Message> getPacketsQueue() {
        return packetsQueue;
    }

    public static void addPacketToQueue(Message pkt) {
        try {
            packetsQueue.put(pkt);
        }
        catch (InterruptedException e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
    }

    private static Message getPacketFromQueue() {
        Message packet = null;
        try {
            packet = packetsQueue.take();
        }
        catch (InterruptedException e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
        return packet;
    }

    public void runThread() throws Exception {
        this.start();
    }

    public void stopAgentEventListener() throws Exception {
        if (this.newThread != null) {
            this.setKeepAlive(false);
            this.newThread.interrupt();
        }
    }

    public AgentEventListener(SocketClient sckClient, int numThreads) throws Exception {
        corePoolSize = numThreads;
    }

    public boolean isKeepAlive() throws Exception {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) throws Exception {
        this.keepAlive = keepAlive;
    }

    @Override
    public void run() {
        this.setName("AgentEventListener" + this.newThread.getId());
        this.threadExecutor = new ScheduledThreadPoolExecutor(corePoolSize);
        this.threadExecutor.setKeepAliveTime(maxThreadIdleTime, TimeUnit.MILLISECONDS);
        while (this.keepAlive) {
            try {
                this.processEvent(null);
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error(" Exception during processing AgentEventListener", ex);
            }
        }
        InitPOMAgentFactory.getTracer().finest(" Shutting down thread pool.");
        this.threadExecutor.shutdownNow();
    }

    private String[] getEmptyFeedbackParamsForErrorHandling(String[] feedbackParams) throws Exception {
        String[] emptyArrayList = new String[10];
        for (int i = 0; i < 10; ++i) {
            emptyArrayList[i] = "";
        }
        return emptyArrayList;
    }

    public void processInternalEvent(Message inMessage) throws Exception {
        this.processEvent(inMessage);
    }

    private void processEvent(Message internalMsg) throws Exception {
        if (internalMsg != null) {
            InitPOMAgentFactory.getTracer().finest("AgentEventListener::processEvent() Receiving data from server (internalMsg = " + internalMsg + ")");
        }
        Message socketFeedback = null;
        if (internalMsg == null) {
            int count = AgentEventListener.getPacketsQueue().size();
            if (count > 0) {
                InitPOMAgentFactory.getTracer().finest("AgentEventListener::processEvent() receiverQ size = " + count);
                socketFeedback = AgentEventListener.getPacketFromQueue();
                if (socketFeedback != null) {
                    StringBuffer commandParams = new StringBuffer();
                    for (int i = 0; i < socketFeedback.getCommandParams().length; ++i) {
                        commandParams.append(socketFeedback.getCommandParams()[i]);
                    }
                    InitPOMAgentFactory.getTracer().finest("AgentEventListener::processEvent() socketFeedback header = " + (Object)((Object)socketFeedback.getCommandHeader().getCommandName()) + ":" + (Object)((Object)socketFeedback.getCommandHeader().getCommandType()) + ":" + socketFeedback.getCommandHeader().getPacketID() + " packet = " + socketFeedback.getCommandPacket() + " params = " + commandParams);
                } else {
                    InitPOMAgentFactory.getTracer().fine("AgentEventListener::processEvent() Cannot print socketfeedback because it is null.");
                }
                this.processSocketFeedback(socketFeedback);
            } else {
                Thread.sleep(10L);
            }
        } else {
            socketFeedback = internalMsg;
            this.processSocketFeedback(socketFeedback);
        }
    }

    private void processSocketFeedback(Object message) throws Exception {
        Message socketFeedback = (Message)message;
        String agentId = "";
        if (socketFeedback != null) {
            try {
                agentId = socketFeedback.getCommandHeader().getAgentId();
                MessageTypeList feedbackType = socketFeedback.getCommandHeader().getCommandType();
                Method method = null;
                AgentAPIList socketFeedbackName = socketFeedback.getCommandHeader().getCommandName();
                String eventName = socketFeedbackName.toString();
                String[] feedbackParams = socketFeedback.getCommandParams();
                Date d1 = Calendar.getInstance().getTime();
                InitPOMAgentFactory.getTracer().finest("AgentEventListener::processSocketFeedback() " + d1 + "RECEIVED FROM PAM: " + (Object)((Object)socketFeedbackName) + " WITH ID:" + socketFeedback.getCommandHeader().getPacketID());
                POMAgentHandlerInterface pahi = InitPOMAgentFactory.getAgentHandler(agentId);
                if (socketFeedbackName == AgentAPIList.GetAgentStatus) {
                    InitPOMAgentFactory.getTracer().finest("AgentEventListener::processSocketFeedback() GetAgentStatus received.");
                }
                if (pahi != null) {
                    switch (feedbackType) {
                        case C: {
                            InitPOMAgentFactory.getTracer().fine("Client cannot receive a command. It can get only response or notification");
                            break;
                        }
                        case R: {
                            if (feedbackParams == null || feedbackParams.length < 2 && !socketFeedback.getResult().equalsIgnoreCase(SUCCESS_RESULT)) {
                                int startingValue = 0;
                                if (feedbackParams != null && feedbackParams.length > 0) {
                                    String param1 = feedbackParams[0];
                                    startingValue = feedbackParams.length;
                                    feedbackParams = new String[10];
                                    feedbackParams[0] = param1;
                                } else {
                                    feedbackParams = new String[10];
                                }
                                for (int i = startingValue; i < 10; ++i) {
                                    feedbackParams[i] = "";
                                }
                            }
                            eventName = eventName + "RESP";
                            if (!socketFeedback.getResult().equalsIgnoreCase(SUCCESS_RESULT) && feedbackParams.length < 1) {
                                feedbackParams = this.getEmptyFeedbackParamsForErrorHandling(feedbackParams);
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() - Error in response (" + (Object)((Object)socketFeedbackName) + "), so preparing empty list.");
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetConsultDestsForType) {
                                POMDestination[] pomDestinationArray;
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMDestinationType.class, POMDestination[].class, String.class, Integer.TYPE);
                                if (!socketFeedback.getResult().equalsIgnoreCase(SUCCESS_RESULT) && feedbackParams.length == 1) {
                                    pomDestinationArray = this.getEmptyPOMDestinationsArray();
                                } else {
                                    InitPOMAgentFactory.getTracer().finest("AgentEventListener::processSocketFeedback - feedbackParams size " + feedbackParams.length + " feedbackParams.item [" + feedbackParams[0] + "]");
                                    pomDestinationArray = this.getPOMDestinationsArray(feedbackParams[2] instanceof String ? feedbackParams[2] : (String)null, socketFeedback.getResult());
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMDestinationTypeArray(feedbackParams[1], socketFeedback.getResult())[0], pomDestinationArray, this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult())});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AgentSDKConnected) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, HashMap.class);
                                String[] feedbackParamsWithZoneMapping = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsWithZoneMapping, 0, feedbackParamsWithZoneMapping.length);
                                }
                                HashMap<String, PAMSocketInfo> zonePAMMap = this.getZonePAMMapping(feedbackParamsWithZoneMapping);
                                InitPOMAgentFactory.setZonePAMMap(zonePAMMap);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), zonePAMMap);
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.GetPAMForZone) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, HashMap.class);
                                String[] feedbackParamsWithZoneMapping = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsWithZoneMapping, 0, feedbackParamsWithZoneMapping.length);
                                }
                                HashMap<String, PAMSocketInfo> zonePAMMap = this.getZonePAMMapping(feedbackParamsWithZoneMapping);
                                InitPOMAgentFactory.setZonePAMMap(zonePAMMap);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), zonePAMMap);
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.GetZoneList) {
                                POMServer pomServer = InitPOMAgentFactory.getPomServer();
                                if (pomServer != null) {
                                    POMZoneInfo[] pomZoneInfo;
                                    Class<?> myTypeObj = pomServer.getHandler().getClass();
                                    method = myTypeObj.getMethod(eventName, POMZoneInfo[].class);
                                    String[] feedbackParamsWithList = new String[feedbackParams.length - 1];
                                    if (feedbackParams.length > 1) {
                                        System.arraycopy(feedbackParams, 1, feedbackParamsWithList, 0, feedbackParamsWithList.length);
                                    }
                                    Object[] temp = new Object[]{pomZoneInfo = this.getPOMZoneInfoArray(feedbackParamsWithList)};
                                    AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pomServer.getHandler(), socketFeedback.getCommandHeader().getPacketID(), temp);
                                    this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                    break;
                                }
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback - POMServer object not found.");
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.GetOrganizationList) {
                                POMServer pomServer = InitPOMAgentFactory.getPomServer();
                                if (pomServer != null) {
                                    POMOrganizationInfo[] pomOrganizationInfo;
                                    Class<?> myTypeObj = pomServer.getHandler().getClass();
                                    method = myTypeObj.getMethod(eventName, POMOrganizationInfo[].class);
                                    String[] feedbackParamsWithList = new String[feedbackParams.length - 1];
                                    if (feedbackParams.length > 1) {
                                        System.arraycopy(feedbackParams, 1, feedbackParamsWithList, 0, feedbackParamsWithList.length);
                                    }
                                    Object[] temp = new Object[]{pomOrganizationInfo = this.getPOMOrganizationInfoArray(feedbackParamsWithList)};
                                    AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pomServer.getHandler(), socketFeedback.getCommandHeader().getPacketID(), temp);
                                    this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                    break;
                                }
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback - POMServer object not found.");
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTStateChange) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMAgentState.class, Integer.TYPE);
                                POMAgentState agentState = POMAgentState.NotReady;
                                if (socketFeedback.getResult().equals(SUCCESS_RESULT)) {
                                    agentState = this.getPOMAgentStateFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult());
                                } else {
                                    this.getPOMAgentStateFromFeedback(null, socketFeedback.getResult());
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{agentState, Integer.parseInt(socketFeedback.getResult())});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetConsultTypes) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMDestinationType[].class, Boolean.TYPE, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMDestinationTypeArray(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getBooleanValueFromFeedback(feedbackParams[2] instanceof String ? feedbackParams[2] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult())});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetCompCodes) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCompletionCode[].class, String.class, Integer.TYPE);
                                POMCompletionCode[] pomCompletionCodeArray = !socketFeedback.getResult().equalsIgnoreCase(SUCCESS_RESULT) && feedbackParams.length == 1 ? this.getEmptyPOMCompletionCodeArray() : this.getCompletionCodesArray(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult());
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), pomCompletionCodeArray, this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTReleaseLine || socketFeedbackName == AgentAPIList.AGTPreviewCancel) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTLostNailing) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTCompleteTransfer) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Boolean.TYPE, POMWrapupDetails.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getBooleanValueFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getPOMWrapupDetails(feedbackParams[2] instanceof String ? feedbackParams[2] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTEndConf) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConfChangeOwnership || socketFeedbackName == AgentAPIList.AGTCreateCallback) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConsultCall || socketFeedbackName == AgentAPIList.AGTHoldCall || socketFeedbackName == AgentAPIList.AGTUnholdCall || socketFeedbackName == AgentAPIList.AGTCancelConsult || socketFeedbackName == AgentAPIList.AGTRedial || socketFeedbackName == AgentAPIList.AGTSendDTMF || this.isPreviewOrManualDial(socketFeedbackName) || socketFeedbackName == AgentAPIList.AGTSetCustomerDetail || socketFeedbackName == AgentAPIList.AGTAddAgentNote || socketFeedbackName == AgentAPIList.AGTAddToDNC || socketFeedbackName == AgentAPIList.AGTStartConf || socketFeedbackName == AgentAPIList.AGTWrapupContact) {
                                String returnValues = "";
                                if (feedbackParams.length > 0) {
                                    returnValues = feedbackParams[0] instanceof String ? feedbackParams[0] : (String)null;
                                }
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTLogon) {
                                String returnValues = "";
                                if (feedbackParams.length > 0) {
                                    returnValues = feedbackParams[0] instanceof String ? feedbackParams[0] : (String)null;
                                }
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTExtendWrapup) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetCallbackTypes) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCallbackType[].class, String.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMCallbackTypeArray(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), feedbackParams[2], this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult())});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetCallbackDestsForType) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCallbackType.class, POMCallbackDest[].class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMCallbackTypeArray(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult())[0], this.getPOMCallbackDestsArray(feedbackParams[2] instanceof String ? feedbackParams[2] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult())});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetErrorString) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1], feedbackParams[2], Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetErrorInfo) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMErrorInfo.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getErrorInfo(feedbackParams[1], socketFeedback.getResult()), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetCustomerDetails) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCustomerDetails.class, String.class, Integer.TYPE);
                                String[] feedbackParamsOfCustDetails = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsOfCustDetails, 0, feedbackParamsOfCustDetails.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), AgentEventListener.getCustomerDetails(feedbackParamsOfCustDetails, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetContactAttributes) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMAttribute[].class, String.class, Integer.TYPE);
                                String[] feedbackParamsOfContactAttributes = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsOfContactAttributes, 0, feedbackParamsOfContactAttributes.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), AgentEventListener.getContactAttributes(feedbackParamsOfContactAttributes, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTRefreshAgentNotes) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String[].class, String.class, Integer.TYPE);
                                String[] feedbackParamsOfAgentNotes = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsOfAgentNotes, 0, feedbackParamsOfAgentNotes.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), AgentEventListener.getAgentNotesFromArray(feedbackParamsOfAgentNotes, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetTimezones) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMKeyValuePair[].class, Integer.TYPE);
                                String[] feedbackParamsOfGetTimezones = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsOfGetTimezones, 0, feedbackParamsOfGetTimezones.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), AgentEventListener.getPOMKeyValuePairArrayFromArrayList(feedbackParamsOfGetTimezones, socketFeedback.getResult()), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetZoneList) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String[].class, Integer.TYPE);
                                String[] feedbackParamsOfGetZoneList = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsOfGetZoneList, 0, feedbackParamsOfGetZoneList.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParamsOfGetZoneList, Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTIsInDNC) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Boolean.TYPE, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getBooleanValueFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTGetWorkRequestId) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMContextStoreData.class, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getContextStoreData(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, socketFeedback.getResult()), this.getSessionID(feedbackParams[0]), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.PacketACK) {
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() - PacketACK not expected. pktid = " + socketFeedback.getCommandHeader().getPacketID());
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.POMClientAlive) {
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() - Ignoring POMClientAlive error response");
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTAvailableForNailup) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTReadyForNailup) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTLogoff) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.GetAgentStatusResponse) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTBlendToOutbound) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTBlendToInbound) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTNailupAgent) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTPendingLogout) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTAgentDisconnected) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTBlendedToInbound) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            Class<?> myTypeObj = pahi.getClass();
                            method = myTypeObj.getMethod(eventName, new Class[0]);
                            AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), Integer.parseInt(socketFeedback.getResult()));
                            this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                            break;
                        }
                        case N: {
                            if (feedbackParams.length < 1) {
                                feedbackParams = this.getEmptyFeedbackParamsForErrorHandling(feedbackParams);
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() - Error in Notification (" + (Object)((Object)socketFeedbackName) + "), so preparing empty feedback list.");
                            }
                            if (socketFeedbackName == AgentAPIList.AGTCallNotify) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMContact.class, String.class);
                                String[] feedbackParamsForNotify = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsForNotify, 0, feedbackParamsForNotify.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMContact(feedbackParamsForNotify, SUCCESS_RESULT), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTTransferNotify || socketFeedbackName == AgentAPIList.AGTConferenceNotify || socketFeedbackName == AgentAPIList.AGTConferenceOwnershipChanged) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMContact.class, String.class);
                                String[] feedbackParamsForNotify = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsForNotify, 0, feedbackParamsForNotify.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMContact(feedbackParamsForNotify, SUCCESS_RESULT), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConsultNotify) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMContact.class, String.class, String.class);
                                String[] feedbackParamsForNotify = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsForNotify, 0, feedbackParamsForNotify.length);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMContact(feedbackParamsForNotify, SUCCESS_RESULT), feedbackParamsForNotify[17], this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTCustomerDetailsChanged) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMAttribute.class, String.class);
                                String[] feedbackParamsForNotify = new String[feedbackParams.length - 1];
                                if (feedbackParams.length > 1) {
                                    System.arraycopy(feedbackParams, 1, feedbackParamsForNotify, 0, feedbackParamsForNotify.length);
                                }
                                POMAttribute pomAttribute = new POMAttribute();
                                AgentEventListener.checkAndSetAttribute(pomAttribute, feedbackParamsForNotify[0].split("="));
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), pomAttribute, this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConsultDialFailed) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMErrorInfo.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMDialFailReasonFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT), this.getSessionID(feedbackParams[0])});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTDialFailed) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, POMDialFailReason.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT), this.getPOMDialFailReasonFromFeedback(feedbackParams[2] instanceof String ? feedbackParams[2] : (String)null, SUCCESS_RESULT), this.getSessionID(feedbackParams[0])});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTAutoReleaseLine) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTCapabilitiesChanged) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCapabilities.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), AgentEventListener.getPOMCapabilities(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTStateChangedNotify) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMAgentState.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{this.getPOMAgentStateFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT)});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTCallStateChangedNotify) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMCallState.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{AgentEventListener.getPOMCallStateFromFeedback(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT)});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTNailupChange) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMNailupStatus.class);
                                POMNailupStatus pomNailupStatus = null;
                                if (feedbackParams[1] != null && feedbackParams[1] instanceof String) {
                                    pomNailupStatus = POMNailupStatus.valueOf(feedbackParams[1]);
                                }
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[]{pomNailupStatus});
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConsultPending) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, String.class, String.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1], feedbackParams[2], feedbackParams[3], this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTPreviewCallbackPending || socketFeedbackName == AgentAPIList.AGTConsultCancelled) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1], this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.GetAgentStatus) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), socketFeedback.getCommandHeader().getAgentId());
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.PAMAvailable) {
                                SocketClient pamAvailableSocketClient = InitPOMAgentFactory.getSocketClientForZoneName(feedbackParams[1]);
                                if (pamAvailableSocketClient != null) {
                                    InitPOMAgentFactory.sendPOMAvailableNotificationToPOMProxy(pamAvailableSocketClient, socketFeedback.getCommandHeader().getPacketID(), socketFeedback.getCommandHeader().getAgentId());
                                    break;
                                }
                                InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() - PAMAvailable notification recieved, but no socketClient found for zone " + feedbackParams[0]);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTEnableCancelConsult || socketFeedbackName == AgentAPIList.AGTConferenceEnded || socketFeedbackName == AgentAPIList.AGTPendingConsultComplete || socketFeedbackName == AgentAPIList.AGTPreviewCallbackCancelled || socketFeedbackName == AgentAPIList.AGTInvalidCommandName) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTZoneDown) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, Integer.TYPE);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1], Integer.parseInt(feedbackParams[2]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTJobAttached) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1]);
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTConsultDialFailedErrorInfo) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMErrorInfo.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getErrorInfo(feedbackParams[1], SUCCESS_RESULT), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTDialFailedErrorInfo) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, POMWrapupDetails.class, POMErrorInfo.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), this.getPOMWrapupDetails(feedbackParams[1] instanceof String ? feedbackParams[1] : (String)null, SUCCESS_RESULT), this.getErrorInfo(feedbackParams[2], SUCCESS_RESULT), this.getSessionID(feedbackParams[0]));
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            if (socketFeedbackName == AgentAPIList.AGTSessionIDChange) {
                                Class<?> myTypeObj = pahi.getClass();
                                method = myTypeObj.getMethod(eventName, String.class, String.class);
                                AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), feedbackParams[1], feedbackParams[2]);
                                this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                                break;
                            }
                            Class<?> myTypeObj = pahi.getClass();
                            method = myTypeObj.getMethod(eventName, new Class[0]);
                            AgentFeedbackExecutor agentFeedbackExecutor = new AgentFeedbackExecutor(agentId, method, pahi, socketFeedback.getCommandHeader().getPacketID(), new Object[0]);
                            this.executeAgentTasksInSequence(agentId, agentFeedbackExecutor);
                        }
                    }
                } else {
                    InitPOMAgentFactory.getTracer().fine("AgentEventListener::processSocketFeedback() AgentHandler not found for " + agentId);
                }
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error(" Exception in processing AgentEvent ", e);
            }
        }
    }

    private boolean isPreviewOrManualDial(AgentAPIList socketFeedbackName) {
        return socketFeedbackName == AgentAPIList.AGTPreviewDial || socketFeedbackName == AgentAPIList.AGTManualCallConnect;
    }

    public static POMContactType getPOMContactType(String feedbackValue, String result) throws Exception {
        POMContactType contactType = POMContactType.Predictive;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return POMContactType.Predictive;
        }
        try {
            contactType = POMContactType.valueOf(feedbackValue);
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("AgentEventListener::getPOMContactType() - exception ", ex);
        }
        return contactType;
    }

    public static POMCapabilities getPOMCapabilities(String feedbackValue, String result) throws Exception {
        POMCapabilities capabilities = null;
        String[] tokens = feedbackValue.split(";");
        int i = 0;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            capabilities = Helper.allFalseCapabilities();
        } else {
            capabilities = new POMCapabilities();
            capabilities.setHold(Boolean.parseBoolean(tokens[i++]));
            capabilities.setUnhold(Boolean.parseBoolean(tokens[i++]));
            capabilities.setTransfer(Boolean.parseBoolean(tokens[i++]));
            capabilities.setConference(Boolean.parseBoolean(tokens[i++]));
            capabilities.setRelease(Boolean.parseBoolean(tokens[i++]));
            capabilities.setDisposition(Boolean.parseBoolean(tokens[i++]));
            capabilities.setOriginate(Boolean.parseBoolean(tokens[i++]));
            capabilities.setCreateCallback(Boolean.parseBoolean(tokens[i++]));
            capabilities.setSendDTMF(Boolean.parseBoolean(tokens[i++]));
            capabilities.setUpdateRecord(Boolean.parseBoolean(tokens[i++]));
            capabilities.setLeaveConference(Boolean.parseBoolean(tokens[i++]));
            capabilities.setRecord(Boolean.parseBoolean(tokens[i++]));
            capabilities.setLeaveConsult(Boolean.parseBoolean(tokens[i++]));
            capabilities.setEndConference(Boolean.parseBoolean(tokens[i++]));
            capabilities.setChangeOwnership(Boolean.parseBoolean(tokens[i++]));
            capabilities.setNotReady(Boolean.parseBoolean(tokens[i++]));
            capabilities.setReady(Boolean.parseBoolean(tokens[i++]));
            capabilities.setConnectField(Boolean.parseBoolean(tokens[i]));
        }
        return capabilities;
    }

    public POMCallbackType[] getPOMCallbackTypeArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMCallbackType[] allPOMCallbackType = new POMCallbackType[]{POMCallbackType.Standard, POMCallbackType.Agent, POMCallbackType.Campaign};
            return allPOMCallbackType;
        }
        String[] tokens = pairs.split(";");
        POMCallbackType[] pomCallbackTypeArray = null;
        if (tokens.length == 1) {
            pomCallbackTypeArray = new POMCallbackType[tokens.length];
            pomCallbackTypeArray[0] = POMCallbackType.valueOf(tokens[0]);
            return pomCallbackTypeArray;
        }
        pomCallbackTypeArray = new POMCallbackType[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            try {
                pomCallbackTypeArray[i] = POMCallbackType.valueOf(tokens[i]);
                continue;
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception - getPOMCallbackTypeArray : ", ex);
            }
        }
        return pomCallbackTypeArray;
    }

    public POMDestinationType[] getPOMDestinationTypeArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMDestinationType[] allPOMDestinationType = new POMDestinationType[]{POMDestinationType.Agent, POMDestinationType.Campaign, POMDestinationType.External};
            return allPOMDestinationType;
        }
        String[] tokens = pairs.split(";");
        POMDestinationType[] pomDestinationTypeArray = null;
        try {
            if (tokens.length == 1) {
                pomDestinationTypeArray = new POMDestinationType[tokens.length];
                pomDestinationTypeArray[0] = POMDestinationType.valueOf(tokens[0]);
            } else {
                pomDestinationTypeArray = new POMDestinationType[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    pomDestinationTypeArray[i] = POMDestinationType.valueOf(tokens[i]);
                }
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception getPOMDestinationTypeArray", ex);
        }
        return pomDestinationTypeArray;
    }

    public POMDestination[] getEmptyPOMDestinationsArray() throws Exception {
        POMDestination[] destinationArray = new POMDestination[1];
        POMDestination destination = new POMDestination();
        Helper.setEmptyPOMDestination(destination);
        destinationArray[0] = destination;
        return destinationArray;
    }

    public POMCompletionCode[] getEmptyPOMCompletionCodeArray() throws Exception {
        POMCompletionCode[] destinationArray = new POMCompletionCode[1];
        POMCompletionCode compCode = new POMCompletionCode();
        Helper.setEmptyPOMCompletionCode(compCode);
        destinationArray[0] = compCode;
        return destinationArray;
    }

    public POMDestination[] getPOMDestinationsArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        int NUM_OF_MEMBERS_IN_DESTINATION = 6;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMDestination[] destinationArray = new POMDestination[1];
            POMDestination destination = new POMDestination();
            Helper.setEmptyPOMDestination(destination);
            destinationArray[0] = destination;
            return destinationArray;
        }
        String[] tokens = pairs.split(";");
        POMDestination[] destinationArray = new POMDestination[tokens.length / NUM_OF_MEMBERS_IN_DESTINATION];
        int dNum = 0;
        int i = 0;
        while (i < tokens.length - 1) {
            POMDestination destination = new POMDestination();
            destination.setdestinationName(tokens[i++]);
            destination.setdestinationValue(tokens[i++]);
            destination.setdestinationType(POMDestinationType.valueOf(tokens[i++]));
            destination.settimeZone(tokens[i++]);
            destination.setpresence(tokens[i++]);
            destination.setstate(tokens[i++]);
            destinationArray[dNum++] = destination;
        }
        return destinationArray;
    }

    public POMCallbackDest[] getPOMCallbackDestsArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        int NUM_OF_MEMBERS_IN_CALLBACKDEST = 7;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMCallbackDest[] callbackDestArray = new POMCallbackDest[1];
            POMCallbackDest callbackDest = new POMCallbackDest();
            Helper.setEmptyPOMCallbackDest(callbackDest);
            callbackDestArray[0] = callbackDest;
            return callbackDestArray;
        }
        try {
            String[] tokens = pairs.split(";");
            POMCallbackDest[] destinationArray = new POMCallbackDest[tokens.length / NUM_OF_MEMBERS_IN_CALLBACKDEST];
            int dNum = 0;
            int i = 0;
            while (i < tokens.length - 1) {
                POMCallbackDest callbackDest = new POMCallbackDest();
                callbackDest.setdestinationName(tokens[i++]);
                callbackDest.setdestinationValue(tokens[i++]);
                callbackDest.setcallbackType(POMCallbackType.valueOf(tokens[i++]));
                callbackDest.settimeZone(tokens[i++]);
                callbackDest.setpresence(tokens[i++]);
                callbackDest.setstate(tokens[i++]);
                callbackDest.setpomZone(tokens[i++]);
                destinationArray[dNum++] = callbackDest;
            }
            return destinationArray;
        }
        catch (Exception ex) {
            POMCallbackDest[] callbackDestArray = new POMCallbackDest[1];
            POMCallbackDest callbackDest = new POMCallbackDest();
            Helper.setEmptyPOMCallbackDest(callbackDest);
            callbackDestArray[0] = callbackDest;
            InitPOMAgentFactory.getTracer().error("Exception AgentEventListener::getPOMCallbacksDestsArray  : ", ex);
            return callbackDestArray;
        }
    }

    public POMCompletionCode getPOMCompletionCode(String feedbackValue, String result) throws Exception {
        POMCompletionCode completionCode = new POMCompletionCode();
        String[] tokens = feedbackValue.split(";");
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            Helper.setEmptyPOMCompletionCode(completionCode);
        } else {
            completionCode.setcodeID(tokens[0]);
            completionCode.setcodeValue(tokens[1]);
        }
        return completionCode;
    }

    public POMWrapupDetails getPOMWrapupDetails(String feedbackValue, String result) throws Exception {
        POMWrapupDetails wrapupDetails = new POMWrapupDetails();
        try {
            if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
                Helper.setDefaultPOMWrapupDetails(wrapupDetails);
            } else {
                String[] tokens = feedbackValue.split(";");
                wrapupDetails.setAcwMaxTime(Integer.parseInt(tokens[0]));
                wrapupDetails.setAcwExtendable(Boolean.valueOf(tokens[1]));
                String compCodeString = tokens[2] + ";" + tokens[3];
                wrapupDetails.setDefaultCompCode(this.getPOMCompletionCode(compCodeString, SUCCESS_RESULT));
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception getPOMWrapupDetails ", e);
        }
        return wrapupDetails;
    }

    public static POMKeyValuePair[] getPOMKeyValuePairArrayFromArrayList(String[] feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMKeyValuePair pomKVPair = new POMKeyValuePair();
            POMKeyValuePair[] keyValuePairArray = new POMKeyValuePair[]{pomKVPair};
            return keyValuePairArray;
        }
        POMKeyValuePair[] keyValuePairArray = new POMKeyValuePair[feedbackValue.length];
        for (int i = 0; i < feedbackValue.length; ++i) {
            POMKeyValuePair keyValuePair = new POMKeyValuePair();
            String[] keyValuePairToken = feedbackValue[i].split("=");
            keyValuePair.key = keyValuePairToken[0];
            keyValuePair.value = keyValuePairToken[1];
            if (keyValuePair.value.endsWith(";")) {
                keyValuePair.value = keyValuePair.value.substring(0, keyValuePair.value.length() - 1);
            }
            keyValuePairArray[i] = keyValuePair;
        }
        return keyValuePairArray;
    }

    public static POMKeyValuePair[] getPOMKeyValuePairArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMKeyValuePair[] keyValuePairArray = new POMKeyValuePair[1];
            POMKeyValuePair pomJobInfo = new POMKeyValuePair();
            Helper.setEmptyPOMDKeyValuePair(pomJobInfo);
            keyValuePairArray[0] = pomJobInfo;
            return keyValuePairArray;
        }
        String[] pairTokens = pairs.split(";");
        POMKeyValuePair[] keyValuePairArray = new POMKeyValuePair[pairTokens.length];
        for (int i = 0; i < pairTokens.length; ++i) {
            POMKeyValuePair keyValuePair = new POMKeyValuePair();
            String[] keyValuePairToken = pairTokens[i].split("=");
            keyValuePair.key = keyValuePairToken[0];
            keyValuePair.value = keyValuePairToken[1];
            keyValuePairArray[i] = keyValuePair;
        }
        return keyValuePairArray;
    }

    public static POMContactNumber[] getPOMContactNumberArray(String feedbackValue, String result) throws Exception {
        String pairs = feedbackValue;
        int NUM_OF_MEMBERS_IN_CONTACTNUMBER = 6;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMContactNumber[] contactNumberArray = new POMContactNumber[1];
            POMContactNumber pomContactNumber = new POMContactNumber();
            Helper.setEmptyPOMContactNumber(pomContactNumber);
            contactNumberArray[0] = pomContactNumber;
            return contactNumberArray;
        }
        String[] tokens = pairs.split(";", -1);
        POMContactNumber[] contactNumberArray = new POMContactNumber[tokens.length / NUM_OF_MEMBERS_IN_CONTACTNUMBER];
        int cnNum = 0;
        int totallength = tokens.length;
        if (tokens[totallength - 1].equals("")) {
            --totallength;
        }
        int i = 0;
        while (i < totallength) {
            POMContactNumber contactNumber = new POMContactNumber();
            contactNumber.setIsDefault(Boolean.valueOf(tokens[i++]));
            contactNumber.setName(tokens[i++]);
            contactNumber.setNumber(tokens[i++]);
            contactNumber.setTimezone(tokens[i++]);
            contactNumber.setState(tokens[i++]);
            contactNumber.setWireless(tokens[i++]);
            contactNumberArray[cnNum++] = contactNumber;
        }
        return contactNumberArray;
    }

    public POMCompletionCode[] getCompletionCodesArray(String feedbackValue, String result) throws Exception {
        String compCodes = feedbackValue;
        int NUM_OF_MEMBERS_IN_COMPCODES = 2;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            POMCompletionCode[] completionCodesArray = new POMCompletionCode[1];
            POMCompletionCode pomCompletionCode = new POMCompletionCode();
            Helper.setEmptyPOMCompletionCode(pomCompletionCode);
            completionCodesArray[0] = pomCompletionCode;
            return completionCodesArray;
        }
        String[] tokens = compCodes.split(";");
        POMCompletionCode[] completionCodesArray = new POMCompletionCode[tokens.length / NUM_OF_MEMBERS_IN_COMPCODES];
        int ccNum = 0;
        int i = 0;
        while (i < tokens.length - 1) {
            POMCompletionCode completionCode = new POMCompletionCode();
            completionCode.setcodeID(tokens[i++]);
            completionCode.setcodeValue(tokens[i++]);
            completionCodesArray[ccNum++] = completionCode;
        }
        return completionCodesArray;
    }

    public static String[] getAgentNotesFromArray(String[] feedbackParams, String result) throws Exception {
        String[] agentNotesArray = new String[feedbackParams.length];
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            agentNotesArray[0] = "";
            return agentNotesArray;
        }
        for (int i = 0; i < feedbackParams.length; ++i) {
            agentNotesArray[i] = feedbackParams[i];
        }
        return agentNotesArray;
    }

    public static POMAttribute[] getContactAttributes(String[] feedbackParams, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return null;
        }
        POMAttribute[] attributes = new POMAttribute[feedbackParams.length];
        String[] tokens = null;
        int i = 0;
        try {
            String[] stringArray = feedbackParams;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String __dummyForeachVar0;
                String attributeString = __dummyForeachVar0 = stringArray[j];
                POMAttribute attribute = new POMAttribute();
                tokens = attributeString.split("=");
                AgentEventListener.checkAndSetAttribute(attribute, tokens);
                attributes[i++] = attribute;
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception getContactAttributes ", e);
            attributes = null;
        }
        return attributes;
    }

    public static POMCustomerDetails getCustomerDetails(String[] feedbackParams, String result) throws Exception {
        POMCustomerDetails customerDetails = new POMCustomerDetails();
        try {
            int tokenNum = 0;
            String[] tokens = null;
            if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
                Helper.setEmptyPOMCustomerDetails(customerDetails);
            } else {
                POMAttribute id = new POMAttribute();
                tokens = feedbackParams[tokenNum++].split("=");
                AgentEventListener.checkAndSetAttribute(id, tokens);
                customerDetails.setID(id);
                POMAttribute title = new POMAttribute();
                tokens = feedbackParams[tokenNum++].split("=");
                AgentEventListener.checkAndSetAttribute(title, tokens);
                customerDetails.setTitle(title);
                POMAttribute firstName = new POMAttribute();
                tokens = feedbackParams[tokenNum++].split("=");
                AgentEventListener.checkAndSetAttribute(firstName, tokens);
                customerDetails.setFirstname(firstName);
                POMAttribute lastName = new POMAttribute();
                tokens = feedbackParams[tokenNum++].split("=");
                AgentEventListener.checkAndSetAttribute(lastName, tokens);
                customerDetails.setLastname(lastName);
                tokens = feedbackParams[tokenNum++].split(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0]);
                tokens = AgentEventListener.removeEmptyStringFromArray(tokens);
                int phoneNumberFieldsCount = tokens.length / Helper.NUMBER_OF_PHONEADDRESS_ITEMS;
                POMPhone[] phoneFields = new POMPhone[phoneNumberFieldsCount];
                int phoneFieldsCounter = 0;
                String[] internalTokens = null;
                for (int i = 0; i < tokens.length; ++i) {
                    POMPhone pomPhone = new POMPhone();
                    POMAttribute pomPhoneAttribute = new POMAttribute();
                    internalTokens = tokens[i].split("=");
                    AgentEventListener.checkAndSetAttribute(pomPhoneAttribute, internalTokens);
                    pomPhone.setphoneNumber(pomPhoneAttribute);
                    POMAttribute pomCountryAttribute = new POMAttribute();
                    internalTokens = tokens[++i].split("=");
                    AgentEventListener.checkAndSetAttribute(pomCountryAttribute, internalTokens);
                    pomPhone.setcountryCode(pomCountryAttribute);
                    POMAttribute pomTzAttribute = new POMAttribute();
                    internalTokens = tokens[++i].split("=");
                    AgentEventListener.checkAndSetAttribute(pomTzAttribute, internalTokens);
                    pomPhone.settimezone(pomTzAttribute);
                    POMAttribute state = new POMAttribute();
                    internalTokens = tokens[++i].split("=");
                    AgentEventListener.checkAndSetAttribute(state, internalTokens);
                    pomPhone.setState(state);
                    POMAttribute wireless = new POMAttribute();
                    internalTokens = tokens[++i].split("=");
                    AgentEventListener.checkAndSetAttribute(wireless, internalTokens);
                    pomPhone.setWireless(wireless);
                    phoneFields[phoneFieldsCounter] = pomPhone;
                    ++phoneFieldsCounter;
                }
                customerDetails.setPhoneFields(phoneFields);
                tokens = feedbackParams[tokenNum++].split(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0]);
                tokens = AgentEventListener.removeEmptyStringFromArray(tokens);
                int emailFieldsCount = tokens.length;
                POMAttribute[] emailFields = new POMAttribute[emailFieldsCount];
                for (int i = 0; i < emailFieldsCount; ++i) {
                    internalTokens = tokens[i].split("=");
                    POMAttribute emailPair = new POMAttribute();
                    AgentEventListener.checkAndSetAttribute(emailPair, internalTokens);
                    emailFields[i] = emailPair;
                }
                customerDetails.setEmailFields(emailFields);
                tokens = feedbackParams[tokenNum++].split(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0]);
                tokens = AgentEventListener.removeEmptyStringFromArray(tokens);
                int addressListCount = tokens.length / Helper.NUMBER_OF_POMADDRESS_MEMBERS;
                POMAddress[] addressList = new POMAddress[addressListCount];
                int i = 0;
                while (i < addressListCount * Helper.NUMBER_OF_POMADDRESS_MEMBERS) {
                    int itemNumber = 0;
                    POMAddress address = new POMAddress();
                    POMAttribute line1 = new POMAttribute();
                    POMAttribute line2 = new POMAttribute();
                    POMAttribute line3 = new POMAttribute();
                    POMAttribute line4 = new POMAttribute();
                    POMAttribute line5 = new POMAttribute();
                    POMAttribute country = new POMAttribute();
                    POMAttribute zipCode = new POMAttribute();
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(line1, internalTokens);
                    address.setLine1(line1);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(line2, internalTokens);
                    address.setLine2(line2);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(line3, internalTokens);
                    address.setLine3(line3);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(line4, internalTokens);
                    address.setLine4(line4);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(line5, internalTokens);
                    address.setLine5(line5);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(country, internalTokens);
                    address.setCountry(country);
                    internalTokens = tokens[i++].split("=");
                    AgentEventListener.checkAndSetAttribute(zipCode, internalTokens);
                    address.setZipCode(zipCode);
                    addressList[itemNumber++] = address;
                }
                customerDetails.setAddressList(addressList);
                POMAttribute[] customFields = null;
                if (feedbackParams.length > tokenNum) {
                    tokens = feedbackParams[tokenNum++].split(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0]);
                    tokens = AgentEventListener.removeEmptyStringFromArray(tokens);
                    int customFieldsCount = tokens.length;
                    customFields = new POMAttribute[customFieldsCount];
                    for (int i2 = 0; i2 < customFieldsCount; ++i2) {
                        internalTokens = tokens[i2].split("=");
                        POMAttribute customFieldsPair = new POMAttribute();
                        AgentEventListener.checkAndSetAttribute(customFieldsPair, internalTokens);
                        customFields[i2] = customFieldsPair;
                    }
                } else {
                    customFields = new POMAttribute[1];
                    POMAttribute customFieldsAttribute = new POMAttribute();
                    customFieldsAttribute.key = "";
                    customFieldsAttribute.value = "";
                    customFieldsAttribute.attributeType = POMAttributeType.READ_ONLY;
                    customFields[0] = customFieldsAttribute;
                }
                customerDetails.setCustomFields(customFields);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception getCustomerDetails ", e);
            Helper.setEmptyPOMCustomerDetails(customerDetails);
        }
        return customerDetails;
    }

    private String getSessionID(String sessionIDString) throws Exception {
        String sessionID = "";
        if (sessionIDString == null) {
            InitPOMAgentFactory.getTracer().fine("AgentEventListener::getSessionID() sessionIDString = null. Setting it to blank.");
            sessionIDString = "";
        }
        if (!sessionIDString.equals("")) {
            sessionID = sessionIDString;
            String[] sessionIDTokens = sessionID.split("=");
            sessionID = sessionIDTokens[1];
            InitPOMAgentFactory.getTracer().finest("getSessionID sessionID = " + sessionID);
        }
        return sessionID;
    }

    public POMContact getPOMContact(String[] feedbackParams, String result) throws Exception {
        POMContact contact = new POMContact();
        int tokenNum = 0;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            Helper.setEmptyPOMContact(contact);
        } else {
            contact.setContactType(AgentEventListener.getPOMContactType(feedbackParams[tokenNum++], result));
            contact.setCanCancel(Boolean.valueOf(feedbackParams[tokenNum++]));
            contact.setTimed(Boolean.valueOf(feedbackParams[tokenNum++]));
            contact.setTimeout(Long.valueOf(feedbackParams[tokenNum++]));
            contact.setScriptURL(feedbackParams[tokenNum++]);
            contact.setScriptFailoverURL(feedbackParams[tokenNum++]);
            contact.setContactNumbers(AgentEventListener.getPOMContactNumberArray(feedbackParams[tokenNum++], result));
            contact.setDefaultNumber(feedbackParams[tokenNum++]);
            contact.setCampaignName(feedbackParams[tokenNum++]);
            contact.setSkillsetName(feedbackParams[tokenNum++]);
            contact.setCanEnterFreeFormNumber(Boolean.valueOf(feedbackParams[tokenNum++]));
            contact.setCanDial(Boolean.valueOf(feedbackParams[tokenNum++]));
            contact.setCanReschedule(Boolean.valueOf(feedbackParams[tokenNum++]));
            contact.setExpiryTime(feedbackParams[tokenNum++]);
            contact.setContactID(Long.valueOf(feedbackParams[tokenNum++]));
            contact.setSkillsetID(feedbackParams[tokenNum++]);
            contact.setCallbackNotes(feedbackParams[tokenNum++]);
        }
        return contact;
    }

    private HashMap<String, PAMSocketInfo> getZonePAMMapping(String[] feedbackValue) throws Exception {
        HashMap<String, PAMSocketInfo> zonePAMMap = new HashMap<String, PAMSocketInfo>();
        Helper.setZonePAMMapUsingFeedbackValue(zonePAMMap, feedbackValue);
        return zonePAMMap;
    }

    public boolean getBooleanValueFromFeedback(String feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return true;
        }
        return Boolean.valueOf(feedbackValue);
    }

    public POMDialFailReason getPOMDialFailReasonFromFeedback(String feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return POMDialFailReason.Unknown;
        }
        return POMDialFailReason.valueOf(feedbackValue);
    }

    public POMAgentState getPOMAgentStateFromFeedback(String feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return POMAgentState.Ready;
        }
        return POMAgentState.valueOf(feedbackValue);
    }

    public static POMCallState getPOMCallStateFromFeedback(String feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return POMCallState.Idle;
        }
        return POMCallState.valueOf(feedbackValue);
    }

    public POMDestination getPOMDestinationFromFeedback(String feedbackValue, String result) throws Exception {
        POMDestination pomDestination = new POMDestination();
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            Helper.setEmptyPOMDestination(pomDestination);
        } else {
            Helper.setPOMDestinationUsingString(pomDestination, feedbackValue);
        }
        return pomDestination;
    }

    public long getLongValueFromFeedback(String feedbackValue, String result) throws Exception {
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            return Long.valueOf(SUCCESS_RESULT);
        }
        return Long.valueOf(feedbackValue);
    }

    private static void checkAndSetKeyValuePair(POMKeyValuePair pair, String[] tokens) throws Exception {
        pair.key = tokens.length > 0 ? tokens[0] : "";
        pair.value = tokens.length > 1 ? tokens[1] : "";
    }

    private static void checkAndSetAttribute(POMAttribute attribute, String[] tokens) throws Exception {
        attribute.key = tokens.length > 0 ? tokens[0] : "";
        if (tokens.length >= 1) {
            int attTokenStart;
            StringBuffer combinedString = new StringBuffer(tokens[1]);
            if (tokens.length > 1) {
                for (int i = 2; i < tokens.length; ++i) {
                    combinedString.append("=");
                    combinedString.append(tokens[i]);
                }
            }
            if ((attTokenStart = combinedString.indexOf(";AT")) != -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(";AT");
                sb.append("=");
                String strtokens = sb.toString();
                String[] moreTokens = combinedString.toString().split(strtokens);
                attribute.value = moreTokens[0];
                try {
                    attribute.attributeType = POMAttributeType.valueOf(moreTokens[1]);
                }
                catch (Exception ex) {
                    attribute.attributeType = POMAttributeType.READ_ONLY;
                }
            } else {
                attribute.value = tokens[1];
            }
        } else {
            attribute.value = "";
            attribute.attributeType = POMAttributeType.READ_ONLY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private POMZoneInfo[] getPOMZoneInfoArray(String[] feedbackParams) throws Exception {
        POMZoneInfo[] pomZoneInfoArray = null;
        pomZoneInfoArray = feedbackParams.length > 0 ? new POMZoneInfo[feedbackParams.length] : null;
        for (int i = 0; i < feedbackParams.length; ++i) {
            POMZoneInfo pzi = new POMZoneInfo();
            try {
                String[] zoneInfoTokens = feedbackParams[i].split(";");
                pzi.setzoneName(zoneInfoTokens[0]);
                pzi.setzoneIP(zoneInfoTokens[1]);
                pzi.setzonePort(zoneInfoTokens[2]);
                continue;
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception getPOMZoneInfoArray", e);
                continue;
            }
            finally {
                if (pomZoneInfoArray != null) {
                    pomZoneInfoArray[i] = pzi;
                }
            }
        }
        return pomZoneInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private POMOrganizationInfo[] getPOMOrganizationInfoArray(String[] feedbackParams) throws Exception {
        POMOrganizationInfo[] pomOrganizationInfoArray = null;
        if (feedbackParams.length > 0) {
            pomOrganizationInfoArray = new POMOrganizationInfo[feedbackParams.length];
            InitPOMAgentFactory.getTracer().fine(Arrays.toString(feedbackParams));
        } else {
            pomOrganizationInfoArray = null;
        }
        for (int i = 0; i < feedbackParams.length; ++i) {
            POMOrganizationInfo pzi = new POMOrganizationInfo();
            try {
                Object[] pomOrgInfoTokens = feedbackParams[i].split(";");
                if (pomOrgInfoTokens == null) continue;
                InitPOMAgentFactory.getTracer().fine(Arrays.toString(pomOrgInfoTokens));
                pzi.setOrganizationNameField((String)pomOrgInfoTokens[0]);
                pzi.setOrganizationId(Integer.parseInt((String)pomOrgInfoTokens[1]));
                if (pomOrgInfoTokens.length <= 2) continue;
                Object[] pomOrgZoneTocken = ((String)pomOrgInfoTokens[2]).split(Pattern.quote("|"));
                InitPOMAgentFactory.getTracer().fine(Arrays.toString(pomOrgZoneTocken));
                String[] pomZoneOrgInfo = new String[pomOrgZoneTocken.length];
                for (int j = 0; j < pomOrgZoneTocken.length; ++j) {
                    pomZoneOrgInfo[j] = pomOrgZoneTocken[j];
                }
                pzi.setPomZoneNameField(pomZoneOrgInfo);
                continue;
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception getPOMZoneInfoArray", e);
                continue;
            }
            finally {
                if (pomOrganizationInfoArray != null) {
                    pomOrganizationInfoArray[i] = pzi;
                }
            }
        }
        return pomOrganizationInfoArray;
    }

    private POMErrorInfo getErrorInfo(String errorInfoString, String result) throws Exception {
        POMErrorInfo errorInfo = new POMErrorInfo();
        String[] errorInfoArray = errorInfoString.split(SocketUtil.COMPLEX_MEMBER_ITEMS_SEPERATOR[0], Helper.NUMBER_OF_ERRORINFO_ITEMS);
        int tokenNum = 0;
        if (!result.equalsIgnoreCase(SUCCESS_RESULT)) {
            Helper.setEmptyErrorInfo(errorInfo);
        } else {
            errorInfo.seterrorCode(errorInfoArray[tokenNum++]);
            String error = errorInfoArray[tokenNum++].toString();
            errorInfo.seterrorType(POMErrorType.valueOf(error));
            errorInfo.seterrorString(errorInfoArray[tokenNum++]);
            errorInfo.setlocalizedString(errorInfoArray[tokenNum++]);
            errorInfo.setapiName(errorInfoArray[tokenNum++]);
        }
        return errorInfo;
    }

    private void executeAgentTasksInSequence(String agentId, AgentFeedbackExecutor agentFeedbackExecutor) throws Exception {
        InitPOMAgentFactory.getTracer().finest(" In executeAgentTasksInSequence. ");
        InitPOMAgentFactory.checkOrCreateLockForAgent(agentId);
        this.threadExecutor.execute(agentFeedbackExecutor);
    }

    private static String[] removeEmptyStringFromArray(String[] tokens) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String str : tokens) {
            if (str == null || str.isEmpty()) continue;
            temp.add(str);
        }
        String[] arr = new String[temp.size()];
        tokens = temp.toArray(arr);
        return tokens;
    }

    public POMContextStoreData getContextStoreData(String feedbackValue, String result) throws Exception {
        POMContextStoreData pomContextData = new POMContextStoreData();
        try {
            String[] tokens;
            if (result.equalsIgnoreCase(SUCCESS_RESULT) && (tokens = feedbackValue.split(";")).length > 1) {
                pomContextData.setGroupIdField(tokens[0]);
                pomContextData.setContextStoreIdField(tokens[1]);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception getPOMWrapupDetails ", e);
        }
        return pomContextData;
    }
}

