/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Internal;

import com.avaya.sdk.Agent.POMAgent;
import com.avaya.sdk.Agent.POMAgentHandlerInterface;
import com.avaya.sdk.Agent.SDKReturnCodes;
import com.avaya.sdk.ILogger;
import com.avaya.sdk.Internal.AgentAPIList;
import com.avaya.sdk.Internal.AgentCommand;
import com.avaya.sdk.Internal.AgentEventListener;
import com.avaya.sdk.Internal.InternalPOMAgentHandler;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Internal.MessageHeader;
import com.avaya.sdk.Internal.MessageTypeList;
import com.avaya.sdk.PAMSocketInfo;
import com.avaya.sdk.POMServer;
import com.avaya.sdk.Socket.SocketClient;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;

public class InitPOMAgentFactory {
    private static SocketClient sockClient = null;
    private static AgentEventListener agtEventListener = null;
    private static HashMap<String, POMAgentHandlerInterface> agentMap = null;
    private static HashMap<POMAgent, SocketClient> agentSocketMap = null;
    private static HashMap<String, SocketClient> zoneSocketMap = null;
    private static HashMap<String, PAMSocketInfo> zoneIPMap = null;
    private static Object lockForZoneIPMap = new Object();
    private static HashMap<PAMSocketInfo, SocketClient> libUserAddressMap = null;
    private static POMAgent internalCmdAgent = null;
    private static InternalPOMAgentHandler internalAgentHandler = null;
    public static String INTERNAL_CMD_AGENTID = "-1";
    public static ILogger tracer;
    public static String DESKTOP_API_INTERNAL_ZONE_NAME;
    private static POMServer pomServer;
    private static Object objTryConnectingToPOMLock;
    private static ArrayBlockingQueue<String> mgmtQueue;
    private static Thread keepSocketAliveThread;
    private static Thread tryConnectingToPOMThread;
    private static boolean checkMaps;
    private static HashMap<String, ReentrantLock> agentTaskMap;
    private static SSLContext sslContex;
    private static String myAddress;
    public static Boolean sentPAMForZone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Boolean init(PAMSocketInfo[] pamAddress) throws Exception {
        tracer.fine("POMAgentFactory::init() - Starting ...");
        Class<InitPOMAgentFactory> clazz = InitPOMAgentFactory.class;
        // MONITORENTER : com.avaya.sdk.Internal.InitPOMAgentFactory.class
        if (zoneSocketMap != null) {
            tracer.fine("POMAgentFactory::init() ALREADY DONE.");
            // MONITOREXIT : clazz
            return true;
        }
        zoneSocketMap = new HashMap();
        agentMap = new HashMap();
        agentTaskMap = new HashMap();
        agentSocketMap = new HashMap();
        zoneIPMap = new HashMap();
        libUserAddressMap = new HashMap();
        mgmtQueue = new ArrayBlockingQueue(2);
        tracer.fine("POMAgentFactory::init() - Printing libUserAddress Map :");
        for (int i = 0; i < pamAddress.length; ++i) {
            libUserAddressMap.put(pamAddress[i], null);
            tracer.fine("POMAgentFactory::init() - libUserAddressMap[" + i + "] " + "IPAddress.ATTR=" + pamAddress[i].ipAddress + ":" + pamAddress[i].port);
        }
        SocketClient sockClient = InitPOMAgentFactory.tryConnectingToPOM();
        if (sockClient == null) {
            tracer.fine("POMAgentFactory::init() - No PAM's could be connected.");
            libUserAddressMap.clear();
            libUserAddressMap = null;
            // MONITOREXIT : clazz
            return false;
        }
        internalCmdAgent = InitPOMAgentFactory.getExistingPOMAgent(INTERNAL_CMD_AGENTID);
        Class<InitPOMAgentFactory> clazz2 = InitPOMAgentFactory.class;
        // MONITORENTER : com.avaya.sdk.Internal.InitPOMAgentFactory.class
        if (internalCmdAgent == null) {
            internalAgentHandler = new InternalPOMAgentHandler();
            internalCmdAgent = InitPOMAgentFactory.getPOMAgent(INTERNAL_CMD_AGENTID, internalAgentHandler);
        }
        // MONITOREXIT : clazz2
        internalCmdAgent.setSocketClient(sockClient);
        InitPOMAgentFactory.setInternalCommunicationAgent(internalCmdAgent);
        agtEventListener = new AgentEventListener(sockClient);
        agtEventListener.runThread();
        clazz2 = InitPOMAgentFactory.class;
        // MONITORENTER : com.avaya.sdk.Internal.InitPOMAgentFactory.class
        if (keepSocketAliveThread == null) {
            keepSocketAliveThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SocketClient sc = null;
                    Thread.currentThread().setName("KeepSocketAliveThread" + Thread.currentThread().getId());
                    tracer.finest("POMAgentFactory::KeepClientSocketAliveThread() - Started ...");
                    while (checkMaps) {
                        try {
                            AgentCommand pomClientAlive;
                            HashMap hashMap;
                            Thread.sleep(30000L);
                            if (zoneSocketMap != null) {
                                hashMap = zoneSocketMap;
                                synchronized (hashMap) {
                                    for (Map.Entry __dummyForeachVar14 : zoneSocketMap.entrySet()) {
                                        if (__dummyForeachVar14.getKey() == null || __dummyForeachVar14.getValue() == null || !(sc = (SocketClient)__dummyForeachVar14.getValue()).isConnected().booleanValue()) continue;
                                        pomClientAlive = new AgentCommand(AgentAPIList.POMClientAlive, "-1" + (String)__dummyForeachVar14.getKey(), "");
                                        sc.send(pomClientAlive);
                                    }
                                }
                            }
                            if (libUserAddressMap == null) continue;
                            hashMap = libUserAddressMap;
                            synchronized (hashMap) {
                                for (Map.Entry __dummyForeachVar15 : libUserAddressMap.entrySet()) {
                                    if (__dummyForeachVar15.getValue() == null || (sc = (SocketClient)__dummyForeachVar15.getValue()) == null || !sc.isConnected().booleanValue()) continue;
                                    pomClientAlive = new AgentCommand(AgentAPIList.POMClientAlive, "-1", "");
                                    sc.send(pomClientAlive);
                                }
                            }
                        }
                        catch (Exception e) {
                            tracer.error("POMAgentFactory::KeepClientSocketAliveThread() - Exception - ", e);
                        }
                    }
                    tracer.fine("POMAgentFactory::KeepClientSocketAliveThread() - Ending ...");
                }
            };
            keepSocketAliveThread.start();
        }
        // MONITOREXIT : clazz2
        clazz2 = InitPOMAgentFactory.class;
        // MONITORENTER : com.avaya.sdk.Internal.InitPOMAgentFactory.class
        if (tryConnectingToPOMThread == null) {
            tryConnectingToPOMThread = new Thread(){

                @Override
                public void run() {
                    Thread.currentThread().setName("TryConnectingToPOMThread" + Thread.currentThread().getId());
                    tracer.fine("POMAgentFactory::TryConnectingToPOMThread() TryConnectingToPOMThread starting ....");
                    Boolean exitThread = false;
                    try {
                        while (!exitThread.booleanValue()) {
                            if (mgmtQueue != null && mgmtQueue.size() > 0) {
                                tracer.fine("POMAgentFactory::TryConnectingToPOMThread() mgmtQueue.Count = " + mgmtQueue.size());
                                tracer.fine("POMAgentFactory::TryConnectingToPOMThread() Found item in mgmtQueue");
                                String item = (String)mgmtQueue.take();
                                if (item.compareTo("search") == 0) {
                                    tracer.fine("POMAgentFactory::TryConnectingToPOMThread() search item in mgmtQueue");
                                    InitPOMAgentFactory.tryConnectingToPOM();
                                } else {
                                    tracer.fine("POMAgentFactory::TryConnectingToPOMThread() stop item in mgmtQueue");
                                    exitThread = true;
                                }
                            } else if (mgmtQueue == null) {
                                exitThread = true;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception ex) {
                        InitPOMAgentFactory.getTracer().error("Exception POMAgentFactory::TryConnectingToPOMThread", ex);
                    }
                    tracer.fine("POMAgentFactory::TryConnectingToPOMThread() TryConnectingToPOMThread ending ....");
                }
            };
            tryConnectingToPOMThread.start();
        }
        // MONITOREXIT : clazz2
        tracer.fine("POMAgentFactory::init() DONE");
        return true;
    }

    public static Boolean init(PAMSocketInfo[] pamAddress, ILogger logger, SSLContext sslContex) throws Exception {
        if (logger == null) {
            System.out.println("logger object is null ");
            return false;
        }
        if (sslContex == null) {
            System.out.println("sslContex object is null ");
            return false;
        }
        tracer = logger;
        InitPOMAgentFactory.sslContex = sslContex;
        return InitPOMAgentFactory.init(pamAddress);
    }

    public static Boolean init(PAMSocketInfo[] pamAddress, ILogger logger, SSLContext sslContex, String myAddress) throws Exception {
        if (logger == null) {
            System.out.println("logger object is null ");
            return false;
        }
        if (sslContex == null) {
            System.out.println("sslContex object is null ");
            return false;
        }
        InitPOMAgentFactory.myAddress = myAddress;
        InitPOMAgentFactory.sslContex = sslContex;
        tracer = logger;
        return InitPOMAgentFactory.init(pamAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean deinit() throws Exception {
        Class<InitPOMAgentFactory> clazz;
        tracer.fine("POMAgentFactory::deinit() Starting");
        tracer.fine("POMAgentFactory::deinit() Killing TryConnectingToPOM thread first.");
        InitPOMAgentFactory.stopMgmtQueue();
        tracer.fine("POMAgentFactory::deinit() First killing socket related threads.");
        SocketClient sc = null;
        try {
            clazz = InitPOMAgentFactory.class;
            synchronized (InitPOMAgentFactory.class) {
                if (libUserAddressMap != null) {
                    for (Map.Entry<PAMSocketInfo, SocketClient> entry : libUserAddressMap.entrySet()) {
                        if (entry.getValue() == null || (sc = entry.getValue()) == null) continue;
                        sc.stopSocketClient();
                    }
                }
                // ** MonitorExit[clazz] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            tracer.error("POMAgentFactory::deinit() Exception while stopping libUserAddressMap socketclient.", e);
        }
        {
            try {
                Class<InitPOMAgentFactory> e = InitPOMAgentFactory.class;
                synchronized (InitPOMAgentFactory.class) {
                    if (zoneSocketMap != null) {
                        for (Map.Entry<Object, SocketClient> entry : zoneSocketMap.entrySet()) {
                            if (entry.getValue() == null || entry.getValue() == null || (sc = entry.getValue()) == null) continue;
                            sc.stopSocketClient();
                        }
                    }
                    // ** MonitorExit[e] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                tracer.error("POMAgentFactory::deinit() Exception while stopping zoneSocketMap socketclient.", e);
            }
            {
                tracer.fine("POMAgentFactory::deinit() Now killing AgentEventListener.");
                if (agtEventListener != null) {
                    agtEventListener.stopAgentEventListener();
                }
                if (keepSocketAliveThread != null) {
                    checkMaps = false;
                }
                agentMap = null;
                agentSocketMap = null;
                clazz = lockForZoneIPMap;
                synchronized (clazz) {
                    zoneIPMap = null;
                }
                internalCmdAgent = null;
                agtEventListener = null;
                keepSocketAliveThread = null;
                pomServer = null;
                mgmtQueue = null;
                clazz = InitPOMAgentFactory.class;
                synchronized (InitPOMAgentFactory.class) {
                    tryConnectingToPOMThread = null;
                    internalAgentHandler = null;
                    zoneSocketMap = null;
                    libUserAddressMap = null;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    agentTaskMap = null;
                    sslContex = null;
                    myAddress = null;
                    return true;
                }
            }
        }
    }

    private static SocketClient tryConnectingToPOM() throws Exception {
        SocketClient sc = null;
        for (Map.Entry<PAMSocketInfo, SocketClient> __dummyForeachVar2 : libUserAddressMap.entrySet()) {
            PAMSocketInfo pa = __dummyForeachVar2.getKey();
            sc = new SocketClient(pa.ipAddress, pa.port, "Default", true);
            tracer.fine("POMAgentFactory::tryConnectingToPOM() HARDCODING - sending Default as the hard coded value for zone name. Invoking connectToServer");
            if (sc.connectToServer(true, INTERNAL_CMD_AGENTID).booleanValue()) {
                try {
                    libUserAddressMap.put(pa, sc);
                }
                catch (Exception e) {
                    tracer.error("POMAgentFactory::tryConnectingToPOM() Exception .... unable to add sc to libUserAddressMap", e);
                }
                break;
            }
            sc.stopSocketClient();
            sc = null;
        }
        return sc;
    }

    public static void findNewPAMForZone(String zoneName) throws Exception {
        String isConnected = InitPOMAgentFactory.getPAMForZone(zoneName);
        tracer.fine("POMAgentFactory::findNewPAMForZone() isConnected = " + isConnected);
        if (isConnected.compareTo("0") == 0) {
            tracer.finest("POMAgentFactory::findNewPAMForZone() Mgmt socket is connected.");
        } else {
            tracer.finest("POMAgentFactory::findNewPAMForZone() Mgmt socket is down, so invoking TryConnectingToPOM");
            InitPOMAgentFactory.addToMgmtQueue();
        }
    }

    private static String getPAMForZone(String zoneName) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMServer::GetPAMForZone()");
        sockClient = InitPOMAgentFactory.getMgmtSocketClient();
        if (sockClient == null) {
            InitPOMAgentFactory.getTracer().finest("POMServer::GetPAMForZone() sockClient == null");
            return SDKReturnCodes.PAM_NOT_AVAILABLE_FOR_ZONE.name();
        }
        if (!sockClient.isConnected().booleanValue()) {
            InitPOMAgentFactory.getTracer().fine("POMServer::GetPAMForZone() sockClient.IsConnected == false");
            return SDKReturnCodes.PAM_NOT_AVAILABLE_FOR_ZONE.name();
        }
        InitPOMAgentFactory.getTracer().finest("POMServer::GetPAMForZone() sockClient details are IPAddress.ATTR=" + InitPOMAgentFactory.sockClient.pamAddress.ipAddress + ":" + InitPOMAgentFactory.sockClient.pamAddress.port);
        AgentCommand getPAMForZone = new AgentCommand(AgentAPIList.GetPAMForZone, INTERNAL_CMD_AGENTID, zoneName);
        try {
            sockClient.send(getPAMForZone);
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Stack Trace : ", ex);
            throw ex;
        }
        return "0";
    }

    private static POMAgent getInternalCmdAgent() throws Exception {
        return internalCmdAgent;
    }

    private static void setInternalCommunicationAgent(POMAgent pomAgt) throws Exception {
        internalCmdAgent = pomAgt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void sendSDKStartedCmdToPAM(SocketClient sc, String agentID) throws Exception {
        Set<String> agentList = InitPOMAgentFactory.getListOfCurrentlyManagedAgents();
        StringBuffer agentListString = new StringBuffer();
        tracer.fine("POMAgentFactory::sendSDKStartedCmdToPAM()");
        if (agentList == null) return;
        for (String agt : agentList) {
            agentListString.append(";");
            agentListString.append(agt);
        }
        try {
            tracer.finest("POMAgentFactory::sendSDKStartedCmdToPAM() agentListString = " + agentListString.toString());
            POMAgent agent = InitPOMAgentFactory.getExistingPOMAgent(agentID);
            if (agent == null) {
                Class<InitPOMAgentFactory> clazz = InitPOMAgentFactory.class;
                // MONITORENTER : com.avaya.sdk.Internal.InitPOMAgentFactory.class
                if (internalAgentHandler == null) {
                    tracer.finest("POMAgentFactory::sendSDKStartedCmdToPAM() created new InternalAgentHandler");
                    internalAgentHandler = new InternalPOMAgentHandler();
                }
                agent = InitPOMAgentFactory.getPOMAgent(agentID, internalAgentHandler);
                // MONITOREXIT : clazz
            }
            if (sc == null) {
                for (Map.Entry entry : libUserAddressMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    sc = (SocketClient)entry.getValue();
                    HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
                    // MONITORENTER : hashMap
                    agentSocketMap.put(agent, sc);
                    // MONITOREXIT : hashMap
                    break;
                }
            }
            if (sc == null) {
                tracer.fine("POMAgentFactory::sendSDKStartedCmdToPAM() sc is still null for " + agent.getAgentID());
            }
            agent.AgentSDKConnected(sc, agentListString.toString());
            return;
        }
        catch (Exception ex) {
            tracer.error("Stack trace : ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendPOMAvailableNotificationToPOMProxy(SocketClient sc, int packID, String agtID) throws Exception {
        block6: {
            try {
                tracer.fine("POMAgentFactory::sendPOMAvailableNotificationToPOMProxy() for " + agtID);
                if (!zoneSocketMap.containsValue(sc) || agentSocketMap == null) break block6;
                HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
                synchronized (hashMap) {
                    for (POMAgent agent : agentSocketMap.keySet()) {
                        if (agent.getSocketClient() == null || !agent.getAgentID().equals(agtID)) continue;
                        Message pomAvailable = new Message(AgentAPIList.POMAvailable, MessageTypeList.N, agent.getAgentID());
                        pomAvailable.setParameterCount(0);
                        String[] cmdParamsList = new String[10];
                        pomAvailable.setCommandParams(cmdParamsList);
                        MessageHeader msgHeader = new MessageHeader(AgentAPIList.POMAvailable, MessageTypeList.N, agent.getAgentID(), packID);
                        pomAvailable.setCommandHeader(msgHeader);
                        pomAvailable.setResult(SDKReturnCodes.SUCCESS.name());
                        agtEventListener.processInternalEvent(pomAvailable);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                tracer.error("Stack Trace : ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendPOMNotAvailableNotificationToPOMProxy(SocketClient sc) throws Exception {
        block8: {
            try {
                tracer.fine("POMAgentFactory::sendPOMNotAvailableNotificationToPOMProxy()");
                if (!zoneSocketMap.containsValue(sc) || agentSocketMap == null) break block8;
                HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
                synchronized (hashMap) {
                    for (POMAgent agent : agentSocketMap.keySet()) {
                        tracer.finest("agent.getSocketClient() " + agent.getSocketClient());
                        tracer.finest("agent " + agent.getAgentID());
                        try {
                            if (agent.getSocketClient() == null || !agent.getSocketClient().equals(sc)) continue;
                            String[] cmdParamsList = new String[10];
                            Message pomNotAvailable = new Message(AgentAPIList.POMNotAvailable, MessageTypeList.N, agent.getAgentID());
                            pomNotAvailable.setParameterCount(0);
                            pomNotAvailable.setCommandParams(cmdParamsList);
                            MessageHeader msgHeader = new MessageHeader(AgentAPIList.POMNotAvailable, MessageTypeList.N, agent.getAgentID());
                            pomNotAvailable.setCommandHeader(msgHeader);
                            pomNotAvailable.setResult(SDKReturnCodes.POM_NOT_AVAILABLE.name());
                            tracer.finest("POMAgentFactory::sendPOMNotAvailableNotificationToPOMProxy() agent Id " + agent.getAgentID());
                            agtEventListener.processInternalEvent(pomNotAvailable);
                        }
                        catch (Exception ex) {
                            tracer.finest("POMAgentFactory::sendPOMNotAvailableNotificationToPOMProxy() : handled the exception " + ex.getMessage());
                        }
                    }
                }
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception POMAgentFactory sendPOMNotAvailableNotificationToPOMProxy", ex);
            }
        }
    }

    public static void sendErrorCommandResponseToPOMProxy(SocketClient sc, Message errorResponse) throws Exception {
        try {
            tracer.finest("POMAgentFactory::sendErrorCommandResponseToPOMProxy()");
            AgentEventListener.addPacketToQueue(errorResponse);
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception POMAgentFactory sendErrorCommandResponseToPOMProxy", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAgentSocketMap(POMAgent agent, SocketClient sc) throws Exception {
        try {
            HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
            synchronized (hashMap) {
                agentSocketMap.put(agent, sc);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception POMAgentFactory updateAgentSocketMap", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketClient getSocketClientForZone(String zoneName, Boolean exitIfCannotConnectFlag) throws Exception {
        SocketClient sc;
        block18: {
            tracer.finest("POMAgentFactory::getSocketClientForZone() for zone  : " + zoneName + " exitIfCannotConnectFlag = " + exitIfCannotConnectFlag);
            sc = null;
            PAMSocketInfo pa = new PAMSocketInfo();
            boolean isZonePresentInZoneIpMap = false;
            try {
                sc = zoneSocketMap.get(zoneName);
                if (sc != null) break block18;
                tracer.finest("POMAgentFactory::getSocketClientForZone() zoneSocketMap does not contain : " + zoneName);
                Object object = lockForZoneIPMap;
                synchronized (object) {
                    if (zoneIPMap.containsKey(zoneName)) {
                        isZonePresentInZoneIpMap = true;
                        tracer.finest("POMAgentFactory::getSocketClientForZone() zoneIPMap contains : " + zoneName);
                        for (Map.Entry<String, PAMSocketInfo> __dummyForeachVar6 : zoneIPMap.entrySet()) {
                            if (__dummyForeachVar6.getKey().compareTo(zoneName) != 0) continue;
                            pa = __dummyForeachVar6.getValue();
                        }
                    }
                }
                if (!isZonePresentInZoneIpMap) {
                    if (!sentPAMForZone.booleanValue()) {
                        tracer.finest("POMAgentFactory::getSocketClientForZone() zoneIPMap does not contain : " + zoneName);
                        SocketClient s = InitPOMAgentFactory.getMgmtSocketClient();
                        if (s != null && s.isConnected().booleanValue()) {
                            internalCmdAgent.GetPAMForZone(zoneName);
                        } else {
                            tracer.finest("POMAgentFactory::getSocketClientForZone() Adding to search management socket");
                            InitPOMAgentFactory.addToMgmtQueue();
                        }
                    }
                    return null;
                }
                if (sc != null) break block18;
                sc = new SocketClient(pa.ipAddress, pa.port, zoneName, exitIfCannotConnectFlag);
                try {
                    InitPOMAgentFactory.addToZoneSocketMap(zoneName, sc);
                }
                catch (Exception e) {
                    InitPOMAgentFactory.getTracer().error("Exception getSocketClientForZone ", e);
                    InitPOMAgentFactory.removeFromZoneSocketMap(sc, zoneName);
                }
                tracer.finest("POMAgentFactory::getSocketClientForZone() Adding zoneName to sc map even without connecting. Is this right ?? for " + zoneName);
                tracer.finest("POMAgentFactory::getSocketClientForZone() Invoking connectToServer");
                sc.setRetry(false);
                if (sc.connectToServer(true, INTERNAL_CMD_AGENTID + zoneName).booleanValue()) {
                    tracer.finest("POMAgentFactory::getSocketClientForZone() Trying to kill any management socket connection.");
                    if (internalCmdAgent.getSocketClient() != null) {
                        tracer.finest("POMAgentFactory::getSocketClientForZone() NOT shutting down socket connection for -1");
                    }
                } else {
                    InitPOMAgentFactory.removeFromZoneSocketMap(sc, zoneName);
                    tracer.finest("POMAgentFactory::getSocketClientForZone() Stopping socket client");
                    sc.stopSocketClient();
                    sc = null;
                }
                if (sc != null) {
                    sc.setRetry(true);
                }
            }
            catch (Exception ex) {
                if (sc != null) {
                    sc.setRetry(true);
                }
                sc = null;
                InitPOMAgentFactory.getTracer().error("Exception getSocketClientForZone", ex);
            }
        }
        tracer.finest("getSocketClientForAgent() - sc = " + sc);
        return sc;
    }

    public static SocketClient getMgmtSocketClient() throws Exception {
        tracer.finest("POMAgentFactory::GetMgmtSocketClient()");
        SocketClient sockClient = null;
        try {
            for (Map.Entry<PAMSocketInfo, SocketClient> __dummyForeachVar7 : libUserAddressMap.entrySet()) {
                SocketClient sc = __dummyForeachVar7.getValue();
                if (sc == null) continue;
                sockClient = sc;
                break;
            }
        }
        catch (Exception ex) {
            tracer.finest("Errors in GetMgmtSocketClient");
        }
        return sockClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToZoneSocketMap(String zoneName, SocketClient sc) throws Exception {
        HashMap<String, SocketClient> hashMap = zoneSocketMap;
        synchronized (hashMap) {
            tracer.fine("POMAgentFactory::AddToZoneSocketMap() - Adding zone - " + zoneName);
            try {
                zoneSocketMap.put(zoneName, sc);
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception addToZoneSocketMap", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketClient getSocketClientForZoneName(String zoneName) throws Exception {
        tracer.finest("POMAgentFactory::GetSocketClientForZoneName() - " + zoneName);
        SocketClient zoneSocketClient = null;
        HashMap<String, SocketClient> hashMap = zoneSocketMap;
        synchronized (hashMap) {
            if (zoneSocketMap.containsKey(zoneName)) {
                zoneSocketClient = zoneSocketMap.get(zoneName);
                tracer.finest("POMAgentFactory::GetSocketClientForZoneName() - Found socketClient.");
            }
        }
        return zoneSocketClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromZoneSocketMap(SocketClient socketClient, String zoneName) throws Exception {
        HashMap<String, SocketClient> hashMap = zoneSocketMap;
        synchronized (hashMap) {
            tracer.fine("POMAgentFactory::RemoveFromZoneSocketMap() - zone - " + zoneName);
            try {
                if (zoneSocketMap.containsValue(socketClient)) {
                    tracer.fine("POMAgentFactory::RemoveFromZoneSocketMap() - contains SocketClient IPAddress.ATTR=" + socketClient.pamAddress.ipAddress + ":" + socketClient.pamAddress.port + " in the map - " + zoneName);
                    if (zoneSocketMap.remove(zoneName) == null) {
                        tracer.fine("POMAgentFactory::RemoveFromZoneSocketMap() - zone cannot be removed as it is not there in the map - " + zoneName);
                    }
                }
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception removeFromZoneSocketMap", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyPOMAgentToSocketClientMapping(String zone) throws Exception {
        tracer.finest("POMAgentFactory::ModifyPOMAgentToSocketClientMapping()");
        HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
        synchronized (hashMap) {
            HashMap<String, SocketClient> hashMap2 = zoneSocketMap;
            synchronized (hashMap2) {
                if (zoneSocketMap.containsKey(zone)) {
                    SocketClient newSocketClient = zoneSocketMap.get(zone);
                    if (agentSocketMap != null) {
                        for (Map.Entry<POMAgent, SocketClient> __dummyForeachVar8 : agentSocketMap.entrySet()) {
                            POMAgent agent = __dummyForeachVar8.getKey();
                            if (!agent.zoneName.equals(zone)) continue;
                            tracer.finest("POMAgentFactory::ModifyPOMAgentToSocketClientMapping() Changing socketClient for agent " + agent.getAgentID());
                            agent.setSocketClient(newSocketClient);
                            agentSocketMap.put(agent, newSocketClient);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POMAgent getPOMAgent(String id, POMAgentHandlerInterface pAgtHdlrInt) throws Exception {
        HashMap<POMAgent, SocketClient> hashMap;
        SocketClient sc = null;
        tracer.finest("POMAgentFactory::getPOMAgent() - id " + id);
        if (agentMap.containsKey(id)) {
            POMAgent agtToBeRemoved = InitPOMAgentFactory.getExistingPOMAgent(id);
            if (agtToBeRemoved != null && agentSocketMap.containsKey(agtToBeRemoved)) {
                hashMap = agentSocketMap;
                synchronized (hashMap) {
                    agentSocketMap.remove(agtToBeRemoved);
                }
                tracer.finest("POMAgentFactory::getPOMAgent() Removed existing agent.");
            }
            agentMap.remove(id);
        }
        POMAgent agent = new POMAgent(id, sc);
        agentMap.put(id, pAgtHdlrInt);
        hashMap = agentSocketMap;
        synchronized (hashMap) {
            agentSocketMap.put(agent, sc);
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POMAgent getExistingPOMAgent(String id) throws Exception {
        POMAgent agent;
        block11: {
            agent = null;
            tracer.finest("getExistingPOMAgent");
            try {
                if (agentSocketMap == null) {
                    tracer.finest("getExistingPOMAgent agentSocketMap == NULL !!!!!!!!!!");
                    break block11;
                }
                HashMap<POMAgent, SocketClient> hashMap = agentSocketMap;
                synchronized (hashMap) {
                    for (Map.Entry<POMAgent, SocketClient> __dummyForeachVar9 : agentSocketMap.entrySet()) {
                        try {
                            if (!__dummyForeachVar9.getKey().getAgentID().equals(id)) continue;
                            agent = __dummyForeachVar9.getKey();
                            break;
                        }
                        catch (Exception ex) {
                            InitPOMAgentFactory.getTracer().error("Exception in getExistingPOMAgent ", ex);
                        }
                    }
                }
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error(" Exception in getExistingPOMAgent", e);
            }
        }
        if (agent != null) {
            tracer.finest("getExistingPOMAgent() - Sending agent " + agent.getAgentID());
        } else {
            tracer.finest("getExistingPOMAgent() - agent not found for " + id);
        }
        return agent;
    }

    public static boolean removePOMAgent(String id) throws Exception {
        try {
            POMAgent agentToBeRemoved = InitPOMAgentFactory.getExistingPOMAgent(id);
            agentSocketMap.remove(agentToBeRemoved);
            POMAgentHandlerInterface retObj = agentMap.remove(id);
            tracer.finest("removePOMAgent() - removing agent " + id + " object : " + retObj);
            return retObj != null;
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception in removePOMAgent", e);
            return false;
        }
    }

    public static Set<String> getListOfCurrentlyManagedAgents() throws Exception {
        Set<String> agentList = null;
        if (agentMap != null) {
            agentList = agentMap.keySet();
            return agentList;
        }
        return agentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static POMAgentHandlerInterface getAgentHandler(String agentID) throws Exception {
        HashMap<String, POMAgentHandlerInterface> hashMap = agentMap;
        synchronized (hashMap) {
            if (agentMap.containsKey(agentID)) {
                return agentMap.get(agentID);
            }
            return null;
        }
    }

    private static String getCurrentTime() {
        String dateString = Calendar.getInstance().getTime() + " TID (" + Thread.currentThread().getId() + ")";
        return dateString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setZonePAMMap(HashMap<String, PAMSocketInfo> zonePAMMap) throws Exception {
        Object object = lockForZoneIPMap;
        synchronized (object) {
            for (Map.Entry<String, PAMSocketInfo> __dummyForeachVar10 : zonePAMMap.entrySet()) {
                try {
                    tracer.finest("POMAgentFactory::SetZonePAMMap() - pair is " + __dummyForeachVar10.getKey() + " : " + "IPAddress.ATTR=" + __dummyForeachVar10.getValue().ipAddress + ":" + __dummyForeachVar10.getValue().port);
                    if (zoneIPMap.containsKey(__dummyForeachVar10.getKey())) {
                        PAMSocketInfo currentValue = zoneIPMap.get(__dummyForeachVar10.getKey());
                        tracer.finest("POMAgentFactory::SetZonePAMMap() - Found existing value - IPAddress.ATTR=" + currentValue.ipAddress + ":" + currentValue.port);
                    }
                    if (__dummyForeachVar10.getValue().ipAddress.equals("")) {
                        zoneIPMap.remove(__dummyForeachVar10.getKey());
                        continue;
                    }
                    tracer.finest("POMAgentFactory::SetZonePAMMap() - Setting new value - IPAddress.ATTR=" + __dummyForeachVar10.getValue().ipAddress + ":" + __dummyForeachVar10.getValue().port);
                    zoneIPMap.put(__dummyForeachVar10.getKey(), __dummyForeachVar10.getValue());
                }
                catch (Exception e) {
                    InitPOMAgentFactory.getTracer().error("Exception in setZonePAMMap ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PAMSocketInfo findPAMSocketInfoForZone(String zoneName) throws Exception {
        PAMSocketInfo pa = null;
        tracer.finest("FindPAMSocketInfoForZone() - zoneName = " + zoneName);
        try {
            Object object = lockForZoneIPMap;
            synchronized (object) {
                if (zoneIPMap.containsKey(zoneName)) {
                    pa = zoneIPMap.get(zoneName);
                    tracer.finest("FindPAMSocketInfoForZone() - found PAMSocketInfo for zoneName = " + zoneName + " IP " + "IPAddress.ATTR=" + pa.ipAddress + " Port = " + pa.port);
                }
            }
            if (pa != null) {
                tracer.finest("FindPAMSocketInfoForZone() - Returning PAMSocketInfo for zoneName = " + zoneName + " IP " + "IPAddress.ATTR=" + pa.ipAddress + " Port = " + pa.port);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception in findPAMSocketInfoForZone ", e);
        }
        return pa;
    }

    public static SocketClient[] getValidSocketClients() throws Exception {
        SocketClient[] scArray = new SocketClient[libUserAddressMap.size() + zoneSocketMap.size()];
        int scArraySize = 0;
        for (Map.Entry<PAMSocketInfo, SocketClient> entry : libUserAddressMap.entrySet()) {
            if (entry.getValue() == null) continue;
            scArray[scArraySize++] = entry.getValue();
        }
        for (Map.Entry<Object, SocketClient> entry : zoneSocketMap.entrySet()) {
            if (entry.getValue() == null) continue;
            scArray[scArraySize++] = entry.getValue();
        }
        for (int i = scArraySize; i < scArray.length; ++i) {
            scArray[i] = null;
        }
        return scArray;
    }

    public static void removeSCMappingInLibUserAddressMap(PAMSocketInfo pamInfo) throws Exception {
        tracer.finest("POMAgentFactory::RemoveSCMappingInLibUserAddressMap()");
        tracer.finest("POMAgentFactory::RemoveSCMappingInLibUserAddressMap() Removing entry for IPAddress.ATTR=" + pamInfo.ipAddress + ":" + pamInfo.port);
        PAMSocketInfo pa = null;
        try {
            if (libUserAddressMap != null) {
                for (Map.Entry<PAMSocketInfo, SocketClient> __dummyForeachVar13 : libUserAddressMap.entrySet()) {
                    if (__dummyForeachVar13.getValue() == null || __dummyForeachVar13.getValue().pamAddress == null || !__dummyForeachVar13.getValue().pamAddress.ipAddress.equals(pamInfo.ipAddress) || __dummyForeachVar13.getValue().pamAddress.port != pamInfo.port) continue;
                    pa = __dummyForeachVar13.getKey();
                    break;
                }
            }
            if (pa != null) {
                tracer.finest("POMAgentFactory::RemoveSCMappingInLibUserAddressMap() Removing mapping for IPAddress.ATTR=" + pa.ipAddress + ":" + pa.port);
                libUserAddressMap.put(pa, null);
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception in removeSCMappingInLibUserAddressMap ", e);
        }
    }

    private static ArrayBlockingQueue<String> getMgmtQueue() throws Exception {
        return mgmtQueue;
    }

    public static void addToMgmtQueue() throws Exception {
        if (mgmtQueue != null && mgmtQueue.size() == 0) {
            tracer.finest("POMAgentFactory::addToMgmtQueue() - Adding search ...");
            String search = "search";
            mgmtQueue.put(search);
        } else {
            tracer.finest("POMAgentFactory::addToMgmtQueue() - Not adding ...");
        }
    }

    public static void stopMgmtQueue() throws Exception {
        if (mgmtQueue != null && mgmtQueue.size() < 2) {
            tracer.finest("POMAgentFactory::stopMgmtQueue() - Adding stop ...");
            String stop = "stop";
            mgmtQueue.put(stop);
            tracer.finest("POMAgentFactory::stopMgmtQueue() - Done adding ...");
        } else {
            tracer.finest("POMAgentFactory::stopMgmtQueue() - Not adding ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ReentrantLock getLock(String agentId) {
        ReentrantLock lock = null;
        HashMap<String, ReentrantLock> hashMap = agentTaskMap;
        synchronized (hashMap) {
            lock = agentTaskMap.get(agentId);
            if (lock == null) {
                tracer.finest("POMAgentFactory::getLock() No Lock found for " + agentId + " Creating a lock at " + InitPOMAgentFactory.getCurrentTime());
                lock = new ReentrantLock(true);
                agentTaskMap.put(agentId, lock);
            } else {
                tracer.finest("POMAgentFactory::getLock() Lock found for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkOrCreateLockForAgent(String agentId) {
        ReentrantLock lock = null;
        HashMap<String, ReentrantLock> hashMap = agentTaskMap;
        synchronized (hashMap) {
            if (agentTaskMap.size() > 100) {
                tracer.finest("POMAgentFactory::checkOrCreateLockForAgent() agentTaskMap size is more than 100. Currently it is - " + agentTaskMap.size());
            }
            if ((lock = agentTaskMap.get(agentId)) == null) {
                tracer.finest("POMAgentFactory::checkOrCreateLockForAgent() Creating lock for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
                lock = new ReentrantLock(true);
                agentTaskMap.put(agentId, lock);
            } else {
                tracer.finest("POMAgentFactory::checkOrCreateLockForAgent() Lock Queue length is " + lock.getQueueLength() + " at " + InitPOMAgentFactory.getCurrentTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeIfLockDone(String agentId) {
        HashMap<String, ReentrantLock> hashMap = agentTaskMap;
        synchronized (hashMap) {
            ReentrantLock lock = agentTaskMap.get(agentId);
            if (lock == null) {
                tracer.finest("POMAgentFactory::removeIfLockDone() ERROR !!!. Lock not found for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
            } else {
                lock.unlock();
                tracer.finest("POMAgentFactory::removeIfLockDone() Lock unlocked for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
                if (!lock.hasQueuedThreads() && !lock.isLocked()) {
                    agentTaskMap.remove(agentId);
                    tracer.finest("POMAgentFactory::removeIfLockDone() Removed lock for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
                } else {
                    tracer.finest("POMAgentFactory::removeIfLockDone() Continuing lock for " + agentId + " at " + InitPOMAgentFactory.getCurrentTime());
                }
            }
        }
    }

    public static ILogger getTracer() {
        return tracer;
    }

    public static String getMyAddress() {
        return myAddress;
    }

    public static SSLContext getSslContex() {
        return sslContex;
    }

    public static POMServer getPomServer() {
        return pomServer;
    }

    public static void setPomServer(POMServer pomServer) {
        InitPOMAgentFactory.pomServer = pomServer;
    }

    static {
        DESKTOP_API_INTERNAL_ZONE_NAME = "DesktopAPI@@ZONE";
        pomServer = null;
        objTryConnectingToPOMLock = new Object();
        mgmtQueue = null;
        keepSocketAliveThread = null;
        tryConnectingToPOMThread = null;
        checkMaps = true;
        agentTaskMap = null;
        sslContex = null;
        myAddress = null;
        sentPAMForZone = false;
    }
}

