/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Agent;

import com.avaya.sdk.Agent.SDKReturnCodes;
import com.avaya.sdk.Data.POMAgentSkill;
import com.avaya.sdk.Data.POMAgentState;
import com.avaya.sdk.Data.POMAgentStatus;
import com.avaya.sdk.Data.POMAttribute;
import com.avaya.sdk.Data.POMCallbackDest;
import com.avaya.sdk.Data.POMCallbackType;
import com.avaya.sdk.Data.POMCompletionCode;
import com.avaya.sdk.Data.POMContactNumber;
import com.avaya.sdk.Data.POMDestination;
import com.avaya.sdk.Data.POMDestinationType;
import com.avaya.sdk.Data.POMErrorCode;
import com.avaya.sdk.Data.POMKeyValuePair;
import com.avaya.sdk.Internal.AgentAPIList;
import com.avaya.sdk.Internal.AgentCommand;
import com.avaya.sdk.Internal.AgentSDKUtil;
import com.avaya.sdk.Internal.Helper;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Socket.SocketClient;

public class POMAgent {
    private SocketClient sockClient = null;
    private Object socketLockObject = new Object();
    public String zoneName = "";
    private String agentID = null;

    public POMAgent(String agentID, SocketClient client) throws Exception {
        this.agentID = agentID;
        this.sockClient = client;
    }

    public String getAgentID() throws Exception {
        return this.agentID;
    }

    public void setAgentID(String agentID) throws Exception {
        this.agentID = agentID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketClient getSocketClient() throws Exception {
        Object object = this.socketLockObject;
        synchronized (object) {
            return this.sockClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocketClient(SocketClient sc) throws Exception {
        Object object = this.socketLockObject;
        synchronized (object) {
            this.sockClient = sc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLogon(String agentExt, String pwd, Boolean isForce, String locale, String timeZone, String zone) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - " + this.agentID);
        if (agentExt == null || pwd == null || locale == null || zone == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        this.zoneName = zone;
        int returnCode = this.initialize();
        if (returnCode != 0) {
            return returnCode;
        }
        AgentCommand logon = new AgentCommand(AgentAPIList.AGTLogon, this.agentID, agentExt, pwd, isForce.toString().toLowerCase(), locale, timeZone, this.zoneName);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(logon);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception inAGTLogon ", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLogon(String agentExt, String pwd, Boolean isForce, String locale, String timeZone, String zone, String agentName, POMAgentSkill[] agentSkills) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() with skills info - " + this.agentID);
        if (agentExt == null || pwd == null || locale == null || zone == null || agentName == null || agentSkills == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        this.zoneName = zone;
        int returnCode = this.initialize();
        if (returnCode != 0) {
            return returnCode;
        }
        AgentCommand logon = new AgentCommand(AgentAPIList.AGTLogon, this.agentID, agentExt, pwd, isForce.toString().toLowerCase(), locale, timeZone, this.zoneName, agentName, Helper.convertPOMAgentSkillArrayToString(agentSkills));
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(logon);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTLogon", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLogon(String agentExt, String pwd, Boolean isForce, String locale, String timeZone, String zone, String orgName) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - " + this.agentID + " orgName = " + orgName);
        if (agentExt == null || pwd == null || locale == null || zone == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        this.zoneName = zone;
        int returnCode = this.initialize();
        if (returnCode != 0) {
            return returnCode;
        }
        AgentCommand logon = new AgentCommand(AgentAPIList.AGTLogon, this.agentID, agentExt, pwd, isForce.toString().toLowerCase(), locale, timeZone, this.zoneName, orgName);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(logon);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception inAGTLogon ", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLogon(String agentExt, String pwd, Boolean isForce, String locale, String timeZone, String zone, String agentName, POMAgentSkill[] agentSkills, String orgName) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() with skills info - " + this.agentID + " orgName " + orgName);
        if (agentExt == null || pwd == null || locale == null || zone == null || agentName == null || agentSkills == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        this.zoneName = zone;
        int returnCode = this.initialize();
        if (returnCode != 0) {
            return returnCode;
        }
        AgentCommand logon = new AgentCommand(AgentAPIList.AGTLogon, this.agentID, agentExt, pwd, isForce.toString().toLowerCase(), locale, timeZone, this.zoneName, agentName, Helper.convertPOMAgentSkillArrayToString(agentSkills), orgName);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(logon);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTLogon", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initialize() throws Exception {
        if (this.getSocketClient() == null) {
            int tryCounterForWaitTimeToGetSockClient;
            SocketClient newSocketClient = null;
            for (tryCounterForWaitTimeToGetSockClient = 5; tryCounterForWaitTimeToGetSockClient > 0; --tryCounterForWaitTimeToGetSockClient) {
                newSocketClient = InitPOMAgentFactory.getSocketClientForZone(this.zoneName, false);
                if (newSocketClient == null) {
                    InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - PAM Zone manager where zoneName = " + this.zoneName + " for agent " + this.agentID + " not found.");
                    InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() - Sleeping for 300 ms.");
                    Thread.sleep(300L);
                    continue;
                }
                Object object = this.socketLockObject;
                synchronized (object) {
                    this.sockClient = newSocketClient;
                    break;
                }
            }
            if (tryCounterForWaitTimeToGetSockClient == 0 && newSocketClient == null) {
                InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogon() return PAM_NOT_AVAILABLE_FOR_ZONE");
                return SDKReturnCodes.PAM_NOT_AVAILABLE_FOR_ZONE.getValue();
            }
        }
        InitPOMAgentFactory.updateAgentSocketMap(this, this.getSocketClient());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLogoff() throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTLogoff() - " + this.agentID);
        AgentCommand logoff = new AgentCommand(AgentAPIList.AGTLogoff, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(logoff);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTLogoff ", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTReleaseLine(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTReleaseLine() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTReleaseLine() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand releaseLine = new AgentCommand(AgentAPIList.AGTReleaseLine, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(releaseLine);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTReleaseLine", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTHoldCall(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTHoldCall() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTHoldCall() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand holdCall = new AgentCommand(AgentAPIList.AGTHoldCall, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(holdCall);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTHoldCall", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTUnholdCall(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTUnholdCall() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTUnholdCall() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand unholdCall = new AgentCommand(AgentAPIList.AGTUnholdCall, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(unholdCall);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTUnholdCall", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetCompCodes(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetCompletionCodes() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetCompCodes() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getCompletionCodes = new AgentCommand(AgentAPIList.AGTGetCompCodes, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getCompletionCodes);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTGetCompCodes", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTWrapupContact(POMCompletionCode completionCode, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTWrapupContact() - " + this.agentID);
        if (sessionID == null || completionCode == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTWrapupContact() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand wrapupContact = new AgentCommand(AgentAPIList.AGTWrapupContact, this.agentID, Helper.pOMCompletionCodeToString(completionCode), sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(wrapupContact);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTWrapupContact", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTConsultCall(POMDestination destination, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTConsultCall() - " + this.agentID);
        if (sessionID == null || destination == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTConsultCall() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand consultCall = new AgentCommand(AgentAPIList.AGTConsultCall, this.agentID, Helper.pOMDestinationToString(destination), sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(consultCall);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTConsultCall", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetConsultTypes(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetConsultTypes() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetConsultTypes() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand consultTypes = new AgentCommand(AgentAPIList.AGTGetConsultTypes, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(consultTypes);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTGetConsultTypes", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetConsultDestsForType(POMDestinationType destinationType, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetConsultDestsForType() - " + this.agentID);
        if (sessionID == null || destinationType == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetConsultDestsForType() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand consultDests = new AgentCommand(AgentAPIList.AGTGetConsultDestsForType, this.agentID, destinationType.toString(), "Default", sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(consultDests);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception in AGTGetConsultDestsForType", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTCompleteTransfer(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTCompleteTransfer() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTCompleteTransfer() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand redial = new AgentCommand(AgentAPIList.AGTCompleteTransfer, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(redial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTCancelConsult(String destAgentID, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTCancelConsult() - " + this.agentID);
        if (sessionID == null || destAgentID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTCancelConsult() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand redial = new AgentCommand(AgentAPIList.AGTCancelConsult, this.agentID, destAgentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(redial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTStateChange(POMAgentState agentState, String reasonCode, String reasonName, Boolean hasWalkedAway) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTStateChange() - " + this.agentID);
        if (agentState == null || reasonCode == null || reasonName == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTStateChange() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand redial = new AgentCommand(AgentAPIList.AGTStateChange, this.agentID, agentState.name(), reasonCode, reasonName, hasWalkedAway.toString().toLowerCase());
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(redial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTStartConf(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTStartConf() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTStartConf() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand startConf = new AgentCommand(AgentAPIList.AGTStartConf, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(startConf);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTEndConf(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTEndConf() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTEndConf() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand endConf = new AgentCommand(AgentAPIList.AGTEndConf, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(endConf);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTConfChangeOwnership(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTConfChangeOwnership() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTConfChangeOwnership() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand confChangeOwnership = new AgentCommand(AgentAPIList.AGTConfChangeOwnership, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(confChangeOwnership);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTRedial(POMContactNumber contactNumber) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTRedial() - " + this.agentID);
        if (contactNumber == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTRedial() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand redial = new AgentCommand(AgentAPIList.AGTRedial, this.agentID, Helper.POMContactNumberToString(contactNumber));
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(redial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTExtendWrapup(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTExtendWrapup() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTExtendWrapup() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand redial = new AgentCommand(AgentAPIList.AGTExtendWrapup, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(redial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTSendDTMF(String dtmf, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTSendDTMF() - " + this.agentID);
        if (sessionID == null || dtmf == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTSendDTMF() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand sendDTMF = new AgentCommand(AgentAPIList.AGTSendDTMF, this.agentID, dtmf, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(sendDTMF);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetCallbackTypes(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetCallbackTypes() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetCallbackTypes() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getCallbackTypes = new AgentCommand(AgentAPIList.AGTGetCallbackTypes, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getCallbackTypes);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetCallbackDestsForType(POMCallbackType callbackType, String zoneName, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetCallbackDestsForType() - " + this.agentID);
        if (sessionID == null || callbackType == null || zoneName == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetCallbackDestsForType() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getCallbackDestsForType = new AgentCommand(AgentAPIList.AGTGetCallbackDestsForType, this.agentID, callbackType.name(), sessionID, zoneName);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getCallbackDestsForType);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetCallbackDestsForType(POMCallbackType callbackType, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetCallbackDestsForType() - " + this.agentID);
        if (sessionID == null || callbackType == null || this.zoneName == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetCallbackDestsForType() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getCallbackDestsForType = new AgentCommand(AgentAPIList.AGTGetCallbackDestsForType, this.agentID, callbackType.name(), sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getCallbackDestsForType);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTCreateCallback(POMCallbackType callbackType, POMCallbackDest callbackDest, String callbackTime, String callbackTimezone, String callbackExpiryTime, POMContactNumber contactNumber, String agentNotes, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTCreateCallback() - " + this.agentID);
        if (callbackType == null || callbackDest == null || callbackTime == null || callbackTimezone == null || callbackExpiryTime == null || contactNumber == null || agentNotes == null || sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTCreateCallback() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand createCallback = new AgentCommand(AgentAPIList.AGTCreateCallback, this.agentID, callbackType.name(), Helper.POMCallbackDestinationToString(callbackDest), callbackTime, callbackTimezone, callbackExpiryTime, Helper.POMContactNumberToString(contactNumber), agentNotes, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(createCallback);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetErrorString(int errorCode) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetErrorString() - " + this.agentID + " errorCode : " + errorCode);
        AgentCommand getErrorString = new AgentCommand(AgentAPIList.AGTGetErrorString, this.agentID, String.valueOf(errorCode));
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getErrorString);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetErrorInfo(POMErrorCode errorCode) throws Exception {
        try {
            InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetErrorInfo() - " + this.agentID + " errorCode : " + errorCode.geterrorCode() + " apiName : " + errorCode.getapiName());
            AgentCommand getErrorString = new AgentCommand(AgentAPIList.AGTGetErrorInfo, this.agentID, Helper.POMErrorCodeToString(errorCode));
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getErrorString);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTPreviewDial(POMContactNumber contactNumber, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTPreviewDial() - " + this.agentID);
        if (sessionID == null || contactNumber == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTPreviewDial() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand previewDial = new AgentCommand(AgentAPIList.AGTPreviewDial, this.agentID, Helper.POMContactNumberToString(contactNumber), sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(previewDial);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTPreviewCancel(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTPreviewCancel() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTPreviewCancel() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand previewCancel = new AgentCommand(AgentAPIList.AGTPreviewCancel, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(previewCancel);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetCustomerDetails(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetCustomerDetails() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTGetCustomerDetails() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getCustomerDetails = new AgentCommand(AgentAPIList.AGTGetCustomerDetails, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getCustomerDetails);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTSetCustomerDetail(POMKeyValuePair pomKeyValuePair, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTSetCustomerDetail() - " + this.agentID);
        if (sessionID == null || pomKeyValuePair == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTSetCustomerDetail() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand setCustomerDetail = new AgentCommand(AgentAPIList.AGTSetCustomerDetail, this.agentID, Helper.POMKeyValuePairToString(pomKeyValuePair), sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(setCustomerDetail);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTBlendToInbound() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTBlendToInbound() - " + this.agentID);
        AgentCommand blendToInbound = new AgentCommand(AgentAPIList.AGTBlendToInbound, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(blendToInbound);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTBlendToOutbound() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTBlendToOutbound() - " + this.agentID);
        AgentCommand blendToOutbound = new AgentCommand(AgentAPIList.AGTBlendToOutbound, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(blendToOutbound);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTNailupAgent() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTNailupAgent() - " + this.agentID);
        AgentCommand nailupAgent = new AgentCommand(AgentAPIList.AGTNailupAgent, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(nailupAgent);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTReadyForNailup() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTReadyForNailup() - " + this.agentID);
        AgentCommand readyForNailup = new AgentCommand(AgentAPIList.AGTReadyForNailup, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(readyForNailup);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTLostNailing() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTLostNailing() - " + this.agentID);
        AgentCommand lostNailing = new AgentCommand(AgentAPIList.AGTLostNailing, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(lostNailing);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTPendingLogout() throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTPendingLogout() - " + this.agentID);
        AgentCommand pendingLogout = new AgentCommand(AgentAPIList.AGTPendingLogout, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(pendingLogout);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetAgentStatusResponse(POMAgentStatus agentStatus) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::GetAgentStatusResponse() - " + this.agentID);
        if (agentStatus == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::GetAgentStatusResponse() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand agentStatusCmd = new AgentCommand(AgentAPIList.GetAgentStatusResponse, this.agentID, Helper.POMAgentStatusToString(agentStatus));
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(agentStatusCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AgentSDKConnected(SocketClient sc, String semiColonSeparatedAgentList) throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AgentSDKConnected() - " + this.agentID);
        InitPOMAgentFactory.getTracer().fine("POMAgent::AgentSDKConnected() - setting sockClient for internal agent " + this.agentID);
        Object object = this.socketLockObject;
        synchronized (object) {
            InitPOMAgentFactory.getTracer().finest("POMAgent::AgentSDKConnected() - Got lock ...");
            this.sockClient = sc;
        }
        if (sc != null) {
            AgentCommand agentSDKConnected = new AgentCommand(AgentAPIList.AgentSDKConnected, this.agentID, semiColonSeparatedAgentList, AgentSDKUtil.getSDkVersion());
            try {
                sc.send(agentSDKConnected);
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception", ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetPAMForZone(String zoneName) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::GetPAMForZone() - " + this.agentID);
        if (zoneName == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::GetPAMForZone() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand getPAMForZoneCmd = new AgentCommand(AgentAPIList.GetPAMForZone, this.agentID, zoneName);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getPAMForZoneCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTAddAgentNote(String agentNote) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTAddAgentNote() - " + this.agentID);
        if (agentNote == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTAddAgentNote() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand agentNoteCmd = new AgentCommand(AgentAPIList.AGTAddAgentNote, this.agentID, agentNote);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(agentNoteCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTRefreshAgentNotes() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTRefreshAgentNotes() - " + this.agentID);
        AgentCommand agentNoteCmd = new AgentCommand(AgentAPIList.AGTRefreshAgentNotes, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(agentNoteCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetTimezones() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetTimezones() - " + this.agentID);
        AgentCommand getTZCmd = new AgentCommand(AgentAPIList.AGTGetTimezones, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getTZCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTAvailableForNailup() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTAvailableForNailup() - " + this.agentID);
        AgentCommand availableForNailupCmd = new AgentCommand(AgentAPIList.AGTAvailableForNailup, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(availableForNailupCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTAgentDisconnected() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTAgentDisconnected() - " + this.agentID);
        AgentCommand agentDisconnectedCmd = new AgentCommand(AgentAPIList.AGTAgentDisconnected, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(agentDisconnectedCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTAddToDNC(POMAttribute[] addressList) throws Exception {
        Object pomAttr;
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTAddToDNC() - " + this.agentID);
        if (addressList == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTAddToDNC() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        StringBuffer strAddressList = new StringBuffer();
        for (int i = 0; i < addressList.length; ++i) {
            pomAttr = addressList[i];
            strAddressList.append(Helper.POMAttributeToString((POMAttribute)pomAttr));
            strAddressList.append(";");
        }
        AgentCommand addToDncCmd = new AgentCommand(AgentAPIList.AGTAddToDNC, this.agentID, strAddressList.toString());
        try {
            pomAttr = this.socketLockObject;
            synchronized (pomAttr) {
                this.sockClient.send(addToDncCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetZoneList() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetZoneList() - " + this.agentID);
        AgentCommand getZLCmd = new AgentCommand(AgentAPIList.AGTGetZoneList, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getZLCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTIsInDNC(String phoneValue, String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTIsInDNC() - " + this.agentID);
        if (sessionID == null || phoneValue == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTIsInDNC() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand isInDNCCmd = new AgentCommand(AgentAPIList.AGTIsInDNC, this.agentID, phoneValue, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(isInDNCCmd);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTSaveAgentForHA() throws Exception {
        InitPOMAgentFactory.getTracer().fine("POMAgent::AGTSaveAgentForHA() - " + this.agentID);
        AgentCommand saveAgentForHA = new AgentCommand(AgentAPIList.AGTSaveAgentForHA, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(saveAgentForHA);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTSkillsChanged(POMAgentSkill[] agentSkills) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTSkillsChanged() - " + this.agentID);
        AgentCommand skillsChanged = new AgentCommand(AgentAPIList.AGTSkillsChanged, this.agentID, Helper.convertPOMAgentSkillArrayToString(agentSkills));
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(skillsChanged);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetContactAttributes() throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetContactAttributes() - " + this.agentID);
        AgentCommand getContactAttributes = new AgentCommand(AgentAPIList.AGTGetContactAttributes, this.agentID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getContactAttributes);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTGetWorkRequestId(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTGetWorkRequestId() - " + this.agentID);
        AgentCommand getWorkRequestId = new AgentCommand(AgentAPIList.AGTGetWorkRequestId, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(getWorkRequestId);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("POMAgent::AGTGetWorkRequestId() Stack Trace : ", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int AGTManualCallConnect(String sessionID) throws Exception {
        InitPOMAgentFactory.getTracer().finest("POMAgent::AGTManualCallConnect() - " + this.agentID);
        if (sessionID == null) {
            InitPOMAgentFactory.getTracer().fine("POMAgent::AGTManualCallConnect() - Invalid argument.");
            return SDKReturnCodes.INVALID_ARGUMENT.getValue();
        }
        AgentCommand manualConnect = new AgentCommand(AgentAPIList.AGTManualCallConnect, this.agentID, sessionID);
        try {
            Object object = this.socketLockObject;
            synchronized (object) {
                this.sockClient.send(manualConnect);
            }
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return SDKReturnCodes.SDK_Failure.getValue();
        }
        return SDKReturnCodes.SUCCESS.getValue();
    }
}

