/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Internal;

import com.avaya.sdk.Internal.AgentAPIList;
import com.avaya.sdk.Internal.MessageHeader;
import com.avaya.sdk.Internal.MessageTypeList;

public class Message {
    private MessageHeader commandHeader = null;
    private String[] commandParams = null;
    private int parameterCount = 0;
    private String result = null;

    public String getResult() throws Exception {
        this.result = this.result.trim();
        return this.result;
    }

    public void setResult(String result) throws Exception {
        this.result = result;
    }

    public Message(AgentAPIList commandName, MessageTypeList commandType, String agentId) throws Exception {
        this.commandHeader = new MessageHeader(commandName, commandType, agentId);
    }

    public Message(AgentAPIList commandName, MessageTypeList commandType, String agentId, int packetID) throws Exception {
        this.commandHeader = new MessageHeader(commandName, commandType, agentId, packetID);
    }

    public void addParameter(String[] paramvalue) throws Exception {
        this.commandParams = paramvalue;
        for (int i = 0; i < paramvalue.length; ++i) {
            this.commandHeader.increamentDataSegmentCount();
            ++this.parameterCount;
        }
    }

    public MessageHeader getCommandHeader() throws Exception {
        return this.commandHeader;
    }

    public String getCommandPacket() {
        String packet = this.commandHeader.toString();
        if (MessageTypeList.R == this.commandHeader.getCommandType()) {
            if (null == this.result) {
                this.result = "-1";
            }
            this.result = this.pad(this.result.toString(), 5);
            packet = packet + this.result;
        }
        StringBuffer strbuf = new StringBuffer(packet);
        for (int i = 0; i < this.parameterCount; ++i) {
            String param = this.commandParams[i];
            String strParamLength = this.pad(Integer.toString(param.length()), 4);
            strbuf.append(strParamLength);
            strbuf.append(param);
        }
        return strbuf.toString();
    }

    public String[] getCommandParams() {
        return this.commandParams;
    }

    public int getParameterCount() throws Exception {
        return this.parameterCount;
    }

    public String pad(String str, int expectedSize) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < expectedSize) {
            padded.append(" ");
        }
        return padded.toString();
    }

    public void setCommandHeader(MessageHeader commandHeader) throws Exception {
        this.commandHeader = commandHeader;
    }

    public void setCommandParams(String[] commandParams) throws Exception {
        this.commandParams = commandParams;
    }

    public void setParameterCount(int parameterCount) throws Exception {
        this.parameterCount = parameterCount;
    }
}

