/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Socket;

import com.avaya.sdk.Agent.SDKReturnCodes;
import com.avaya.sdk.Internal.AgentCommand;
import com.avaya.sdk.Internal.IncomingPacketProcessor;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Internal.MessageHeader;
import com.avaya.sdk.Internal.MessageTypeList;
import com.avaya.sdk.PAMSocketInfo;
import com.avaya.sdk.Socket.SocketClientSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import javax.net.ssl.SSLSocket;

public class SocketClient
extends Thread {
    private static final int BUFFER_SIZE = 102400;
    private static final int CONNECT_RETRY_INTERVAL = 2;
    private SocketClient socketClient = null;
    public PAMSocketInfo pamAddress = null;
    private IncomingPacketProcessor packetProcessor = null;
    private byte[] buffer = new byte[102400];
    private String host = null;
    private SSLSocket sslsocket = null;
    private InputStream inputStream = null;
    private OutputStream outputstream = null;
    private int port = 0;
    private int pos = 0;
    private ArrayBlockingQueue<Message> receiverQueue = new ArrayBlockingQueue(5000);
    private ArrayBlockingQueue<AgentCommand> senderQueue = new ArrayBlockingQueue(5000);
    private Object senderQueueLockObject = new Object();
    SocketClientSender clientSender = null;
    private Boolean exitIfCannotConnect = false;
    private Boolean stopSocketClientThread = false;
    private String zoneName = "";
    private Object lockObject = new Object();
    public static String DUMMY_ZONE_NAME = "DUMMY_ZONE_NAME";
    private Boolean connected = false;
    private Boolean retry = true;
    Boolean exitProcessThread = false;

    public SocketClient(String host, int port, String zoneName, Boolean exitIfCannotConnect) throws Exception {
        this.host = host;
        this.port = port;
        this.exitIfCannotConnect = exitIfCannotConnect;
        this.packetProcessor = new IncomingPacketProcessor(this);
        this.packetProcessor.runThread();
        this.socketClient = this;
        this.pamAddress = new PAMSocketInfo();
        this.pamAddress.ipAddress = host;
        this.pamAddress.port = port;
        this.zoneName = zoneName;
    }

    public void runThread() throws Exception {
        if (!this.isAlive()) {
            InitPOMAgentFactory.getTracer().finest("SocketClient::RunThread() creating new thread.");
            this.socketClient.start();
        } else {
            InitPOMAgentFactory.getTracer().finest("SocketClient thread is alive.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSocketClient() throws Exception {
        Object object = this.lockObject;
        synchronized (object) {
            InitPOMAgentFactory.getTracer().finest("SocketClient::StopSocketClient()");
            if (this.sslsocket != null) {
                this.sslsocket.close();
                try {
                    if (this.packetProcessor != null) {
                        this.packetProcessor.abortThread();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.clientSender != null) {
                        this.clientSender.stopThread();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.socketClient != null && this.socketClient.isAlive()) {
                        this.exitProcessThread = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stopSocketClientThread = true;
        }
    }

    public Boolean connectToServer(Boolean exitFlag, String agentName) throws Exception {
        int i = 0;
        boolean connectSuccessful = false;
        boolean sendNotConnectedNotifToPOMProxy = true;
        boolean isIPAddressNull = false;
        Object fkeyStore = null;
        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() exitFlag = " + exitFlag + " agentName =" + agentName + " exitIfCannotConnectFlag = " + this.exitIfCannotConnect + " stopSocketClientThread = " + this.stopSocketClientThread);
        while (!connectSuccessful) {
            try {
                String ipAddress = this.host;
                if (this.host != null && this.host.compareTo("null") == 0) {
                    InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() ipAddress is null string. Skipping connection attempt.");
                    isIPAddressNull = true;
                } else {
                    isIPAddressNull = false;
                    if (ipAddress != null) {
                        if (!ipAddress.equalsIgnoreCase(this.host)) {
                            InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() new PAM IP IPAddress.ATTR=" + ipAddress + " while old PAM IP - " + this.host);
                            this.host = ipAddress;
                        }
                    } else {
                        Exception e = new Exception("Null_PAM_IP");
                        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() could not connect to PAM because IP is NULL.");
                    }
                }
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception", ex);
            }
            try {
                if (isIPAddressNull) {
                    Exception ipAddressNull = new Exception("PAM for the zone is not yet UP. Retry again after some time.");
                    throw ipAddressNull;
                }
                try {
                    if (this.outputstream != null) {
                        this.outputstream.close();
                    }
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                    if (this.sslsocket != null) {
                        this.sslsocket.close();
                    }
                    InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - Closed open streams and sslsocket.");
                }
                catch (Exception ex) {
                    InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - could not close open streams.");
                }
                InitPOMAgentFactory.getTracer().finest("Trying to connect to server IPAddress.ATTR=" + this.host);
                if (InitPOMAgentFactory.getMyAddress() != null) {
                    InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - Binding sockect to local specified address ." + InitPOMAgentFactory.getMyAddress());
                    InetAddress localAddress = InetAddress.getByName(InitPOMAgentFactory.getMyAddress());
                    this.sslsocket = (SSLSocket)InitPOMAgentFactory.getSslContex().getSocketFactory().createSocket(this.host, this.port, localAddress, 0);
                } else {
                    this.sslsocket = (SSLSocket)InitPOMAgentFactory.getSslContex().getSocketFactory().createSocket(this.host, this.port);
                }
                this.sslsocket.startHandshake();
                this.outputstream = this.sslsocket.getOutputStream();
                this.inputStream = this.sslsocket.getInputStream();
                InitPOMAgentFactory.getTracer().finest("Connect Successful.!!!");
                connectSuccessful = true;
                this.connected = true;
                if (!exitFlag.booleanValue()) {
                    InitPOMAgentFactory.getTracer().finest("POMAgentFactory::connectToServer() - Adding to zoneSocketMap IPAddress.ATTR=" + this.pamAddress.ipAddress + ":" + this.pamAddress.port + " for " + this.zoneName);
                    InitPOMAgentFactory.addToZoneSocketMap(this.zoneName, this);
                }
                InitPOMAgentFactory.sendSDKStartedCmdToPAM(this, agentName);
                sendNotConnectedNotifToPOMProxy = false;
                this.runThread();
            }
            catch (Exception ex) {
                this.connected = false;
                InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - exitFlag = " + exitFlag + " exitIfCannotConnect = " + this.exitIfCannotConnect);
                InitPOMAgentFactory.getTracer().finest("Connection attempt failed. Will retry in  2 Seconds ");
                InitPOMAgentFactory.getTracer().error("Exception", ex);
                InitPOMAgentFactory.getTracer().finest("Connection Retrying attempt : " + ++i);
                if (sendNotConnectedNotifToPOMProxy) {
                    InitPOMAgentFactory.sendPOMNotAvailableNotificationToPOMProxy(this.socketClient);
                    sendNotConnectedNotifToPOMProxy = false;
                }
                this.sendErrorForAllIncomingCmds(this);
                Boolean hasChanged = false;
                InitPOMAgentFactory.removeFromZoneSocketMap(this, this.zoneName);
                if (!exitFlag.booleanValue()) {
                    if (this.host != null && this.host.compareTo("null") == 0) {
                        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - this.host == null.");
                        HashMap<String, PAMSocketInfo> newZonePAMMap = new HashMap<String, PAMSocketInfo>();
                        PAMSocketInfo psi = new PAMSocketInfo();
                        psi.ipAddress = "null";
                        psi.port = 0;
                        newZonePAMMap.put(this.zoneName, psi);
                        InitPOMAgentFactory.setZonePAMMap(newZonePAMMap);
                    } else {
                        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - this.host != null. Setting it to null.");
                    }
                    InitPOMAgentFactory.findNewPAMForZone(this.zoneName);
                    PAMSocketInfo newPAMAddress = InitPOMAgentFactory.findPAMSocketInfoForZone(this.zoneName);
                    if (newPAMAddress != null) {
                        if (newPAMAddress.ipAddress.equals(this.pamAddress.ipAddress) && newPAMAddress.port == this.pamAddress.port) {
                            hasChanged = false;
                        } else {
                            InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - PAM IP for this zone has changed.");
                            InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - Existing PAM - IPAddress.ATTR=" + this.pamAddress.ipAddress + ":" + this.pamAddress.port + " New PAM - " + newPAMAddress.ipAddress + ":" + newPAMAddress.port);
                            hasChanged = true;
                            this.host = newPAMAddress.ipAddress;
                            this.port = newPAMAddress.port;
                            this.pamAddress.ipAddress = newPAMAddress.ipAddress;
                            this.pamAddress.port = newPAMAddress.port;
                        }
                    }
                }
                if (exitFlag.booleanValue() || hasChanged.booleanValue()) {
                    if (this.exitIfCannotConnect.booleanValue() || this.stopSocketClientThread.booleanValue()) {
                        InitPOMAgentFactory.getTracer().finest("SocketClient:connectToServer() - Stopping because exitIfCannotConnect = " + this.exitIfCannotConnect + " and stopSocketClientThread = " + this.stopSocketClientThread + " and hasChanged = " + hasChanged + " this.pamAddress.ipAddress " + "IPAddress.ATTR=" + this.pamAddress.ipAddress + " this.pamAddress.port = " + this.pamAddress.port);
                        try {
                            this.exitAfterCleanup();
                        }
                        catch (Exception e) {
                            InitPOMAgentFactory.getTracer().error("Exception", e);
                        }
                        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - Informing POMAgentFactory to modify POMAgent SocketClient mapping.");
                        InitPOMAgentFactory.modifyPOMAgentToSocketClientMapping(this.zoneName);
                        return false;
                    }
                    if (exitFlag.booleanValue() && !this.retry.booleanValue()) {
                        this.retry = true;
                        InitPOMAgentFactory.getTracer().finest("SocketClient::connectToServer() - No need to retry. Return false ");
                        return false;
                    }
                }
                Thread.sleep(2000L);
            }
            if (exitFlag.booleanValue()) continue;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendErrorForAllIncomingCmds(SocketClient sc) throws Exception {
        block8: {
            try {
                InitPOMAgentFactory.getTracer().finest("SocketClient::sendErrorForAllIncomingCmds()");
                ArrayList<AgentCommand> commands = new ArrayList<AgentCommand>();
                if (this.senderQueue != null) {
                    Iterator iterator = this.senderQueueLockObject;
                    synchronized (iterator) {
                        InitPOMAgentFactory.getTracer().finest("senderQueue.Count " + this.senderQueue.size());
                        while (this.senderQueue.peek() != null) {
                            commands.add(this.senderQueue.poll());
                        }
                    }
                    InitPOMAgentFactory.getTracer().finest("SocketClient::sendErrorForAllIncomingCmds() count = " + commands.size());
                    for (Object e : commands) {
                        AgentCommand cmd = (AgentCommand)e;
                        AgentCommand agentCommand = null;
                        agentCommand = cmd;
                        InitPOMAgentFactory.getTracer().finest("SocketClient::sendErrorForAllIncomingCmds() for command " + (Object)((Object)agentCommand.getAgentAPIList()));
                        Message pomNotAvailableGenericResponse = new Message(agentCommand.getAgentAPIList(), MessageTypeList.C, agentCommand.getAgentId(), agentCommand.packetID);
                        pomNotAvailableGenericResponse.setParameterCount(0);
                        String[] cmdParamsList = new String[10];
                        pomNotAvailableGenericResponse.setCommandParams(cmdParamsList);
                        MessageHeader msgHeader = new MessageHeader(agentCommand.getAgentAPIList(), MessageTypeList.R, agentCommand.getAgentId());
                        pomNotAvailableGenericResponse.setCommandHeader(msgHeader);
                        pomNotAvailableGenericResponse.setResult(SDKReturnCodes.POM_NOT_AVAILABLE.name());
                        InitPOMAgentFactory.sendErrorCommandResponseToPOMProxy(sc, pomNotAvailableGenericResponse);
                    }
                    break block8;
                }
                InitPOMAgentFactory.getTracer().finest("SocketClient::sendErrorForAllIncomingCmds() - senderQueue is null");
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception", ex);
            }
        }
    }

    public ArrayBlockingQueue<Message> getReceiverQueue() throws Exception {
        return this.receiverQueue;
    }

    public ArrayBlockingQueue<AgentCommand> getSenderQueue() throws Exception {
        return this.senderQueue;
    }

    public void packetArrived(byte[] pckt) throws Exception {
        this.packetProcessor.addPacketToQueue(pckt);
    }

    public Message receive() throws Exception {
        return this.receiverQueue.take();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SocketClient-" + Thread.currentThread().getId());
        try {
            this.clientSender = new SocketClientSender(this.socketClient);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.clientSender.runThread();
        byte[] b = new byte[1];
        int bytesRead = 0;
        int bufSize = 102400;
        while (!this.exitProcessThread.booleanValue()) {
            try {
                try {
                    b[0] = 0;
                    try {
                        bytesRead = this.inputStream.read(b);
                    }
                    catch (IOException iEx) {
                        InitPOMAgentFactory.getTracer().error("Exception", iEx);
                        bytesRead = -1;
                    }
                    if (-1 == bytesRead) {
                        InitPOMAgentFactory.getTracer().finest("bytesRead in SocketClient: " + bytesRead);
                        Thread.sleep(10L);
                        if (this.exitIfCannotConnect.booleanValue()) {
                            InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread exitIfCannotConnect = true. So exiting.");
                            this.startCleanUp();
                            return;
                        }
                        InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread invoking connectToServer");
                        if (this.connectToServer(false, InitPOMAgentFactory.INTERNAL_CMD_AGENTID + this.zoneName).booleanValue()) continue;
                        InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread connectToServer returned false. Exiting now. Setting exitProcessThread = true.");
                        this.exitProcessThread = true;
                        return;
                    }
                }
                catch (Exception ex) {
                    InitPOMAgentFactory.getTracer().error("Exception", ex);
                }
                if (bytesRead == 0 && this.pos == 0) {
                    InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread() bytesRead = pos = 0");
                    Thread.sleep(10L);
                    continue;
                }
                if (this.pos > bufSize) {
                    byte[] resizedBuffer = new byte[this.pos + 512];
                    System.arraycopy(this.buffer, 0, resizedBuffer, 0, this.pos);
                    this.buffer = null;
                    this.buffer = new byte[this.pos * 2];
                    System.arraycopy(resizedBuffer, 0, this.buffer, 0, this.pos);
                    resizedBuffer = null;
                    bufSize = this.pos + 512;
                    InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread() resizing buffer - pos = " + this.pos + " bufSize = " + bufSize);
                }
                this.buffer[this.pos++] = b[0];
                if (b[0] != 3) continue;
                byte[] newBuffer = new byte[this.pos];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.pos);
                this.buffer = null;
                this.buffer = new byte[102400];
                this.pos = 0;
                bufSize = 102400;
                InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread() bytesRead from socket - (IPAddress.ATTR=" + this.pamAddress.ipAddress + ":" + this.pamAddress.port + ") packet - " + Arrays.toString(newBuffer) + " size = " + newBuffer.length);
                this.packetArrived(newBuffer);
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception", ex);
            }
        }
    }

    public Object getSenderQueueLockObject() throws Exception {
        return this.senderQueueLockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AgentCommand agentCommand) throws Exception {
        if (null != agentCommand) {
            InitPOMAgentFactory.getTracer().finest("SocketClient::send() - Waiting for lock ...");
            Object object = this.senderQueueLockObject;
            synchronized (object) {
                InitPOMAgentFactory.getTracer().finest("SocketClient::send() - adding ID: " + agentCommand.packetID + " packet - " + (Object)((Object)agentCommand.getAgentAPIList()));
                InitPOMAgentFactory.getTracer().finest("SocketClient::send() - queue size is " + this.senderQueue.size() + " adding agentCommand = " + agentCommand);
                this.senderQueue.put(agentCommand);
            }
        }
    }

    public Boolean sendPacket(byte[] packet) throws Exception {
        boolean dataSendSuccessful = true;
        try {
            this.outputstream.write(packet);
            this.outputstream.flush();
        }
        catch (Exception ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            dataSendSuccessful = false;
        }
        return dataSendSuccessful;
    }

    public Boolean isConnected() throws Exception {
        return this.connected;
    }

    private void exitAfterCleanup() throws Exception {
        InitPOMAgentFactory.getTracer().finest("SocketClient:ExitAfterCleanup() for IPAddress.ATTR=" + this.pamAddress.ipAddress + ":" + this.pamAddress.port);
        try {
            if (this.packetProcessor != null) {
                this.packetProcessor.abortThread();
                this.packetProcessor = null;
            }
            if (this.clientSender != null) {
                this.clientSender.stopThread();
                this.clientSender = null;
            }
            if (this.socketClient != null) {
                this.exitProcessThread = true;
                this.socketClient = null;
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
    }

    public Boolean getRetry() throws Exception {
        return this.retry;
    }

    public void setRetry(Boolean retry) throws Exception {
        this.retry = retry;
    }

    private void startCleanUp() {
        this.exitProcessThread = true;
        try {
            InitPOMAgentFactory.removeSCMappingInLibUserAddressMap(this.pamAddress);
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread Exception in RemoveSCMappingInLibUserAddressMap");
        }
        try {
            this.exitAfterCleanup();
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().finest("SocketClient::ProcessThread Issues while exiting. But will forcefully ");
        }
    }
}

