/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Socket;

import com.avaya.sdk.Agent.SDKReturnCodes;
import com.avaya.sdk.Internal.AgentCommand;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Internal.MessageHeader;
import com.avaya.sdk.Internal.MessageTypeList;
import com.avaya.sdk.Socket.SocketClient;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class SocketClientSender
extends Thread {
    private boolean keepAlive = true;
    private SocketClient socketClient;
    public static final String SOCKET_COMMUNICATION_CHARSET = "UTF-8";
    public static final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    public static final CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();

    public SocketClientSender(SocketClient socketClient) throws Exception {
        this.socketClient = socketClient;
    }

    public void runThread() {
        this.start();
    }

    public void stopThread() throws Exception {
        InitPOMAgentFactory.getTracer().finest("SocketClientSender::StopThread()");
        try {
            this.keepAlive = false;
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSenderQueue() throws Exception {
        block12: {
            AgentCommand agentCommand = null;
            AgentCommand[] drainedList = null;
            try {
                Object object = this.socketClient.getSenderQueueLockObject();
                synchronized (object) {
                    if (this.socketClient.getSenderQueue().size() > 0) {
                        int senderQueueCount = this.socketClient.getSenderQueue().size();
                        InitPOMAgentFactory.getTracer().finest("SocketClientSender::processSenderQueue() senderQueue size : " + this.socketClient.getSenderQueue().size());
                        drainedList = new AgentCommand[this.socketClient.getSenderQueue().size()];
                        for (int i = 0; i < senderQueueCount; ++i) {
                            drainedList[i] = this.socketClient.getSenderQueue().poll();
                        }
                    }
                }
                if (drainedList == null) break block12;
                if (drainedList.length > 0) {
                    InitPOMAgentFactory.getTracer().finest("SocketClientSender::processSenderQueue() Drained size : " + drainedList.length);
                }
                for (int i = 0; i < drainedList.length; ++i) {
                    Object object2 = agentCommand = drainedList[i] instanceof AgentCommand ? drainedList[i] : (AgentCommand)null;
                    if (agentCommand != null) {
                        String entireLog = "\n";
                        entireLog = entireLog + "*********************************************************************************\n";
                        entireLog = entireLog + " POM_METRICS CLIENT (" + this.socketClient.pamAddress.ipAddress + ":" + this.socketClient.pamAddress.port + "): Sending  : " + agentCommand.decode() + "\n";
                        entireLog = entireLog + "*********************************************************************************\n";
                        InitPOMAgentFactory.getTracer().finest("SocketClientSender::processSenderQueue() Sending : " + entireLog);
                        byte[] commandBytes = null;
                        try {
                            String strAgentCommand = agentCommand.decode();
                            commandBytes = this.encode(strAgentCommand.toCharArray());
                        }
                        catch (Exception ex) {
                            InitPOMAgentFactory.getTracer().error("Exception", ex);
                        }
                        if (commandBytes == null) continue;
                        byte[] tmp = new byte[commandBytes.length + 1];
                        System.arraycopy(commandBytes, 0, tmp, 0, commandBytes.length);
                        tmp[commandBytes.length] = 3;
                        Boolean couldSend = this.socketClient.sendPacket(tmp);
                        if (couldSend.booleanValue()) continue;
                        Message pomNotAvailable = new Message(agentCommand.getAgentAPIList(), MessageTypeList.R, agentCommand.getAgentId());
                        String[] cmdParamsList = new String[10];
                        pomNotAvailable.setParameterCount(0);
                        pomNotAvailable.setCommandParams(cmdParamsList);
                        MessageHeader msgHeader = new MessageHeader(agentCommand.getAgentAPIList(), MessageTypeList.R, agentCommand.getAgentId());
                        pomNotAvailable.setCommandHeader(msgHeader);
                        int returnCode = SDKReturnCodes.POM_NOT_AVAILABLE.getValue();
                        pomNotAvailable.setResult(String.valueOf(returnCode));
                        InitPOMAgentFactory.sendErrorCommandResponseToPOMProxy(this.socketClient, pomNotAvailable);
                        InitPOMAgentFactory.getTracer().fine("SocketClientSender::processSenderQueue() - Sending POM_NOT_AVAILABLE for " + (Object)((Object)agentCommand.getAgentAPIList()) + " for agent " + agentCommand.getAgentId());
                        continue;
                    }
                    InitPOMAgentFactory.getTracer().finest("processSenderQueue - AgentCommand is NULL !!!!!!!!!!!!!! Ignoring for now.");
                }
            }
            catch (Exception e) {
                InitPOMAgentFactory.getTracer().error("Exception", e);
            }
        }
    }

    public boolean isKeepAlive() throws Exception {
        return this.keepAlive;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SocketClientSender-" + Thread.currentThread().getId());
        while (this.keepAlive) {
            try {
                Thread.sleep(50L);
                this.processSenderQueue();
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception", ex);
            }
        }
    }

    public void setKeepAlive(boolean keepAlive) throws Exception {
        this.keepAlive = keepAlive;
    }

    private byte[] encode(char[] charArray) {
        try {
            ByteBuffer bb = encoder.encode(CharBuffer.wrap(charArray));
            byte[] ba = new byte[bb.limit()];
            bb.get(ba);
            return ba;
        }
        catch (CharacterCodingException ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return null;
        }
    }
}

