/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Internal;

import com.avaya.sdk.Internal.AgentEventListener;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Socket.SocketClient;
import com.avaya.sdk.Socket.SocketUtil;
import java.util.concurrent.ArrayBlockingQueue;

public class IncomingPacketProcessor
extends Thread {
    private Object lockThis = new Object();
    private static SocketClient socketClient = null;
    private ArrayBlockingQueue<byte[]> processorQueue = new ArrayBlockingQueue(5000);
    public boolean keepAlive = true;
    private Thread newThread = this;

    public IncomingPacketProcessor(SocketClient sockClient) throws Exception {
        InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::IncomingPacketProcessor");
        socketClient = sockClient;
    }

    public void runThread() throws Exception {
        if (socketClient != null && IncomingPacketProcessor.socketClient.pamAddress != null) {
            InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::RunThread for IPAddress.ATTR=" + IncomingPacketProcessor.socketClient.pamAddress.ipAddress + ":" + IncomingPacketProcessor.socketClient.pamAddress.port);
        } else {
            InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::RunThread ");
        }
        this.start();
    }

    public void abortThread() throws Exception {
        InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::AbortThread");
        try {
            if (this.newThread != null) {
                this.keepAlive = false;
                this.newThread.interrupt();
                InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::AbortThread - aborted.");
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception abortThread", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketToQueue(byte[] byteBuf) throws Exception {
        Object object = this.lockThis;
        synchronized (object) {
            try {
                InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::addPacketToQueue");
                this.processorQueue.put(byteBuf);
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception addPacketToQueue", ex);
            }
        }
    }

    @Override
    public void run() {
        while (this.keepAlive) {
            try {
                byte[] pckt = this.processorQueue.take();
                Message message = SocketUtil.processPacketReceived(pckt);
                if (null == message) {
                    InitPOMAgentFactory.getTracer().finest("IncomingPacketProcessor::run !!! ERROR !!! - message is null.");
                    continue;
                }
                AgentEventListener.addPacketToQueue(message);
            }
            catch (Exception ex) {
                InitPOMAgentFactory.getTracer().error("Exception IncomingPacketProcessor run ", ex);
            }
        }
    }
}

