/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sdk.Socket;

import com.avaya.sdk.Internal.AgentAPIList;
import com.avaya.sdk.Internal.InitPOMAgentFactory;
import com.avaya.sdk.Internal.Message;
import com.avaya.sdk.Internal.MessageTypeList;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;

public class SocketUtil {
    public static final int agentIdLength = 30;
    public static final int commandNameLength = 30;
    public static final int commandTypeLength = 1;
    public static final int eachDataLength = 8;
    public static final int SocketClientSleepInterval = 50;
    public static final String SOCKET_COMMUNICATION_CHARSET = "UTF-8";
    public static final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    public static final CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
    public static final byte ETX = 3;
    public static final int numberOfDataSegmentsLength = 4;
    public static final int numberOfPacketIDLength = 8;
    public static final int MessageHeaderSize = 73;
    public static final String responseItemDelimeter = ";";
    public static final String responseIntraItemDelimeter = "|";
    public static final String KEY_VALUE_SEPERATOR = "=";
    public static final String KEYVALUE_ATTRIBUTE_SEPERATOR = ";AT";
    public static final String[] COMPLEX_MEMBER_ITEMS_SEPERATOR = new String[]{";###@###"};
    public static final String jobType = "jobType";
    public static final int resultLength = 5;
    public static final int ResponseMessageSize = 5;
    public static final int SC_RECEIVER_QUEUE_SIZE = 5000;
    public static final int SC_SENDER_QUEUE_SIZE = 5000;
    public static final int SS_COMMAND_QUEUE_SIZE = 2000;
    public static final int SS_FEEDBACK_QUEUE_SIZE = 2000;
    public static final int SS_FEEDBACK_QUEUE_SIZE_SMALL = 20;
    public static final byte STX = 2;
    public static final String TRUSTSTORE = "mySrvKeystore";
    public static final String TRUSTSTORE_PASSWORD = "password";

    private static ArrayList<String> getParamList(int intParamCnt, String data) throws Exception {
        ArrayList<String> paramList = new ArrayList<String>();
        try {
            int lengthStart = 0;
            for (int i = 0; i < intParamCnt; ++i) {
                String paramLength = data.substring(lengthStart, lengthStart + 8);
                paramLength = paramLength.trim();
                int intparamLength = 0;
                try {
                    intparamLength = Integer.parseInt(paramLength);
                }
                catch (Exception ex) {
                    throw new Exception("Invalid param length");
                }
                String paramVal = data.substring(lengthStart + 8, lengthStart + 8 + intparamLength);
                paramList.add(paramVal);
                lengthStart = lengthStart + 8 + intparamLength;
            }
        }
        catch (Exception e) {
            InitPOMAgentFactory.getTracer().error("Exception", e);
        }
        return paramList;
    }

    public static Message processPacketReceived(byte[] pckt) throws Exception {
        String request = SocketUtil.decode(pckt);
        if (request == null) {
            throw new Exception("Invalid packet  ");
        }
        if (!(request.startsWith("AGT") || request.startsWith("POM") || request.startsWith("PAM") || request.startsWith("Get") || request.startsWith("AgentSDK"))) {
            throw new Exception("Invalid packet received");
        }
        String strHeader = request.substring(0, 73);
        String commandName = strHeader.substring(0, 30);
        commandName = commandName.trim();
        AgentAPIList socketCommand = AgentAPIList.AGTLogon;
        try {
            socketCommand = AgentAPIList.valueOf(commandName);
        }
        catch (Exception ex) {
            throw new Exception("Invalid command name : " + commandName);
        }
        String messageType = strHeader.substring(30, 31);
        MessageTypeList messageTypeList = MessageTypeList.C;
        try {
            messageTypeList = MessageTypeList.valueOf(messageType);
        }
        catch (Exception ex) {
            throw new Exception("Invalid Message type received : " + messageType);
        }
        String agentId = strHeader.substring(31, 61);
        agentId = agentId.trim();
        String strpacketID = strHeader.substring(61, 69);
        strpacketID = strpacketID.trim();
        int packetID = 0;
        try {
            packetID = Integer.parseInt(strpacketID);
        }
        catch (Exception ex) {
            throw new Exception("Invalid packet ID : " + strpacketID);
        }
        String paramCount = strHeader.substring(69);
        paramCount = paramCount.trim();
        int intParamCnt = 0;
        try {
            intParamCnt = Integer.parseInt(paramCount);
        }
        catch (Exception ex) {
            throw new Exception("Invalid param count : " + paramCount);
        }
        Message command = new Message(socketCommand, messageTypeList, agentId, packetID);
        if (messageTypeList == MessageTypeList.R) {
            String respMessage = request.substring(73, 78);
            if (respMessage.length() != 5) {
                throw new Exception("Invalid Header");
            }
            String strResult = respMessage.substring(0, 5);
            strResult = strResult.trim();
            command.setResult(strResult);
        }
        int dataOffset = 73;
        if (messageTypeList == MessageTypeList.R) {
            dataOffset += 5;
        }
        String data = request.substring(dataOffset);
        String[] paramList = new String[]{};
        if (0 == intParamCnt && dataOffset + 1 != request.length()) {
            throw new Exception("Invalid packet : Contains garbage after header");
        }
        if (0 != intParamCnt) {
            ArrayList<String> arrList = SocketUtil.getParamList(intParamCnt, data);
            paramList = new String[arrList.size()];
            paramList = arrList.toArray(paramList);
        }
        command.setCommandParams(paramList);
        StringBuffer commandParams = new StringBuffer();
        if (command.getCommandParams() != null) {
            for (int i = 0; i < command.getCommandParams().length; ++i) {
                commandParams.append(command.getCommandParams()[i]);
            }
        }
        String packetToPrint = "\n******************************************************************************************\n";
        packetToPrint = packetToPrint + " POM_METRICS CLIENT : Received header = " + command.getCommandHeader() + " packet = " + command.getCommandPacket() + " params = " + commandParams;
        packetToPrint = packetToPrint + "\n******************************************************************************************";
        InitPOMAgentFactory.getTracer().finest("SocketUtil::processPacketReceived() " + packetToPrint);
        return command;
    }

    private static String decode(byte[] buff) {
        try {
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(buff));
            return cb.toString();
        }
        catch (CharacterCodingException ex) {
            InitPOMAgentFactory.getTracer().error("Exception", ex);
            return null;
        }
    }
}

