/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.attempt.AttemptEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class AttemptResultConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> attemptEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public AttemptResultConsumerThread(List<POMEvent> attemptEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.attemptEventNotifierList = new ArrayList<POMEvent>(attemptEventNotifierList);
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("AttemptResultConsumerThread started");
            while (this.isRunning.get()) {
                this.handleConsumerRecords();
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private void handleConsumerRecords() {
        try {
            ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
            for (ConsumerRecord record : records) {
                Util.printEventMetadata((ConsumerRecord<String, String>)record);
                AttemptEvent attemptEvent = GsonUtil.getObject((String)record.value(), AttemptEvent.class);
                if (attemptEvent == null) {
                    POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                    continue;
                }
                AttemptEvent transformedAttemptObject = this.transformAttemptResultObject(attemptEvent);
                for (POMEvent pomEventListener : this.attemptEventNotifierList) {
                    this.handlePOMEvent(pomEventListener, transformedAttemptObject);
                }
            }
        }
        catch (WakeupException e) {
            if (this.isRunning.get()) {
                POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in AttemptResultConsumerThread ", e);
        }
    }

    private void handlePOMEvent(POMEvent pomEventListener, AttemptEvent transformedAttemptObject) {
        try {
            pomEventListener.onEvent(transformedAttemptObject);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in AttemptResultEventConsumerCallback ", e);
        }
    }

    private AttemptEvent transformAttemptResultObject(AttemptEvent attemptEvent) {
        attemptEvent.setRcvdTimeStamp(System.currentTimeMillis());
        attemptEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return attemptEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in shutdown ", e);
        }
    }
}

