/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.attempt.EnrichedAttemptEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class EnrichedAttemptResultConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> enrichedAttemptEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public EnrichedAttemptResultConsumerThread(List<POMEvent> enrichedAttemptEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.enrichedAttemptEventNotifierList = new ArrayList<POMEvent>(enrichedAttemptEventNotifierList);
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("EnrichedAttemptResultConsumerThread started");
            while (this.isRunning.get()) {
                this.transformEnrichedAttemptObject();
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private EnrichedAttemptEvent transformEnrichedAttemptResultObject(EnrichedAttemptEvent enrichedAttemptEvent) {
        enrichedAttemptEvent.setRcvdTimeStamp(System.currentTimeMillis());
        enrichedAttemptEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return enrichedAttemptEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in shutdown ", e);
        }
    }

    private void transformEnrichedAttemptObject() {
        try {
            ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
            for (ConsumerRecord record : records) {
                Util.printEventMetadata((ConsumerRecord<String, String>)record);
                EnrichedAttemptEvent enrichedAttemptEvent = GsonUtil.getObject((String)record.value(), EnrichedAttemptEvent.class);
                if (enrichedAttemptEvent == null) {
                    POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                    continue;
                }
                EnrichedAttemptEvent transformedEnrichedAttemptObject = this.transformEnrichedAttemptResultObject(enrichedAttemptEvent);
                for (POMEvent pomEventListener : this.enrichedAttemptEventNotifierList) {
                    this.setOnEventForEventListener(pomEventListener, transformedEnrichedAttemptObject);
                }
            }
        }
        catch (WakeupException e) {
            if (this.isRunning.get()) {
                POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in EnrichedAttemptResultConsumerThread ", e);
        }
    }

    private void setOnEventForEventListener(POMEvent pomEventListener, EnrichedAttemptEvent transformedEnrichedAttemptObject) {
        try {
            pomEventListener.onEvent(transformedEnrichedAttemptObject);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in EnrichedAttemptResultEventConsumerCallback ", e);
        }
    }
}

