/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.appserver.security.crypto.impl;

import com.avaya.pim.appserver.security.crypto.AAODSecurityCryptoModuleWrapper;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.runtime.POMSecurityAbstractRuntimeJarLoader;
import com.avaya.pim.security.runtime.POMSecurityRuntimeJarLoader;
import com.avaya.pim.security.util.POMSecurityConstants;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

public class AAODSecurityCrypto
implements AAODSecurityCryptoModuleWrapper {
    private POMSecurityAbstractRuntimeJarLoader runtimeJarLoader = null;
    private boolean aaodDependenciesLoaded = false;

    public AAODSecurityCrypto() {
        try {
            this.runtimeJarLoader = AccessController.doPrivileged(new PrivilegedAction<POMSecurityAbstractRuntimeJarLoader>(){

                @Override
                public POMSecurityAbstractRuntimeJarLoader run() {
                    return new POMSecurityRuntimeJarLoader();
                }
            });
            this.aaodDependenciesLoaded = this.loadAAODDependencies();
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to initialize AAOD Security Crypto!", e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private boolean loadAAODDependencies() {
        boolean success = false;
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        try {
            File[] aaodDependencies;
            String AAOD_LIB_DIR_STR = POMSecurityUtils.getAAODAppserverHome() + POMSecurityConstants.AAOD_APPSERVER_LIB_DIR_REL_PATH;
            File aaodLibDir = new File(AAOD_LIB_DIR_STR);
            String javaClassPath = System.getProperty("java.class.path");
            for (File aaodDependency : aaodDependencies = aaodLibDir.listFiles()) {
                if (!aaodDependency.isFile() || !aaodDependency.getName().endsWith(".jar") || javaClassPath.indexOf(aaodDependency.getName()) != -1) continue;
                jarUrls.add(aaodDependency.toURI().toURL());
            }
            this.runtimeJarLoader.addJars(jarUrls);
            Object[] loadedURLs = this.runtimeJarLoader.getJars();
            if (loadedURLs.length > 0) {
                POMSecurityLogger.getConsoleLogger().log(Level.FINEST, "URLs Loaded: " + Arrays.toString(loadedURLs));
            }
            success = true;
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to load AAOD Dependencies!", e);
            success = false;
        }
        return success;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        byte[] encrypted = new byte[]{};
        String ENCRYPTION_FAIL_MSG = "Failed to encrypt data!";
        try {
            if (this.aaodDependenciesLoaded) {
                Class<?> clazz = this.runtimeJarLoader.loadClass("com.avaya.ade.common.utils.crypto.Crypto");
                Method method = clazz.getMethod("encrypt", POMSecurityConstants.AAOD_SECURITY_CRYPTO_ENCRYPT_DECRYPT_INPUT_PARAM_CLASS);
                Object object = method.invoke((Object)method, new Object[]{data});
                encrypted = (byte[])object;
            }
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to encrypt data!", e);
        }
        return encrypted;
    }

    @Override
    public byte[] decrypt(byte[] data) {
        byte[] decrypted = new byte[]{};
        String DECRYPTION_FAIL_MSG = "Failed to decrypt data!";
        try {
            if (this.aaodDependenciesLoaded) {
                Class<?> clazz = this.runtimeJarLoader.loadClass("com.avaya.ade.common.utils.crypto.Crypto");
                Method method = clazz.getMethod("decrypt", POMSecurityConstants.AAOD_SECURITY_CRYPTO_ENCRYPT_DECRYPT_INPUT_PARAM_CLASS);
                Object object = method.invoke((Object)method, new Object[]{data});
                decrypted = (byte[])object;
            }
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to decrypt data!", e);
        }
        return decrypted;
    }
}

