/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.crypto.impl;

import com.avaya.pim.security.crypto.POMSecurityCryptoModule;
import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.logging.Level;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class POMSecurityDefaultCrypto
implements POMSecurityCryptoModule {
    @Override
    public Object encrypt(Object value) throws POMSecurityCryptoException {
        if (value == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = this.getObjectOutputStream(bos, value);
            if (oos == null) {
                return null;
            }
            String randAlg = "SHA1PRNG";
            SecureRandom rand = SecureRandom.getInstance(randAlg);
            if (rand == null) {
                return null;
            }
            String cipherAlg = "AES";
            SecretKeySpec skey = new SecretKeySpec(POMSecurityUtils.fromHex("395abe20507c1f154ecd404f71e47c3b"), cipherAlg);
            Cipher cipher = Cipher.getInstance(cipherAlg);
            if (cipher == null) {
                return null;
            }
            cipher.init(1, skey);
            byte[] salt = new byte[8];
            rand.nextBytes(salt);
            this.writeSaltAndValueToObjectOutputStream(oos, salt, value);
            return this.getFinalEncryptedObject(bos, cipher, value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Messgae : " + e.getMessage(), e);
            throw new POMSecurityCryptoException(e.getMessage(), e);
        }
    }

    private ObjectOutputStream getObjectOutputStream(ByteArrayOutputStream bos, Object value) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            return oos;
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private void writeSaltAndValueToObjectOutputStream(ObjectOutputStream oos, byte[] salt, Object value) {
        try {
            oos.write(salt);
            oos.writeObject(value);
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
        }
    }

    private Object getFinalEncryptedObject(ByteArrayOutputStream bos, Cipher cipher, Object value) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] enc = null;
        try {
            enc = cipher.doFinal(bos.toByteArray());
            if (enc == null) {
                return null;
            }
            return encoder.encodeToString(enc);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Object decrypt(Object value) throws POMSecurityCryptoException {
        if (value == null) {
            return null;
        }
        try {
            String cipherAlg = "AES";
            SecretKeySpec skey = new SecretKeySpec(POMSecurityUtils.fromHex("395abe20507c1f154ecd404f71e47c3b"), cipherAlg);
            Cipher cipher = Cipher.getInstance(cipherAlg);
            if (cipher == null) {
                return null;
            }
            cipher.init(2, skey);
            byte[] enc = this.getEncodedByteArrayAfterDecryptingObject(cipher, value);
            if (enc == null) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(enc);
            ObjectInputStream ois = this.getObjectInputStream(bis, value);
            if (ois == null) {
                return null;
            }
            return this.getFinalDecryptedObject(ois, value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Messgae : " + e.getMessage(), e);
            throw new POMSecurityCryptoException(e.getMessage(), e);
        }
    }

    private byte[] getEncodedByteArrayAfterDecryptingObject(Cipher cipher, Object value) {
        try {
            Base64.Decoder decode = Base64.getDecoder();
            byte[] enc = cipher.doFinal(decode.decode((String)value));
            return enc;
        }
        catch (IllegalArgumentException | BadPaddingException | IllegalBlockSizeException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private ObjectInputStream getObjectInputStream(ByteArrayInputStream bis, Object value) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
            return ois;
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private Object getFinalDecryptedObject(ObjectInputStream ois, Object value) {
        try {
            ois.skipBytes(8);
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) {
        POMSecurityLogger.getConsoleLogger().log(Level.FINE, "Test Encrypt and Decrypt methods");
        POMSecurityDefaultCrypto pomSecurityCryptoModule = new POMSecurityDefaultCrypto();
        try {
            String encrypted = (String)pomSecurityCryptoModule.encrypt("Hello World");
            String decrypted = (String)pomSecurityCryptoModule.decrypt("PYglmlaw3eThFC7vz6cTayMSNa60j09k57aTrgIAToY=");
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "encrypted={0}", encrypted);
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "decrypted={0}", decrypted);
        }
        catch (POMSecurityCryptoException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error Occurred : " + e);
        }
    }
}

