/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.job.ImportStatisticsEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class ImportStatisticsEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private List<POMEvent> importStatsEventNotifierList = null;
    private int eventType = -1;

    public ImportStatisticsEventConsumerThread(List<POMEvent> importStatsEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        super("ImportStatisticsEventConsumerThread");
        this.importStatsEventNotifierList = importStatsEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("ImportStatisticsEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        ImportStatisticsEvent importStatsEvent = GsonUtil.getObject((String)record.value(), ImportStatisticsEvent.class);
                        if (importStatsEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", new Exception("Failed to reconstruct import statistics event object from the json string."));
                            continue;
                        }
                        ImportStatisticsEvent transformedImportStatsEvent = this.transformImportEventObject(importStatsEvent);
                        for (POMEvent importEventListener : this.importStatsEventNotifierList) {
                            this.onImportEvent(importEventListener, transformedImportStatsEvent);
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in ImportStatsEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private void onImportEvent(POMEvent importEventListener, ImportStatisticsEvent transformedImportStatsEvent) {
        try {
            importEventListener.onEvent(transformedImportStatsEvent);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in ImportStatsEventConsumerCallback ", e);
        }
    }

    private ImportStatisticsEvent transformImportEventObject(ImportStatisticsEvent importsEvent) {
        importsEvent.setRcvdTimeStamp(System.currentTimeMillis());
        importsEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return importsEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().finest("Error occured while shutting down");
        }
    }
}

