/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.skill.InboundSkillEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class InboundSkillEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> inboundSkillEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public InboundSkillEventConsumerThread(List<POMEvent> inboundSkillEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.inboundSkillEventNotifierList = inboundSkillEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("InboundSkillEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        InboundSkillEvent inboundSkillsEvent = GsonUtil.getObject((String)record.value(), InboundSkillEvent.class);
                        if (inboundSkillsEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        InboundSkillEvent jobInfo = this.transformInboundSkillEventObject(inboundSkillsEvent);
                        for (POMEvent pomEventListener : this.inboundSkillEventNotifierList) {
                            this.onInboundEvent(pomEventListener, jobInfo);
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in InboundSkillEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private void onInboundEvent(POMEvent pomEventListener, InboundSkillEvent jobInfo) {
        try {
            pomEventListener.onEvent(jobInfo);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in InboundSkillEventConsumerCallback ", e);
        }
    }

    private InboundSkillEvent transformInboundSkillEventObject(InboundSkillEvent inboundSkillEvent) {
        inboundSkillEvent.setRcvdTimeStamp(System.currentTimeMillis());
        inboundSkillEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return inboundSkillEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().finest("Error occured while shutting down");
        }
    }
}

