/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.job.JobStatisticsEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class JobStatisticsEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> jobStatisticsEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public JobStatisticsEventConsumerThread(List<POMEvent> jobStatisticsEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.jobStatisticsEventNotifierList = jobStatisticsEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("JobStatisticsEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        JobStatisticsEvent jobStatisticsInfo = GsonUtil.getObject((String)record.value(), JobStatisticsEvent.class);
                        if (jobStatisticsInfo == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        JobStatisticsEvent transformedJobStatisticsObject = this.transformJobStatisticsObject(jobStatisticsInfo);
                        for (POMEvent pomEventListener : this.jobStatisticsEventNotifierList) {
                            try {
                                pomEventListener.onEvent(transformedJobStatisticsObject);
                            }
                            catch (Exception e) {
                                POMEventLoggerHolder.getInstance().getLogger().error("Error in JobStatisticsEventConsumerThread ", e);
                            }
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private JobStatisticsEvent transformJobStatisticsObject(JobStatisticsEvent jobStatisticsInfo) {
        jobStatisticsInfo.setRcvdTimeStamp(System.currentTimeMillis());
        jobStatisticsInfo.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return jobStatisticsInfo;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

