/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.job.JobEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class JobEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> jobEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public JobEventConsumerThread(List<POMEvent> jobEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.jobEventNotifierList = jobEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("JobEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        JobEvent jobEvent = GsonUtil.getObject((String)record.value(), JobEvent.class);
                        if (jobEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        JobEvent jobInfo = this.transformJobEventObject(jobEvent);
                        for (POMEvent pomEventListener : this.jobEventNotifierList) {
                            try {
                                pomEventListener.onEvent(jobInfo);
                            }
                            catch (Exception e) {
                                POMEventLoggerHolder.getInstance().getLogger().error("Error in JobEventConsumerCallback ", e);
                            }
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private JobEvent transformJobEventObject(JobEvent jobEvent) {
        jobEvent.setRcvdTimeStamp(System.currentTimeMillis());
        jobEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        POMEventLoggerHolder.getInstance().fine("jobInfo :" + jobEvent);
        return jobEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

