/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.rest;

import com.avaya.pim.eventsdk.common.EventSDKConfig;
import com.avaya.pim.eventsdk.exception.IPOMEventErrorCode;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLProtocolSocketFactory
extends SSLSocketFactory {
    private static final String TRUST_STORE_PASSWORD_DECRYPTED = EventSDKConfig.getInstance().getTrustStorePasswordDecrypted();
    private static final String TRUST_STORE_PATH = EventSDKConfig.getInstance().getTrustStorePath();
    private static final String KEY_STORE_PASSWORD_DECRYPTED = EventSDKConfig.getInstance().getKeyStorePasswordDecrypted();
    private static final String KEY_STORE_PATH = EventSDKConfig.getInstance().getKeyStorePath();
    private static String[] enabledProtocols = new String[]{"TLSv1.2"};
    private static SSLProtocolSocketFactory instance = null;
    private SSLContext sslcontext = null;
    private SSLSocketFactory underlyingSSLSocketFactory = null;
    private SSLServerSocketFactory underlyingSSLServerSocketFactory = null;

    private SSLProtocolSocketFactory() {
    }

    public static synchronized SSLProtocolSocketFactory getInstance() throws POMEventException {
        if (instance == null) {
            instance = new SSLProtocolSocketFactory();
            instance.initializeSSLContext();
        }
        return instance;
    }

    private void initializeSSLContext() throws POMEventException {
        FileInputStream trustStoreInputStream = null;
        FileInputStream keyStoreInputStream = null;
        if (this.sslcontext == null) {
            try {
                this.sslcontext = SSLContext.getInstance("SSL");
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextInt();
                String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStoreInputStream = new FileInputStream(KEY_STORE_PATH);
                keyStore.load(keyStoreInputStream, KEY_STORE_PASSWORD_DECRYPTED.toCharArray());
                KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(algorithm);
                kmFactory.init(keyStore, KEY_STORE_PASSWORD_DECRYPTED.toCharArray());
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStoreInputStream = new FileInputStream(TRUST_STORE_PATH);
                trustStore.load(trustStoreInputStream, TRUST_STORE_PASSWORD_DECRYPTED.toCharArray());
                TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(algorithm);
                tmFactory.init(trustStore);
                this.sslcontext.init(kmFactory.getKeyManagers(), tmFactory.getTrustManagers(), secureRandom);
            }
            catch (Exception e) {
                POMEventLoggerHolder.getInstance().error("Unable to create SSL Factory", e);
                throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_CREATE_SSLCONTEXT, "Please check the trust/key store path and password configuration");
            }
            finally {
                if (trustStoreInputStream != null) {
                    try {
                        trustStoreInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.underlyingSSLSocketFactory = this.sslcontext.getSocketFactory();
        this.underlyingSSLServerSocketFactory = this.sslcontext.getServerSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.underlyingSSLSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.underlyingSSLServerSocketFactory;
    }

    public SSLContext getPomSSLContext() {
        return this.sslcontext;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.underlyingSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.underlyingSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(socket, host, port, autoClose);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    private Socket overrideProtocol(Socket socket) throws SocketException {
        socket.setKeepAlive(true);
        if (socket instanceof SSLSocket && enabledProtocols != null && enabledProtocols.length > 0) {
            ((SSLSocket)socket).setEnabledProtocols(enabledProtocols);
            String[] enabledCiphers = EventSDKConfig.getInstance().getEnabledCipherSuites();
            if (enabledCiphers != null && enabledCiphers.length != 0) {
                ((SSLSocket)socket).setEnabledCipherSuites(enabledCiphers);
            }
        }
        return socket;
    }
}

