/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security;

import com.avaya.pim.security.crypto.POMSecurityCryptoModule;
import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.mode.POMSecurityCryptoMode;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.NoSuchPaddingException;

public final class POMSecurityManager {
    private static final Logger CONSOLE_LOGGER = POMSecurityLogger.getConsoleLogger();
    private static POMSecurityManager securityManager;

    private POMSecurityManager() {
    }

    private static synchronized void initializePOMSecurityManager() {
        securityManager = new POMSecurityManager();
    }

    public static synchronized POMSecurityManager getInstance() {
        if (securityManager == null) {
            POMSecurityManager.initializePOMSecurityManager();
        }
        return securityManager;
    }

    public Object encrypt(Object value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (value == null) {
            return null;
        }
        try {
            POMSecurityCryptoModule cryptoModule = POMSecurityUtils.getPOMSecurityCryptoModule();
            return cryptoModule.encrypt(value);
        }
        catch (POMSecurityCryptoException e) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in encryption : " + e.getMessage(), e);
            if (e.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e.getCause();
            }
            if (e.getCause() instanceof NoSuchPaddingException) {
                throw (NoSuchPaddingException)e.getCause();
            }
            if (e.getCause() instanceof InvalidKeyException) {
                throw (InvalidKeyException)e.getCause();
            }
            return "";
        }
        catch (Exception e1) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in decryption : " + e1.getMessage(), e1);
            return "";
        }
    }

    public Object decrypt(Object value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        if (value == null) {
            return null;
        }
        try {
            POMSecurityCryptoModule cryptoModule = POMSecurityUtils.getPOMSecurityCryptoModule();
            return cryptoModule.decrypt(value);
        }
        catch (POMSecurityCryptoException e) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in decryption : " + e.getMessage(), e);
            if (e.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e.getCause();
            }
            if (e.getCause() instanceof NoSuchPaddingException) {
                throw (NoSuchPaddingException)e.getCause();
            }
            if (e.getCause() instanceof InvalidKeyException) {
                throw (InvalidKeyException)e.getCause();
            }
            return "";
        }
        catch (Exception e1) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in decryption : " + e1.getMessage(), e1);
            return "";
        }
    }

    public Object encrypt(Object value, POMSecurityCryptoMode pomSecurityCryptoMode) {
        if (value == null) {
            return null;
        }
        try {
            POMSecurityCryptoModule cryptoModule = POMSecurityUtils.getPOMSecurityCryptoModule(pomSecurityCryptoMode);
            return cryptoModule.encrypt(value);
        }
        catch (POMSecurityCryptoException e) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in encryption : " + e.getMessage(), e);
            return null;
        }
    }

    public Object decrypt(Object value, POMSecurityCryptoMode pomSecurityCryptoMode) {
        if (value == null) {
            return null;
        }
        try {
            POMSecurityCryptoModule cryptoModule = POMSecurityUtils.getPOMSecurityCryptoModule(pomSecurityCryptoMode);
            return cryptoModule.decrypt(value);
        }
        catch (POMSecurityCryptoException e) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Error in decryption : " + e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) {
        POMSecurityManager securityManager = POMSecurityManager.getInstance();
        String defaultModeEncrypt = (String)securityManager.encrypt("Hello World", POMSecurityCryptoMode.DEFAULT_CRYPTO);
        String defaultModeDecrypt = (String)securityManager.decrypt("PYglmlaw3eThFC7vz6cTayMSNa60j09k57aTrgIAToY=", POMSecurityCryptoMode.DEFAULT_CRYPTO);
        CONSOLE_LOGGER.log(Level.FINE, "\n Default Mode Encrypt\t: {0} \n Default Mode Decrypt\t: {1}", new Object[]{defaultModeEncrypt, defaultModeDecrypt});
        String fipsModeEncrypt = (String)securityManager.encrypt("Hello World", POMSecurityCryptoMode.FIPS_CRYPTO);
        String fipsModeDecrypt = (String)securityManager.decrypt("jEpdwFXQHbLpQfytcHsFUsKvkzEyFBsPWXSrCHKvztjmRaFooGDlFiTgBCfQlw==", POMSecurityCryptoMode.FIPS_CRYPTO);
        CONSOLE_LOGGER.log(Level.FINE, "\n FIPS Mode Encrypt\t: {0} \n FIPS Mode Decrypt\t: {1}", new Object[]{fipsModeEncrypt, fipsModeDecrypt});
    }

    static {
        try {
            POMSecurityManager.initializePOMSecurityManager();
        }
        catch (RuntimeException e) {
            CONSOLE_LOGGER.log(Level.SEVERE, "Failed to Initialize POM Security Manager", e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

