/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;

class KStreamFlatMapValues<KIn, VIn, VOut>
implements ProcessorSupplier<KIn, VIn, KIn, VOut> {
    private final ValueMapperWithKey<? super KIn, ? super VIn, ? extends Iterable<? extends VOut>> mapper;

    KStreamFlatMapValues(ValueMapperWithKey<? super KIn, ? super VIn, ? extends Iterable<? extends VOut>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<KIn, VIn, KIn, VOut> get() {
        return new KStreamFlatMapValuesProcessor();
    }

    private class KStreamFlatMapValuesProcessor
    extends ContextualProcessor<KIn, VIn, KIn, VOut> {
        private KStreamFlatMapValuesProcessor() {
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            Iterable newValues = (Iterable)KStreamFlatMapValues.this.mapper.apply(record.key(), record.value());
            for (Object v : newValues) {
                this.context().forward(record.withValue(v));
            }
        }
    }
}

