/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;

public class TimestampedKeyValueStoreMaterializer<K, V> {
    private final MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized;

    public TimestampedKeyValueStoreMaterializer(MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        this.materialized = materialized;
    }

    public StoreBuilder<TimestampedKeyValueStore<K, V>> materialize() {
        KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)this.materialized.storeSupplier();
        if (supplier == null) {
            switch (this.materialized.storeType()) {
                case IN_MEMORY: {
                    supplier = Stores.inMemoryKeyValueStore(this.materialized.storeName());
                    break;
                }
                case ROCKS_DB: {
                    supplier = Stores.persistentTimestampedKeyValueStore(this.materialized.storeName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown store type: " + (Object)((Object)this.materialized.storeType()));
                }
            }
        }
        StoreBuilder<TimestampedKeyValueStore<K, V>> builder = Stores.timestampedKeyValueStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }
}

