/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class WindowedStreamPartitioner<K, V>
implements StreamPartitioner<Windowed<K>, V> {
    private final WindowedSerializer<K> serializer;

    public WindowedStreamPartitioner(WindowedSerializer<K> serializer) {
        this.serializer = serializer;
    }

    @Override
    public Integer partition(String topic, Windowed<K> windowedKey, V value, int numPartitions) {
        byte[] keyBytes = this.serializer.serializeBaseKey(topic, windowedKey);
        return Utils.toPositive((int)Utils.murmur2((byte[])keyBytes)) % numPartitions;
    }
}

