/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.agent.AgentEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class AgentEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private List<POMEvent> agentEventNotifierList = null;
    private int eventType = -1;

    public AgentEventConsumerThread(List<POMEvent> agentEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        super("AgentEventConsumerThread");
        this.agentEventNotifierList = agentEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("AgentEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        AgentEvent agentEvent = GsonUtil.getObject((String)record.value(), AgentEvent.class);
                        if (agentEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", new Exception("Failed to reconstruct agent event object from the json string."));
                            continue;
                        }
                        AgentEvent transformedAgentEvent = this.transformAgentEventObject(agentEvent);
                        for (POMEvent agentEventListener : this.agentEventNotifierList) {
                            try {
                                agentEventListener.onEvent(transformedAgentEvent);
                            }
                            catch (Exception e) {
                                POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentEventConsumerCallback ", e);
                            }
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private AgentEvent transformAgentEventObject(AgentEvent agentEvent) {
        agentEvent.setRcvdTimeStamp(System.currentTimeMillis());
        agentEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return agentEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

