/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.util;

import com.avaya.pim.security.POMSecurityManager;
import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.exception.POMSecurityException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.util.POMSecurityConstants;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class POMCertificateUtils {
    private static POMSecurityManager securityManager = POMSecurityManager.getInstance();

    private POMCertificateUtils() {
        throw new IllegalStateException("Utility classes, which are collections of static members, are not meant to be instantiated. Even abstract utility classes, which can be extended should not have public constructors. Java adds an implicit public constructor to every class which does not define at least one explicitly. Hence, at least one non-public constructor should be defined.");
    }

    public static String getKeyStoreType() {
        if (POMSecurityUtils.isBCFIPSInstalled()) {
            return "BCFKS";
        }
        return "JKS";
    }

    public static String getKeyStorePath() {
        if (POMSecurityUtils.isBCFIPSInstalled()) {
            return POMSecurityUtils.getApplicationHome() + "/" + "config" + "/" + "pomKeyStore.bks";
        }
        return POMSecurityUtils.getApplicationHome() + "/" + "config" + "/" + "pomKeyStore";
    }

    public static String getTrustStorePath() {
        if (POMSecurityUtils.isBCFIPSInstalled()) {
            return POMSecurityUtils.getApplicationHome() + "/" + "config" + "/" + "pomTrustStore.bks";
        }
        return POMSecurityUtils.getApplicationHome() + "/" + "config" + "/" + "pomTrustStore";
    }

    public static String getTrustStoreXMLPath() {
        return POMSecurityUtils.getApplicationHome() + "/" + "config" + "/" + "pomTrustStore.xml";
    }

    public static String getKeyStorePassword() {
        String keyStorePass;
        block3: {
            keyStorePass = "";
            String DECRYPTION_FAIL_RETURN_DEFAULT_PASS_MSG = "POM Decryption Mechanism has failed. Returning default keystore password instead of null or empty password. ";
            try {
                keyStorePass = (String)securityManager.decrypt(POMSecurityUtils.getPropertyValueFromPropertiesFile(POMSecurityUtils.getApplicationHome() + "/config/common.properties", "POM_KEYSTORE_PASSWORD"));
                if (POMSecurityUtils.isStringNullOrEmpty(keyStorePass)) {
                    POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "POM Decryption Mechanism has failed. Returning default keystore password instead of null or empty password. ", new POMSecurityCryptoException("POM Decryption Mechanism has failed. Returning default keystore password instead of null or empty password. "));
                    keyStorePass = POMSecurityUtils.fallbackMechanismForFailedDecryption("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "POM Decryption Mechanism has failed. Returning default keystore password instead of null or empty password. ", e);
                if (!POMSecurityUtils.isStringNullOrEmpty(keyStorePass)) break block3;
                keyStorePass = POMSecurityUtils.fallbackMechanismForFailedDecryption("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
            }
        }
        return keyStorePass;
    }

    public static boolean updateKeyStorePassword(String newKeyStorePass) {
        boolean updationStatus = false;
        if (POMSecurityUtils.isStringNullOrEmpty(newKeyStorePass)) {
            String errMsg = "Null or Empty Keystore Password Provided.";
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, errMsg, new IllegalArgumentException(errMsg));
            return updationStatus;
        }
        String newKeyStorePassEncrypted = "";
        try {
            newKeyStorePassEncrypted = (String)securityManager.encrypt(newKeyStorePass);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to encrypt while updating POM keystore password", e);
            return false;
        }
        String newKeyStorePassEncryptedFinal = newKeyStorePassEncrypted;
        String POM_HOME = POMSecurityUtils.getApplicationHome();
        ArrayList failedToUpdateEntries = new ArrayList();
        POMSecurityConstants.POM_ALL_KEYSTORE_ENCRYPTED_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> propertyKeyList.forEach(propertyKey -> {
            if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, newKeyStorePassEncryptedFinal)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_KEYSTORE_PLAIN_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> propertyKeyList.forEach(propertyKey -> {
            if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, newKeyStorePass)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_KEYSTORE_PLAIN_PASS_CONFIG_XML_LOCATIONS.forEach((file, attrAndEleMapList) -> attrAndEleMapList.forEach(attrAndEleMap -> {
            String element = (String)attrAndEleMap.get("XML_ELEMENT");
            String attribute = (String)attrAndEleMap.get("XML_ATTRIBUTE");
            if (!POMSecurityUtils.updateAttributeOfElementInXML(POM_HOME + file, element, attribute, newKeyStorePass)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_KEYSTORE_FLAG_BASED_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> {
            boolean isPassEncrypted = false;
            switch (file) {
                case "/bin/conf/eventsdk.properties": {
                    isPassEncrypted = Boolean.parseBoolean((String)POMSecurityUtils.getPropertyValueFromPropertiesFile(POM_HOME + file, "pom.eventsdk.use.encrypted.passwords"));
                    break;
                }
            }
            String pass = isPassEncrypted ? newKeyStorePassEncryptedFinal : newKeyStorePass;
            propertyKeyList.forEach(propertyKey -> {
                if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, pass)) {
                    failedToUpdateEntries.add(POM_HOME + file);
                }
            });
        });
        updationStatus = failedToUpdateEntries.isEmpty();
        if (!updationStatus) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to update keystore password in the files : " + failedToUpdateEntries);
        }
        return updationStatus;
    }

    public static String getTrustStorePassword() {
        String trustStorePass;
        block3: {
            trustStorePass = "";
            String DECRYPTION_FAIL_RETURN_DEFAULT_PASS_MSG = "POM Decryption Mechanism has failed. Returning default truststore password instead of null or empty password. ";
            try {
                trustStorePass = (String)securityManager.decrypt(POMSecurityUtils.getPropertyValueFromPropertiesFile(POMSecurityUtils.getApplicationHome() + "/config/common.properties", "POM_TRUSTSTORE_PASSWORD"));
                if (POMSecurityUtils.isStringNullOrEmpty(trustStorePass)) {
                    POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "POM Decryption Mechanism has failed. Returning default truststore password instead of null or empty password. ", new POMSecurityCryptoException("POM Decryption Mechanism has failed. Returning default truststore password instead of null or empty password. "));
                    trustStorePass = POMSecurityUtils.fallbackMechanismForFailedDecryption("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "POM Decryption Mechanism has failed. Returning default truststore password instead of null or empty password. ", e);
                if (!POMSecurityUtils.isStringNullOrEmpty(trustStorePass)) break block3;
                trustStorePass = POMSecurityUtils.fallbackMechanismForFailedDecryption("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
            }
        }
        return trustStorePass;
    }

    public static boolean updateTrustStorePassword(String newTrustStorePass) {
        boolean updationStatus = false;
        if (POMSecurityUtils.isStringNullOrEmpty(newTrustStorePass)) {
            String errMsg = "Null or Empty Truststore Password Provided.";
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, errMsg, new IllegalArgumentException(errMsg));
            return updationStatus;
        }
        String newTrustStorePassEncrypted = "";
        try {
            newTrustStorePassEncrypted = (String)securityManager.encrypt(newTrustStorePass);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to encrypt while updating POM truststore password", e);
            return false;
        }
        String newTrustStorePassEncryptedFinal = newTrustStorePassEncrypted;
        String POM_HOME = POMSecurityUtils.getApplicationHome();
        ArrayList failedToUpdateEntries = new ArrayList();
        POMSecurityConstants.POM_ALL_TRUSTSTORE_ENCRYPTED_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> propertyKeyList.forEach(propertyKey -> {
            if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, newTrustStorePassEncryptedFinal)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_TRUSTSTORE_PLAIN_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> propertyKeyList.forEach(propertyKey -> {
            if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, newTrustStorePass)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_TRUSTSTORE_PLAIN_PASS_CONFIG_XML_LOCATIONS.forEach((file, attrAndEleMapList) -> attrAndEleMapList.forEach(attrAndEleMap -> {
            String element = (String)attrAndEleMap.get("XML_ELEMENT");
            String attribute = (String)attrAndEleMap.get("XML_ATTRIBUTE");
            if (!POMSecurityUtils.updateAttributeOfElementInXML(POM_HOME + file, element, attribute, newTrustStorePass)) {
                failedToUpdateEntries.add(POM_HOME + file);
            }
        }));
        POMSecurityConstants.POM_ALL_TRUSTSTORE_FLAG_BASED_PASS_CONFIG_PROPS_LOCATIONS.forEach((file, propertyKeyList) -> {
            boolean isPassEncrypted = false;
            switch (file) {
                case "/bin/conf/eventsdk.properties": {
                    isPassEncrypted = Boolean.parseBoolean((String)POMSecurityUtils.getPropertyValueFromPropertiesFile(POM_HOME + file, "pom.eventsdk.use.encrypted.passwords"));
                    break;
                }
            }
            String pass = isPassEncrypted ? newTrustStorePassEncryptedFinal : newTrustStorePass;
            propertyKeyList.forEach(propertyKey -> {
                if (!POMSecurityUtils.updatePropertyValueInPropertiesFile(POM_HOME + file, propertyKey, pass)) {
                    failedToUpdateEntries.add(POM_HOME + file);
                }
            });
        });
        updationStatus = failedToUpdateEntries.isEmpty();
        if (!updationStatus) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to update truststore password in the files : " + failedToUpdateEntries);
        }
        return updationStatus;
    }

    public static boolean isAliasPresentInCertificateStore(String alias, String certificateStorePath, String certificateStoreType, String certificateStorePassword) {
        boolean isAliasPresent = Boolean.FALSE;
        try {
            KeyStore certificateStore = KeyStore.getInstance(certificateStoreType);
            try (FileInputStream certificateStream = new FileInputStream(certificateStorePath);){
                certificateStore.load(certificateStream, certificateStorePassword.toCharArray());
            }
            if (certificateStore.containsAlias(alias) || certificateStore.isCertificateEntry(alias)) {
                isAliasPresent = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to check if alias = [" + alias + "] is present certificate store = [" + certificateStorePath + "] ", e);
        }
        return isAliasPresent;
    }

    public static boolean isCertificatePresentInCertificateStore(X509Certificate certificate, String certificateStorePath, String certificateStoreType, String certificateStorePassword) {
        boolean isCertificatePresent = Boolean.FALSE;
        try {
            KeyStore certificateStore = KeyStore.getInstance(certificateStoreType);
            try (FileInputStream certificateStream = new FileInputStream(certificateStorePath);){
                certificateStore.load(certificateStream, certificateStorePassword.toCharArray());
            }
            Enumeration<String> aliases = certificateStore.aliases();
            while (aliases.hasMoreElements()) {
                if (!certificate.equals((X509Certificate)certificateStore.getCertificate(aliases.nextElement()))) continue;
                isCertificatePresent = Boolean.TRUE;
                break;
            }
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to check if certificate is present certificate store = [" + certificateStorePath + "] ", e);
        }
        return isCertificatePresent;
    }

    public static X509Certificate[] getCertificatesFromFile(String certificateFile) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try {
            ByteArrayInputStream byteStream = null;
            Throwable throwable = null;
            try (DataInputStream dataStream = new DataInputStream(new FileInputStream(certificateFile));){
                byte[] bytes = new byte[dataStream.available()];
                dataStream.readFully(bytes);
                byteStream = new ByteArrayInputStream(bytes);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Certificate certificate : CertificateFactory.getInstance("X.509").generateCertificates(byteStream)) {
                certificates.add((X509Certificate)certificate);
            }
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to get certificates from certificate file = [" + certificateFile + "]", e);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static boolean isAliasPresentInPOMTruststore(String alias) {
        return POMCertificateUtils.isAliasPresentInCertificateStore(alias, POMCertificateUtils.getTrustStorePath(), POMCertificateUtils.getKeyStoreType(), POMCertificateUtils.getTrustStorePassword());
    }

    public static boolean isCertificatePresentInPOMTruststore(X509Certificate certificate) {
        return POMCertificateUtils.isCertificatePresentInCertificateStore(certificate, POMCertificateUtils.getTrustStorePath(), POMCertificateUtils.getKeyStoreType(), POMCertificateUtils.getTrustStorePassword());
    }

    public static String getAliasOfCertificateInPOMTruststore(X509Certificate certificate) {
        String alias = null;
        try {
            KeyStore certificateStore = KeyStore.getInstance(POMCertificateUtils.getKeyStoreType());
            try (FileInputStream certificateStream = new FileInputStream(POMCertificateUtils.getTrustStorePath());){
                certificateStore.load(certificateStream, POMCertificateUtils.getTrustStorePassword().toCharArray());
            }
            Enumeration<String> aliases = certificateStore.aliases();
            while (aliases.hasMoreElements()) {
                String nextAlias = aliases.nextElement();
                if (!certificate.equals((X509Certificate)certificateStore.getCertificate(nextAlias))) continue;
                alias = nextAlias;
                break;
            }
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to get alias of certificate from POM Truststore.", e);
        }
        return alias;
    }

    public static void addCertificateInPOMTruststore(String alias, X509Certificate certificate) {
        if (POMCertificateUtils.isAliasPresentInPOMTruststore(alias)) {
            throw new POMSecurityException("Given alias = [" + alias + "] already exists.");
        }
        if (POMCertificateUtils.isCertificatePresentInPOMTruststore(certificate)) {
            throw new POMSecurityException("Given certificate with serial number " + certificate.getSerialNumber() + " already exists in POM Truststore with alias = [" + POMCertificateUtils.getAliasOfCertificateInPOMTruststore(certificate) + "]");
        }
        try {
            KeyStore truststore = KeyStore.getInstance(POMCertificateUtils.getKeyStoreType());
            String truststorePath = POMCertificateUtils.getTrustStorePath();
            char[] truststorePass = POMCertificateUtils.getTrustStorePassword().toCharArray();
            try (FileInputStream inputStream = new FileInputStream(truststorePath);){
                truststore.load(inputStream, truststorePass);
            }
            truststore.setCertificateEntry(alias, certificate);
            var6_7 = null;
            try (FileOutputStream outputStream = new FileOutputStream(truststorePath);){
                truststore.store(outputStream, truststorePass);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            POMCertificateUtils.addCertificateNodeInPOMTruststoreXML(alias, certificate);
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to add certificate [ alias = " + alias + " , serial number = " + certificate.getSerialNumber() + " ] in POM Truststore.", e);
        }
    }

    public static String getFullCertificateText(X509Certificate certificate) throws CertificateEncodingException {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuffer strBuffer = new StringBuffer();
        String certBegin = "-----BEGIN CERTIFICATE-----\n";
        String certEnd = "-----END CERTIFICATE-----";
        String encodedCertificate = new String(encoder.encode(certificate.getEncoded()), StandardCharsets.UTF_8);
        strBuffer.append(certBegin).append(encodedCertificate).append(certEnd);
        return strBuffer.toString();
    }

    public static void addCertificateNodeInPOMTruststoreXML(String alias, X509Certificate certificate) throws TransformerException, CertificateEncodingException, SAXException, IOException, ParserConfigurationException {
        try {
            Document document = POMSecurityUtils.getW3CDomDocument(new File(POMCertificateUtils.getTrustStoreXMLPath()));
            Element root = document.getDocumentElement();
            Element truststoreElement = document.createElement("truststore");
            root.appendChild(truststoreElement);
            Element aliasElement = document.createElement("alias");
            aliasElement.appendChild(document.createTextNode(alias));
            truststoreElement.appendChild(aliasElement);
            Element certificateElement = document.createElement("certificate");
            certificateElement.appendChild(document.createTextNode(POMCertificateUtils.getFullCertificateText(certificate)));
            truststoreElement.appendChild(certificateElement);
            root.appendChild(truststoreElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(new File(POMCertificateUtils.getTrustStoreXMLPath())));
        }
        catch (Exception e) {
            throw new POMSecurityException("Failed to add certificate node [ alias = " + alias + " , serial number = " + certificate.getSerialNumber() + " ] in pomTruststore.xml file.", e);
        }
    }
}

