/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.appserver.security;

import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.util.logging.Level;
import org.apache.coyote.http11.Http11Nio2Protocol;

public class PIMAppServerPasswordMgr
extends Http11Nio2Protocol {
    public void setKeystorePass(String encryptedPassword) {
        String decryptedPass = "";
        try {
            decryptedPass = (String)POMSecurityUtils.getPOMSecurityCryptoModule().decrypt(encryptedPassword);
            super.setKeystorePass(decryptedPass);
        }
        catch (POMSecurityCryptoException psce) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "POMSecurityCryptoException during decryption of " + encryptedPassword + ". Exception - " + psce.getMessage(), psce);
            super.setKeystorePass("");
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Issue with decryption of " + encryptedPassword + ". Exception - " + e.getMessage(), e);
            super.setKeystorePass("");
        }
    }
}

