/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.cli.helper;

import com.avaya.pim.security.exception.POMSecurityException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.util.POMCertificateUtils;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class UpdatePOMCertificateStorePasswordCLIHelper {
    private UpdatePOMCertificateStorePasswordCLIHelper() {
        throw new IllegalAccessError("Instantiation Prohibited.");
    }

    private static void printOnConsole(String text) {
        System.out.println(text);
    }

    private static void abnormalExit() {
        System.exit(1);
    }

    private static void notifyFailureToParentProcessAndExit(String errMsg) {
        POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, errMsg, new POMSecurityException(errMsg));
        UpdatePOMCertificateStorePasswordCLIHelper.abnormalExit();
    }

    private static void notifyFailureToParentProcessAndExit(String errMsg, Throwable e) {
        POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, errMsg, new POMSecurityException(errMsg, e));
        UpdatePOMCertificateStorePasswordCLIHelper.abnormalExit();
    }

    public static void main(String[] args) {
        String inputString = args[0];
        if (POMSecurityUtils.isStringNullOrEmpty(inputString)) {
            UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit("Input can not be null or empty.");
        }
        Integer input = null;
        POMCertificateStoreInput pomCertificateStoreInput = null;
        try {
            input = Integer.valueOf(inputString);
            pomCertificateStoreInput = (POMCertificateStoreInput)((Object)POMCertificateStoreInput.inputToEnumMap.get(input));
            if (null == pomCertificateStoreInput) {
                UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit("Invalid Integer Input value provided.");
            }
        }
        catch (NumberFormatException e) {
            UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit("Input value is not a valid integer.", e);
        }
        String newPass = args[1];
        if (POMSecurityUtils.isStringNullOrEmpty(newPass)) {
            UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit("New Password can not be null or empty.");
        }
        String CERT_STORE_PASS_UPDATE_ERR_MSG = "Failed to update POM Configuration Files containing " + pomCertificateStoreInput.getKeyword() + " password!";
        String CERT_STORE_PASS_UPDATE_SUCCESS_MSG = "POM Configuration Files containing " + pomCertificateStoreInput.getKeyword() + " password have been successfully updated!";
        try {
            if (!UpdatePOMCertificateStorePasswordCLIHelper.updatePOMCertificateStorePassword(pomCertificateStoreInput, newPass)) {
                UpdatePOMCertificateStorePasswordCLIHelper.printOnConsole(CERT_STORE_PASS_UPDATE_ERR_MSG);
                UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit(CERT_STORE_PASS_UPDATE_ERR_MSG);
            } else {
                UpdatePOMCertificateStorePasswordCLIHelper.printOnConsole(CERT_STORE_PASS_UPDATE_SUCCESS_MSG);
                POMSecurityLogger.getConsoleLogger().log(Level.FINE, CERT_STORE_PASS_UPDATE_SUCCESS_MSG);
            }
        }
        catch (Exception e) {
            UpdatePOMCertificateStorePasswordCLIHelper.notifyFailureToParentProcessAndExit(CERT_STORE_PASS_UPDATE_ERR_MSG, e);
        }
    }

    private static boolean updatePOMCertificateStorePassword(POMCertificateStoreInput option, String password) {
        String previousVal = null;
        boolean isPasswordUpdated = false;
        if (POMCertificateStoreInput.POM_TRUSTSTORE == option) {
            previousVal = POMCertificateUtils.getTrustStorePassword();
            isPasswordUpdated = previousVal == null || !previousVal.equals(password) ? POMCertificateUtils.updateTrustStorePassword(password) : true;
        } else if (POMCertificateStoreInput.POM_KEYSTORE == option) {
            previousVal = POMCertificateUtils.getKeyStorePassword();
            isPasswordUpdated = previousVal == null || !previousVal.equals(password) ? POMCertificateUtils.updateKeyStorePassword(password) : true;
        }
        return isPasswordUpdated;
    }

    private static enum POMCertificateStoreInput {
        POM_TRUSTSTORE(1, "truststore"),
        POM_KEYSTORE(2, "keystore");

        private int input;
        private String keyword;
        private static Map<Integer, POMCertificateStoreInput> inputToEnumMap;

        private POMCertificateStoreInput(int input, String keyword) {
            this.input = input;
            this.keyword = keyword;
        }

        public int getInput() {
            return this.input;
        }

        public String getKeyword() {
            return this.keyword;
        }

        static {
            inputToEnumMap = new HashMap<Integer, POMCertificateStoreInput>();
            for (POMCertificateStoreInput pomCertificateStoreInput : POMCertificateStoreInput.values()) {
                inputToEnumMap.put(pomCertificateStoreInput.getInput(), pomCertificateStoreInput);
            }
        }
    }
}

