/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.core;

import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.core.SubscriberInfo;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EventSubscriberHolder {
    private Map<String, SubscriberInfo> eventNotifierMap = new HashMap<String, SubscriberInfo>();

    private static synchronized String getUniqueId() {
        return UUID.randomUUID().toString();
    }

    public String addNotifier(EventTypeEnum eventTypeEnum, POMEvent eventImpl) {
        if (eventTypeEnum == null) {
            return null;
        }
        String uniqueId = EventSubscriberHolder.getUniqueId();
        SubscriberInfo subscriberInfo = new SubscriberInfo(eventTypeEnum.getValue(), eventImpl);
        this.eventNotifierMap.put(uniqueId, subscriberInfo);
        POMEventLoggerHolder.getInstance().fine("registered with " + uniqueId);
        return uniqueId;
    }

    public boolean removeNotifier(String uniqueId) {
        SubscriberInfo subscriberInfo = this.eventNotifierMap.remove(uniqueId);
        if (subscriberInfo != null) {
            POMEventLoggerHolder.getInstance().fine("removed " + uniqueId);
        }
        return true;
    }

    public List<POMEvent> getEventNotifierList(int eventType) {
        ArrayList<POMEvent> eventNotifierList = new ArrayList<POMEvent>();
        for (Map.Entry<String, SubscriberInfo> notifierEntry : this.eventNotifierMap.entrySet()) {
            SubscriberInfo subscriberInfo = notifierEntry.getValue();
            if (eventType != subscriberInfo.getEventType()) continue;
            eventNotifierList.add(subscriberInfo.getPomEvent());
        }
        POMEventLoggerHolder.getInstance().fine("eventType " + eventType + " registered listener " + eventNotifierList.size());
        return eventNotifierList;
    }
}

